/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public final class Address {
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    private static final byte[] parseV4(String string) {
        byte[] byArray = new byte[4];
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            if (c >= '0' && c <= '9') {
                if (n4 == 3) {
                    return null;
                }
                if (n4 > 0 && n3 == 0) {
                    return null;
                }
                ++n4;
                n3 *= 10;
                if ((n3 += c - 48) > 255) {
                    return null;
                }
            } else if (c == '.') {
                if (n2 == 3) {
                    return null;
                }
                if (n4 == 0) {
                    return null;
                }
                byArray[n2++] = (byte)n3;
                n3 = 0;
                n4 = 0;
            } else {
                return null;
            }
            ++n5;
        }
        if (n2 != 3) {
            return null;
        }
        if (n4 == 0) {
            return null;
        }
        byArray[n2] = (byte)n3;
        return byArray;
    }

    private static final byte[] parseV6(String string) {
        int n;
        int n2;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        int n3 = -1;
        byte[] byArray = new byte[16];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        arrayList.add("");
        arrayList.add("");
        String[] stringArray = (String[])arrayList.toArray(new String[arrayList.size()]);
        int n4 = 0;
        int n5 = 0;
        while (n4 < stringArray.length - 2) {
            if (stringArray[n4].equals(":")) {
                if (stringArray[n4 + 1].equals(":")) {
                    if (stringArray[n4 + 2].equals(":") || n3 >= 0) {
                        return null;
                    }
                    n3 = n5;
                    if (stringArray[n4 + 2].equals("")) break;
                    ++n4;
                }
                ++n4;
            }
            if (stringArray[n4].indexOf(46) >= 0) {
                bl = true;
                if (stringArray[n4 + 1].equals("")) break;
                return null;
            }
            try {
                n2 = Integer.parseInt(stringArray[n4], 16);
                if (n2 > (char)-1 || n2 < 0) {
                    return null;
                }
                if (n5 > 14) {
                    return null;
                }
                byArray[n5++] = (byte)(n2 >>> 8);
                byArray[n5++] = (byte)(n2 & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n4;
        }
        if (bl) {
            byte[] byArray2 = Address.toByteArray(stringArray[n4], 1);
            if (byArray2 == null) {
                return null;
            }
            n = 0;
            while (n < 4) {
                byArray[n5++] = byArray2[n];
                ++n;
            }
        }
        if (n3 >= 0) {
            n2 = 16 - n5;
            n = 15;
            while (n >= 0) {
                if (n >= n3 + n2) {
                    byArray[n] = byArray[n - n2];
                } else if (n >= n3) {
                    byArray[n] = 0;
                }
                --n;
            }
        } else if (n5 < 16) {
            return null;
        }
        return byArray;
    }

    public static final int[] toArray(String string, int n) {
        byte[] byArray = Address.toByteArray(string, n);
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        return nArray;
    }

    public static final int[] toArray(String string) {
        return Address.toArray(string, 1);
    }

    public static final byte[] toByteArray(String string, int n) {
        if (n == 1) {
            return Address.parseV4(string);
        }
        if (n == 2) {
            return Address.parseV6(string);
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static final boolean isDottedQuad(String string) {
        byte[] byArray = Address.toByteArray(string, 1);
        boolean bl = false;
        if (byArray != null) {
            bl = true;
        }
        return bl;
    }

    public static final String toDottedQuad(byte[] byArray) {
        return "" + (byArray[0] & 0xFF) + '.' + (byArray[1] & 0xFF) + '.' + (byArray[2] & 0xFF) + '.' + (byArray[3] & 0xFF);
    }

    public static final String toDottedQuad(int[] nArray) {
        return "" + nArray[0] + '.' + nArray[1] + '.' + nArray[2] + '.' + nArray[3];
    }

    private static final Record[] lookupHostName(String string) throws UnknownHostException {
        try {
            Record[] recordArray = new Lookup(string).run();
            if (recordArray == null) {
                throw new UnknownHostException("unknown host");
            }
            return recordArray;
        }
        catch (TextParseException textParseException) {
            throw new UnknownHostException("invalid name");
        }
    }

    public static final InetAddress getByName(String string) throws UnknownHostException {
        if (Address.isDottedQuad(string)) {
            return InetAddress.getByName(string);
        }
        Record[] recordArray = Address.lookupHostName(string);
        ARecord aRecord = (ARecord)recordArray[0];
        return aRecord.getAddress();
    }

    public static final InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (Address.isDottedQuad(string)) {
            return InetAddress.getAllByName(string);
        }
        Record[] recordArray = Address.lookupHostName(string);
        InetAddress[] inetAddressArray = new InetAddress[recordArray.length];
        int n = 0;
        while (n < recordArray.length) {
            ARecord aRecord = (ARecord)recordArray[n];
            inetAddressArray[n] = aRecord.getAddress();
            ++n;
        }
        return inetAddressArray;
    }

    public static final String getHostName(InetAddress inetAddress) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(inetAddress);
        Record[] recordArray = new Lookup(name, 12).run();
        if (recordArray == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord pTRRecord = (PTRRecord)recordArray[0];
        return pTRRecord.getTarget().toString();
    }

    public static final int familyOf(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return 1;
        }
        if (inetAddress instanceof Inet6Address) {
            return 2;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static final int addressLength(int n) {
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 16;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    private Address() {
    }
}

