/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.params;

import gnu.javax.crypto.jce.params.DERReader;
import gnu.javax.crypto.jce.params.DERWriter;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class BlockCipherParameters
extends AlgorithmParametersSpi {
    private static final String DEFAULT_FORMAT = "ASN.1";
    protected BlockCipherParameterSpec cipherSpec;

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded(DEFAULT_FORMAT);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (!string.equalsIgnoreCase(DEFAULT_FORMAT) && !string.equalsIgnoreCase("asn1")) {
            throw new IOException("unknown format \"" + string + '\"');
        }
        DERWriter dERWriter = new DERWriter();
        return dERWriter.joinarrays(dERWriter.writeBigInteger(BigInteger.valueOf(this.cipherSpec.getBlockSize())), dERWriter.writeBigInteger(BigInteger.valueOf(this.cipherSpec.getKeySize())), this.cipherSpec.getIV() != null ? dERWriter.writeBigInteger(new BigInteger(this.cipherSpec.getIV())) : new byte[]{});
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof BlockCipherParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        this.cipherSpec = (BlockCipherParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!string.equalsIgnoreCase(DEFAULT_FORMAT) && !string.equalsIgnoreCase("ASN1")) {
            throw new IOException("invalid format: only accepts ASN.1");
        }
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        int n = dERReader.getBigInteger().intValue();
        int n2 = dERReader.getBigInteger().intValue();
        byte[] byArray2 = null;
        if (dERReader.hasMorePrimitives()) {
            byArray2 = dERReader.getBigInteger().toByteArray();
        }
        this.cipherSpec = new BlockCipherParameterSpec(byArray2, n, n2);
        System.out.println(this.cipherSpec);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isInstance(this.cipherSpec)) {
            return this.cipherSpec;
        }
        throw new InvalidParameterSpecException();
    }

    protected String engineToString() {
        return this.cipherSpec.toString();
    }
}

