/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class TXTRecord
extends Record {
    private List strings;

    Record getObject() {
        return new TXTRecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.strings = new ArrayList(2);
        while (dNSInput.remaining() > 0) {
            byte[] byArray = dNSInput.readCountedString();
            this.strings.add(byArray);
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        this.strings = new ArrayList(2);
        while ((token = tokenizer.get()).isString()) {
            try {
                this.strings.add(TXTRecord.byteArrayFromString(token.value));
            }
            catch (TextParseException textParseException) {
                throw tokenizer.exception(textParseException.getMessage());
            }
        }
        tokenizer.unget();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            stringBuffer.append(TXTRecord.byteArrayToString(byArray, true));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public List getStrings() {
        ArrayList arrayList = new ArrayList(this.strings.size());
        int n = 0;
        while (n < this.strings.size()) {
            arrayList.add(TXTRecord.byteArrayToString((byte[])this.strings.get(n), false));
            ++n;
        }
        return arrayList;
    }

    public List getStringsAsByteArrays() {
        return this.strings;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        Iterator iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            dNSOutput.writeCountedString(byArray);
        }
    }

    TXTRecord() {
    }

    public TXTRecord(Name name, int n, long l, List list2) {
        super(name, 16, n, l);
        if (list2 == null) {
            throw new IllegalArgumentException("TXTRecord: strings must not be null");
        }
        this.strings = new ArrayList(list2.size());
        Iterator iterator = list2.iterator();
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.strings.add(TXTRecord.byteArrayFromString(string));
            }
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException(textParseException.getMessage());
        }
    }

    public TXTRecord(Name name, int n, long l, String string) {
        this(name, n, l, Collections.singletonList(string));
    }
}

