/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.DefaultSelectionAction;
import com.xerox.VTM.engine.DynaSpotTimer;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.Utilities;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Translucent;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VText;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.claribole.zvtm.engine.DynaSpotListener;
import net.claribole.zvtm.engine.SelectionListener;
import net.claribole.zvtm.engine.ViewEventHandler;
import net.claribole.zvtm.glyphs.DPath;
import net.claribole.zvtm.glyphs.Translucency;
import net.claribole.zvtm.lens.Lens;

public class VCursor {
    Long ID;
    Color color;
    Color hcolor;
    boolean isVisible = true;
    boolean sensit = true;
    boolean sync;
    int cx;
    int cy;
    public long vx;
    public long vy;
    long pvx;
    long pvy;
    int mx;
    int my;
    float[] gain = new float[2];
    Glyph tmpGlyph;
    short tmpRes;
    Long tmpID;
    int maxIndex = -1;
    public Glyph[] glyphsUnderMouse = new Glyph[50];
    public Glyph lastGlyphEntered = null;
    Glyph[] stickedGlyphs;
    View owningView;
    int size = 10;
    Hashtable gida = new Hashtable(20);
    Color DYNASPOT_COLOR = Color.LIGHT_GRAY;
    float DYNASPOT_MAX_TRANSLUCENCY = 0.3f;
    AlphaComposite dsST = AlphaComposite.getInstance(3, this.DYNASPOT_MAX_TRANSLUCENCY);
    public static final short DYNASPOT_VISIBILITY_INVISIBLE = 0;
    public static final short DYNASPOT_VISIBILITY_VISIBLE = 1;
    public static final short DYNASPOT_VISIBILITY_FADEIN = 2;
    public static final short DYNASPOT_VISIBILITY_FADEOUT = 3;
    short dynaSpotVisibility = 1;
    int DYNASPOT_MAX_RADIUS = 16;
    int LAG_TIME = 120;
    int REDUC_TIME = 180;
    int MIN_SPEED = 100;
    int MAX_SPEED = 300;
    float ds_aa;
    float ds_ab;
    float ds_ra;
    float ds_rb;
    int dynaSpotRadius = 0;
    boolean dynaSpotActivated = false;
    boolean showDynarea = true;
    Timer dstimer;
    DynaSpotTimer dynaspotTimer;
    double opacity = 1.0;
    long[] dynawnes = new long[4];
    Ellipse2D dynaspotVSshape = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
    static final int NB_SPEED_POINTS = 4;
    long[] cursor_time = new long[4];
    int[] cursor_x = new int[4];
    int[] cursor_y = new int[4];
    float[] speeds = new float[3];
    float mean_speed = 0.0f;
    boolean dynaspot_triggered = false;
    long lastTimeAboveMinSpeed = -1L;
    boolean reducing = false;
    long reducStartTime = 0L;
    DynaSpotListener dsl;
    Camera refToCam4DynaPick = null;
    Glyph lastDynaPicked = null;
    SelectionListener sl;

    VCursor(View v) {
        this.owningView = v;
        this.vx = 0L;
        this.pvx = 0L;
        this.vy = 0L;
        this.pvy = 0L;
        this.cx = 0;
        this.cy = 0;
        this.mx = 0;
        this.my = 0;
        this.color = Color.black;
        this.hcolor = Color.black;
        this.stickedGlyphs = new Glyph[0];
        this.sync = true;
        this.computeDynaSpotParams();
        this.setSelectionListener(new DefaultSelectionAction());
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int getSize() {
        return this.size;
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long ident) {
        this.ID = ident;
    }

    public LongPoint getLocation() {
        return new LongPoint(this.vx, this.vy);
    }

    public View getOwningView() {
        return this.owningView;
    }

    public void setSync(boolean b) {
        this.sync = b;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setHintColor(Color c) {
        this.hcolor = c;
    }

    public void moveTo(int x, int y) {
        if (this.sync) {
            this.mx = x;
            this.my = y;
        }
    }

    public void propagateMove() {
        for (int i = 0; i < this.stickedGlyphs.length; ++i) {
            this.stickedGlyphs[i].move(this.vx - this.pvx, this.vy - this.pvy);
        }
    }

    void stick(Glyph g) {
        if (g != null) {
            g.setSensitivity(false);
            Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
            System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
            newStickList[this.stickedGlyphs.length] = g;
            this.stickedGlyphs = newStickList;
            g.stickedTo = this;
        }
    }

    void unstick() {
        if (this.stickedGlyphs.length > 0) {
            Glyph g = this.stickedGlyphs[this.stickedGlyphs.length - 1];
            g.setSensitivity(true);
            g.stickedTo = null;
            Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
            System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length - 1);
            this.stickedGlyphs = newStickList;
        }
    }

    public int getStickedGlyphsNumber() {
        return this.stickedGlyphs.length;
    }

    void unstickSpecificGlyph(Glyph g) {
        for (int i = 0; i < this.stickedGlyphs.length; ++i) {
            if (this.stickedGlyphs[i] != g) continue;
            g.stickedTo = null;
            Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
            System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
            System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
            this.stickedGlyphs = newStickList;
            break;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public Vector getStickedGlyphs() {
        Vector<Glyph> res = new Vector<Glyph>();
        for (int i = 0; i < this.stickedGlyphs.length; ++i) {
            res.add(this.stickedGlyphs[i]);
        }
        return res;
    }

    public void setVisibility(boolean b) {
        this.isVisible = b;
    }

    public void setSensitivity(boolean b) {
        this.sensit = b;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIntersectingPaths(Camera c, int tolerance, long cursorX, long cursorY) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            Vector res = new Vector();
            Vector glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
            for (int i = 0; i < glyphs.size(); ++i) {
                Object glyph = glyphs.elementAt(i);
                if (!(glyph instanceof DPath) || !this.intersectsPath((DPath)glyph, tolerance, cursorX, cursorY)) continue;
                res.add(glyph);
            }
            return res;
        }
    }

    public Vector getIntersectingPaths(Camera c) {
        return this.getIntersectingPaths(c, 5, this.vx, this.vy);
    }

    public Vector getIntersectingPaths(Camera c, int tolerance) {
        return this.getIntersectingPaths(c, tolerance, this.vx, this.vy);
    }

    public boolean intersectsPath(DPath p, int tolerance, long cursorX, long cursorY) {
        if (!p.coordsInsideBoundingBox(cursorX, cursorY)) {
            return false;
        }
        int dtol = tolerance * 2;
        GeneralPath gp = p.getJava2DGeneralPath();
        return gp.intersects(cursorX - (long)dtol, cursorY - (long)dtol, dtol, dtol) && !p.getJava2DGeneralPath().contains(cursorX - (long)tolerance, cursorY - (long)tolerance, dtol, dtol);
    }

    public boolean intersectsPath(DPath p, int tolerance) {
        return this.intersectsPath(p, tolerance, this.vx, this.vy);
    }

    public boolean intersectsPath(DPath p) {
        return this.intersectsPath(p, 5, this.vx, this.vy);
    }

    public boolean intersectsVPath(VPath p, int tolerance, long cursorX, long cursorY) {
        int dtol = tolerance * 2;
        return p.getJava2DGeneralPath().intersects(cursorX - (long)dtol, -cursorY - (long)dtol, dtol, dtol) && p.getJava2DGeneralPath().contains(cursorX - (long)tolerance, -cursorY - (long)tolerance, tolerance, tolerance);
    }

    public boolean intersectsVPath(VPath p, int tolerance) {
        return this.intersectsVPath(p, tolerance, this.vx, this.vy);
    }

    public boolean intersectsVPath(VPath p) {
        return this.intersectsVPath(p, 5, this.vx, this.vy);
    }

    public Vector getIntersectingTexts(Camera c) {
        return this.getIntersectingTexts(c, this.vx, this.vy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIntersectingTexts(Camera c, long cursorX, long cursorY) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            Vector res = new Vector();
            int index = c.getIndex();
            Vector glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
            for (int i = 0; i < glyphs.size(); ++i) {
                Object glyph = glyphs.elementAt(i);
                if (!(glyph instanceof VText) || !this.intersectsVText((VText)glyph, index, cursorX, cursorY)) continue;
                res.add(glyph);
            }
            if (res.isEmpty()) {
                res = null;
            }
            return res;
        }
    }

    public boolean intersectsVText(VText t, int camIndex) {
        return this.intersectsVText(t, camIndex, this.vx, this.vy);
    }

    public boolean intersectsVText(VText t, int camIndex, long cursorX, long cursorY) {
        boolean res = false;
        LongPoint p = t.getBounds(camIndex);
        switch (t.getTextAnchor()) {
            case 0: {
                if (cursorX < t.vx || cursorY < t.vy || cursorX > t.vx + p.x || cursorY > t.vy + p.y) break;
                res = true;
                break;
            }
            case 1: {
                if (cursorX < t.vx - p.x / 2L || cursorY < t.vy || cursorX > t.vx + p.x / 2L || cursorY > t.vy + p.y) break;
                res = true;
                break;
            }
            default: {
                if (cursorX > t.vx || cursorY < t.vy || cursorX < t.vx - p.x || cursorY > t.vy + p.y) break;
                res = true;
            }
        }
        return res;
    }

    public Vector getIntersectingSegments(Camera c, int tolerance) {
        return this.getIntersectingSegments(c, this.mx, this.my, tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIntersectingSegments(Camera c, int jpx, int jpy, int tolerance) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            Vector res = new Vector();
            int index = c.getIndex();
            Vector glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
            for (int i = 0; i < glyphs.size(); ++i) {
                Object glyph = glyphs.elementAt(i);
                if (!(glyph instanceof VSegment) || !this.intersectsSegment((VSegment)glyph, jpx, jpy, tolerance, index)) continue;
                res.add(glyph);
            }
            if (res.isEmpty()) {
                res = null;
            }
            return res;
        }
    }

    public boolean intersectsSegment(VSegment s, int tolerance, int camIndex) {
        return this.intersectsSegment(s, this.mx, this.my, camIndex, tolerance);
    }

    public boolean intersectsSegment(VSegment s, int jpx, int jpy, int tolerance, int camIndex) {
        return s.intersects(jpx, jpy, tolerance, camIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIntersectingGlyphs(Camera c) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            Vector<Glyph> res = new Vector<Glyph>();
            Vector glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
            for (int i = 0; i < glyphs.size(); ++i) {
                Glyph glyph = (Glyph)glyphs.elementAt(i);
                if (glyph.coordInside(this.mx, this.my, c.getIndex(), this.vx, this.vy)) {
                    res.add(glyph);
                    continue;
                }
                if (glyph instanceof VSegment && this.intersectsSegment((VSegment)glyph, 2, c.getIndex())) {
                    res.add(glyph);
                    continue;
                }
                if (glyph instanceof VText && this.intersectsVText((VText)glyph, c.getIndex())) {
                    res.add(glyph);
                    continue;
                }
                if (!(glyph instanceof VPath) || !this.intersectsVPath((VPath)glyph)) continue;
                res.add(glyph);
            }
            if (res.isEmpty()) {
                res = null;
            }
            return res;
        }
    }

    void doubleCapacity() {
        Glyph[] tmpArray = new Glyph[this.glyphsUnderMouse.length * 2];
        System.arraycopy(this.glyphsUnderMouse, 0, tmpArray, 0, this.glyphsUnderMouse.length);
        this.glyphsUnderMouse = tmpArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetGlyphsUnderMouseList(VirtualSpace vs, int camIndex) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            Glyph[] gl;
            for (int i = 0; i < this.glyphsUnderMouse.length; ++i) {
                this.glyphsUnderMouse[i] = null;
                this.maxIndex = -1;
            }
            this.lastGlyphEntered = null;
            Glyph[] glyphArray = gl = vs.getDrawingList();
            synchronized (gl) {
                for (int i = 0; i < gl.length; ++i) {
                    try {
                        gl[i].resetMouseIn(camIndex);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        if (!VirtualSpaceManager.debugModeON()) continue;
                        System.err.println("Recovered from error when resetting list of glyphs under mouse");
                        ex.printStackTrace();
                    }
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
    }

    public Vector getGlyphsUnderMouse() {
        Vector<Glyph> res = new Vector<Glyph>();
        for (int i = 0; i <= this.maxIndex; ++i) {
            res.add(this.glyphsUnderMouse[i]);
        }
        return res;
    }

    public Glyph[] getGlyphsUnderMouseList() {
        if (this.maxIndex >= 0) {
            Glyph[] res = new Glyph[this.maxIndex + 1];
            System.arraycopy(this.glyphsUnderMouse, 0, res, 0, this.maxIndex + 1);
            return res;
        }
        return new Glyph[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGlyphFromList(Glyph g) {
        VCursor vCursor = this;
        synchronized (vCursor) {
            int i = 0;
            boolean present = false;
            while (i <= this.maxIndex) {
                if (this.glyphsUnderMouse[i++] != g) continue;
                present = true;
                break;
            }
            while (i <= this.maxIndex) {
                this.glyphsUnderMouse[i - 1] = this.glyphsUnderMouse[i];
                ++i;
            }
            if (present) {
                --this.maxIndex;
                if (this.maxIndex < 0) {
                    this.lastGlyphEntered = null;
                    this.maxIndex = -1;
                } else {
                    this.lastGlyphEntered = this.glyphsUnderMouse[this.maxIndex];
                }
            }
        }
    }

    boolean computeMouseOverList(ViewEventHandler eh, Camera c) {
        return this.computeMouseOverList(eh, c, this.mx, this.my);
    }

    boolean computeMouseOverList(ViewEventHandler eh, Camera c, Lens l) {
        if (l != null) {
            return this.computeMouseOverList(eh, c, Math.round(((float)this.mx - (float)l.sw) / this.gain[0] + (float)l.sw), Math.round(((float)this.my - (float)l.sh) / this.gain[1] + (float)l.sh));
        }
        return this.computeMouseOverList(eh, c, this.mx, this.my);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean computeMouseOverList(ViewEventHandler eh, Camera c, int x, int y) {
        Vector drawnGlyphs;
        boolean res = false;
        Vector vector = drawnGlyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        synchronized (vector) {
            Glyph[] glyphArray = this.glyphsUnderMouse;
            synchronized (this.glyphsUnderMouse) {
                block11: {
                    try {
                        for (int i = 0; i < drawnGlyphs.size(); ++i) {
                            this.tmpGlyph = (Glyph)drawnGlyphs.elementAt(i);
                            if (!this.tmpGlyph.isSensitive() || !this.checkGlyph(eh, c, x, y)) continue;
                            res = true;
                        }
                    }
                    catch (NoSuchElementException e) {
                        VirtualSpaceManager cfr_ignored_0 = this.owningView.parent;
                        if (VirtualSpaceManager.debug) {
                            System.err.println("vcursor.computemouseoverlist " + e);
                            e.printStackTrace();
                        }
                    }
                    catch (NullPointerException e2) {
                        VirtualSpaceManager cfr_ignored_1 = this.owningView.parent;
                        if (!VirtualSpaceManager.debug) break block11;
                        System.err.println("vcursor.computemouseoverlist null " + e2 + " (This might be caused by an error in enterGlyph/exitGlyph in your event handler)");
                        e2.printStackTrace();
                    }
                }
                // ** MonitorExit[var8_8] (shouldn't be in output)
            }
        }
        return res;
    }

    boolean checkGlyph(ViewEventHandler eh, Camera c, int jpx, int jpy) {
        this.tmpRes = this.tmpGlyph.mouseInOut(jpx, jpy, c.getIndex(), this.vx, this.vy);
        if (this.tmpRes == 1) {
            this.tmpID = this.tmpGlyph.getID();
            ++this.maxIndex;
            if (this.maxIndex >= this.glyphsUnderMouse.length) {
                this.doubleCapacity();
            }
            this.glyphsUnderMouse[this.maxIndex] = this.tmpGlyph;
            this.lastGlyphEntered = this.tmpGlyph;
            eh.enterGlyph(this.tmpGlyph);
            return true;
        }
        if (this.tmpRes == -1) {
            this.tmpID = this.tmpGlyph.getID();
            int j = 0;
            while (j <= this.maxIndex && this.glyphsUnderMouse[j++] != this.tmpGlyph) {
            }
            while (j <= this.maxIndex) {
                this.glyphsUnderMouse[j - 1] = this.glyphsUnderMouse[j];
                ++j;
            }
            --this.maxIndex;
            if (this.maxIndex < 0) {
                this.lastGlyphEntered = null;
                this.maxIndex = -1;
            } else {
                this.lastGlyphEntered = this.glyphsUnderMouse[this.maxIndex];
            }
            eh.exitGlyph(this.tmpGlyph);
            return true;
        }
        return false;
    }

    public void printList() {
        System.err.print("[");
        for (int i = 0; i <= this.maxIndex; ++i) {
            System.err.print(this.glyphsUnderMouse[i].getID().toString() + ",");
        }
        System.err.println("]");
    }

    void unProject(Camera c, ViewPanel v) {
        if (this.sync) {
            if (v.lens != null) {
                v.lens.gf(this.mx, this.my, this.gain);
                this.cx = this.mx - v.getSize().width / 2;
                this.cy = v.getSize().height / 2 - this.my;
                v.lens.gf(this.cx, this.cy, this.gain);
                this.cx = (int)((float)this.cx * this.gain[0]);
                this.cy = (int)((float)this.cy * this.gain[1]);
            } else {
                this.cx = this.mx - v.getSize().width / 2;
                this.cy = v.getSize().height / 2 - this.my;
            }
            double coef = ((double)c.focal + (double)c.altitude) / (double)c.focal;
            this.pvx = this.vx;
            this.pvy = this.vy;
            this.vx = Math.round((double)this.cx * coef + (double)c.posx);
            this.vy = Math.round((double)this.cy * coef + (double)c.posy);
        }
    }

    public LongPoint getVSCoordinates(Camera c, ViewPanel v) {
        int cy;
        int cx;
        if (v.lens != null) {
            v.lens.gf(this.mx, this.my, this.gain);
            cx = this.mx - v.getSize().width / 2;
            cy = v.getSize().height / 2 - this.my;
            v.lens.gf(cx, cy, this.gain);
            cx = (int)((float)cx * this.gain[0]);
            cy = (int)((float)cy * this.gain[1]);
        } else {
            cx = this.mx - v.getSize().width / 2;
            cy = v.getSize().height / 2 - this.my;
        }
        double coef = ((double)c.focal + (double)c.altitude) / (double)c.focal;
        return new LongPoint(Math.round((double)cx * coef + (double)c.posx), Math.round((double)cy * coef + (double)c.posy));
    }

    public int getPanelXCoordinate() {
        return this.mx;
    }

    public int getPanelYCoordinate() {
        return this.my;
    }

    public void draw(Graphics2D g) {
        if (this.isVisible) {
            g.setColor(this.color);
            g.drawLine(this.mx - this.size, this.my, this.mx + this.size, this.my);
            g.drawLine(this.mx, this.my - this.size, this.mx, this.my + this.size);
        }
        if (this.dynaSpotActivated && this.showDynarea) {
            g.setColor(this.DYNASPOT_COLOR);
            switch (this.dynaSpotVisibility) {
                case 1: {
                    g.setComposite(this.dsST);
                    break;
                }
                case 2: {
                    g.setComposite(Translucency.acs[(int)Math.round((1.0 - this.opacity) * (double)this.DYNASPOT_MAX_TRANSLUCENCY * 20.0)]);
                    break;
                }
                case 3: {
                    g.setComposite(Translucency.acs[(int)Math.round(this.opacity * (double)this.DYNASPOT_MAX_TRANSLUCENCY * 20.0)]);
                }
            }
            g.fillOval(this.mx - this.dynaSpotRadius, this.my - this.dynaSpotRadius, 2 * this.dynaSpotRadius, 2 * this.dynaSpotRadius);
            g.setComposite(Translucent.acO);
        }
    }

    public void setDynaSpotVisibility(short v) {
        this.dynaSpotVisibility = v;
        this.showDynarea = this.dynaSpotVisibility != 0;
    }

    public void setDynaSpotColor(Color c) {
        this.DYNASPOT_COLOR = c;
    }

    public Color getDynaSpotColor() {
        return this.DYNASPOT_COLOR;
    }

    public void setDynaSpotTranslucence(float a) {
        this.DYNASPOT_MAX_TRANSLUCENCY = a;
        this.dsST = AlphaComposite.getInstance(3, this.DYNASPOT_MAX_TRANSLUCENCY);
    }

    public float getDynaSpotTranslucence() {
        return this.DYNASPOT_MAX_TRANSLUCENCY;
    }

    public void setDynaSpotLagTime(int t) {
        this.LAG_TIME = t;
    }

    public int getDynaSpotLagTime() {
        return this.LAG_TIME;
    }

    public void setDynaSpotReducTime(int t) {
        this.REDUC_TIME = t;
        this.computeDynaSpotParams();
    }

    public int getDynaSpotReducTime() {
        return this.REDUC_TIME;
    }

    void computeDynaSpotParams() {
        this.ds_aa = (float)this.DYNASPOT_MAX_RADIUS / (float)(this.MAX_SPEED - this.MIN_SPEED);
        this.ds_ab = (float)(-this.DYNASPOT_MAX_RADIUS * this.MIN_SPEED) / (float)(this.MAX_SPEED - this.MIN_SPEED);
        this.ds_ra = (float)(-this.DYNASPOT_MAX_RADIUS) / (float)Math.pow(this.REDUC_TIME, 2.0);
        this.ds_rb = this.DYNASPOT_MAX_RADIUS;
    }

    void initDynaSpotTimer() {
        this.dstimer = new Timer();
        this.dynaspotTimer = new DynaSpotTimer(this);
        this.dstimer.scheduleAtFixedRate((TimerTask)this.dynaspotTimer, 40L, 20L);
    }

    public synchronized void updateDynaSpot(long currentTime) {
        int i;
        for (i = 1; i < 4; ++i) {
            this.cursor_time[i - 1] = this.cursor_time[i];
            this.cursor_x[i - 1] = this.cursor_x[i];
            this.cursor_y[i - 1] = this.cursor_y[i];
        }
        this.cursor_time[3] = currentTime;
        this.cursor_x[3] = this.mx;
        this.cursor_y[3] = this.my;
        for (i = 0; i < this.speeds.length; ++i) {
            this.speeds[i] = (float)Math.sqrt(Math.pow(this.cursor_x[i + 1] - this.cursor_x[i], 2.0) + Math.pow(this.cursor_y[i + 1] - this.cursor_y[i], 2.0)) / (float)(this.cursor_time[i + 1] - this.cursor_time[i]);
        }
        this.mean_speed = 0.0f;
        for (i = 0; i < this.speeds.length; ++i) {
            this.mean_speed += this.speeds[i];
        }
        this.mean_speed = this.mean_speed / (float)this.speeds.length * 1000.0f;
        if (this.dynaspot_triggered) {
            if (this.mean_speed > (float)this.MIN_SPEED) {
                this.lastTimeAboveMinSpeed = System.currentTimeMillis();
                if (this.mean_speed > (float)this.MAX_SPEED && this.dynaSpotRadius < this.DYNASPOT_MAX_RADIUS) {
                    this.updateDynaSpotArea(this.DYNASPOT_MAX_RADIUS);
                }
            } else if (this.lastTimeAboveMinSpeed > 0L && currentTime - this.lastTimeAboveMinSpeed >= (long)this.LAG_TIME) {
                this.lastTimeAboveMinSpeed = -1L;
                this.reducing = true;
                this.reducStartTime = currentTime;
                this.dynaspot_triggered = false;
            }
        } else if (this.mean_speed > (float)this.MIN_SPEED) {
            this.lastTimeAboveMinSpeed = System.currentTimeMillis();
            this.dynaspot_triggered = true;
            if (this.mean_speed > (float)this.MAX_SPEED) {
                if (this.dynaSpotRadius < this.DYNASPOT_MAX_RADIUS) {
                    this.updateDynaSpotArea(this.DYNASPOT_MAX_RADIUS);
                }
            } else {
                this.updateDynaSpotArea(Math.round(this.ds_aa * this.mean_speed + this.ds_ab));
            }
        } else if (this.reducing) {
            if (currentTime - this.reducStartTime >= (long)this.REDUC_TIME) {
                this.updateDynaSpotArea(0);
                this.reducing = false;
            } else {
                this.updateDynaSpotArea(Math.round(this.ds_ra * (float)Math.pow(currentTime - this.reducStartTime, 2.0) + this.ds_rb));
            }
        }
        this.owningView.repaintNow();
    }

    void updateDynaSpotArea(int r) {
        this.dynaSpotRadius = r;
        this.dynaPick();
        if (this.dsl != null) {
            this.dsl.spotSizeChanged(this, this.dynaSpotRadius);
        }
    }

    public int getDynaSpotRadius() {
        return this.dynaSpotRadius;
    }

    public void setDynaSpotListener(DynaSpotListener dsl) {
        this.dsl = dsl;
    }

    public DynaSpotListener getDynaSpotListener() {
        return this.dsl;
    }

    public void activateDynaSpot(boolean b) {
        this.dynaSpotActivated = b;
        if (this.dynaSpotActivated) {
            if (this.dstimer != null) {
                this.dstimer.cancel();
            }
            this.initDynaSpotTimer();
        } else {
            try {
                this.dstimer.cancel();
                this.dstimer = null;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isDynaSpotActivated() {
        return this.dynaSpotActivated;
    }

    public void setDynaSpotMaxRadius(int r) {
        this.DYNASPOT_MAX_RADIUS = r < 0 ? 0 : r;
        this.computeDynaSpotParams();
    }

    public int getDynaSpotMaxRadius() {
        return this.DYNASPOT_MAX_RADIUS;
    }

    void dynaPick() {
        this.dynaPick(this.refToCam4DynaPick);
    }

    public void setSelectionListener(SelectionListener sl) {
        this.sl = sl;
    }

    public SelectionListener getSelectionListener() {
        return this.sl;
    }

    public Glyph dynaPick(Camera c) {
        if (c == null) {
            return null;
        }
        this.refToCam4DynaPick = c;
        Vector drawnGlyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        Glyph selectedGlyph = null;
        double distanceToSelectedGlyph = -1.0;
        int gumIndex = -1;
        int cgumIndex = -1;
        long unprojectedDSRadius = Math.round(((double)c.focal + (double)c.altitude) / (double)c.focal * (double)this.dynaSpotRadius);
        this.dynawnes[0] = this.vx - unprojectedDSRadius;
        this.dynawnes[1] = this.vy + unprojectedDSRadius;
        this.dynawnes[2] = this.vx + unprojectedDSRadius;
        this.dynawnes[3] = this.vy - unprojectedDSRadius;
        this.dynaspotVSshape.setFrame(this.dynawnes[0], this.dynawnes[3], 2L * unprojectedDSRadius, 2L * unprojectedDSRadius);
        for (int i = 0; i < drawnGlyphs.size(); ++i) {
            Glyph g = (Glyph)drawnGlyphs.elementAt(i);
            if (!g.isSensitive()) continue;
            cgumIndex = Utilities.indexOfGlyph(this.glyphsUnderMouse, g, this.maxIndex + 1);
            if (cgumIndex > -1) {
                if (cgumIndex > gumIndex) {
                    gumIndex = cgumIndex;
                    selectedGlyph = g;
                    distanceToSelectedGlyph = 0.0;
                }
                this.gida.put(g.getID(), g);
                continue;
            }
            if (g.visibleInRegion(this.dynawnes[0], this.dynawnes[1], this.dynawnes[2], this.dynawnes[3], c.getIndex()) && g.visibleInDisc(this.vx, this.vy, unprojectedDSRadius, this.dynaspotVSshape, c.getIndex(), this.mx, this.my, this.dynaSpotRadius)) {
                this.gida.put(g.getID(), g);
                double d = Math.sqrt(Math.pow(g.vx - this.vx, 2.0) + Math.pow(g.vy - this.vy, 2.0));
                if (distanceToSelectedGlyph != -1.0 && !(d < distanceToSelectedGlyph)) continue;
                selectedGlyph = g;
                distanceToSelectedGlyph = d;
                continue;
            }
            if (!this.gida.containsKey(g.getID())) continue;
            this.gida.remove(g.getID());
            if (this.sl == null) continue;
            this.sl.glyphSelected(this.lastDynaPicked, false);
        }
        if (selectedGlyph != null && this.sl != null) {
            this.sl.glyphSelected(selectedGlyph, true);
        }
        if (this.lastDynaPicked != null && selectedGlyph != this.lastDynaPicked && this.sl != null) {
            this.sl.glyphSelected(this.lastDynaPicked, false);
        }
        this.lastDynaPicked = selectedGlyph;
        return selectedGlyph;
    }

    public Set getGlyphsInDynaSpotRegion(Camera c) {
        return this.gida.keySet();
    }
}

