/*
 * vlserver.h:
 * This file is automatically generated; please do not edit it.
 */
/* Including ./vlserver.p.h at beginning of vlserver.h file. */

/*
 * Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 *
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 */

#ifndef	_VLSERVER_
#define	_VLSERVER_

#include "vldbint.h"
#include <afs/afsutil.h>

extern struct vldstats dynamic_statistics;



#define	HASHSIZE		8191	/* Must be prime */
#define	NULLO			0
#define	VLDBALLOCCOUNT		500

/* Current upper limits limits on certain entries; increase with care! */
#define	BADSERVERID	255
#define	MAXSERVERID	254	/* permits 255 servers; was == 30 in version 1 */
#define	MAXSERVERFLAG	0x80
#define	MAXPARTITIONID	255
#define	MAXBUMPCOUNT	0x7fffffff	/* Infinite  upper bound on bumping for now */
#define	MAXLOCKTIME	0x7fffffff	/* Infinite locking for now */

/* Order of entries in the volumeid[] array */
#define	RWVOL		0
#define	ROVOL		1
#define	BACKVOL		2

/* Header struct holding stats, internal pointers and the hash tables */
struct vlheader {
    struct vital_vlheader vital_header;	/* all small critical stuff are in here */
    afs_uint32 IpMappedAddr[MAXSERVERID + 1];	/* Mapping of ip addresses to relative ones */
    afs_uint32 VolnameHash[HASHSIZE];	/* hash table for vol names */
    afs_uint32 VolidHash[MAXTYPES][HASHSIZE];	/* hash table for vol ids */
    afs_int32 SIT;		/* spare for poss future use */
};

/* Vlentry's flags state */
#define	VLFREE		1	/* If in free list */
#define	VLDELETED	2	/* Entry is soft deleted */
#define	VLLOCKED	4	/* Advisory lock on entry */
#define	VLCONTBLOCK	8	/* Special continuation block entry */

/* Valid RelaseLock types */
#define	LOCKREL_TIMESTAMP   1
#define	LOCKREL_OPCODE	    2
#define	LOCKREL_AFSID	    4

/* Per repsite flags (serverFlags) */
#define	VLREPSITE_NEW   1	/* Replication site is got new release */

/* Internal representation of vldbentry; trying to save any bytes */
struct vlentry {
    afs_uint32 volumeId[MAXTYPES];	/* Corresponding volume of each type */
    afs_int32 flags;		/* General flags */
    afs_int32 LockAfsId;	/* Person who locked entry */
    afs_int32 LockTimestamp;	/* lock time stamp */
    afs_uint32 cloneId;		/* used during cloning */
    afs_int32 spares0;		/* XXXX was AssociatedChain XXXX */
    afs_uint32 nextIdHash[MAXTYPES];	/* Next id hash table pointer (or freelist ->[0]) */
    afs_uint32 nextNameHash;	/* Next name hash table pointer */
    afs_int32 spares1[2];	/* long spares */
    char name[VL_MAXNAMELEN];	/* Volume name */
    char spares3;		/* XXX was volumeType XXXX */
    u_char serverNumber[OMAXNSERVERS];	/* Server # for each server that holds volume */
    u_char serverPartition[OMAXNSERVERS];	/* Server Partition number */
    u_char serverFlags[OMAXNSERVERS];	/* Server flags */
    char spares4;		/* XXX was RefCount XXX */
    char spares2[1];		/* for 32-bit alignment */
};

struct nvlentry {
    afs_uint32 volumeId[MAXTYPES];	/* Corresponding volume of each type */
    afs_int32 flags;		/* General flags */
    afs_int32 LockAfsId;	/* Person who locked entry */
    afs_int32 LockTimestamp;	/* lock time stamp */
    afs_uint32 cloneId;		/* used during cloning */
    afs_uint32 nextIdHash[MAXTYPES];	/* Next id hash table pointer (or freelist ->[0]) */
    afs_uint32 nextNameHash;	/* Next name hash table pointer */
    char name[VL_MAXNAMELEN];	/* Volume name */
    u_char serverNumber[NMAXNSERVERS];	/* Server # for each server that holds volume */
    u_char serverPartition[NMAXNSERVERS];	/* Server Partition number */
    u_char serverFlags[NMAXNSERVERS];	/* Server flags */
};

typedef struct vlheader vlheader;
typedef struct vlentry vlentry;
typedef struct nvlentry nvlentry;

#define	DOFFSET(abase,astr,aitem) ((abase)+(((char *)(aitem)) - ((char *)(astr))))

#define	VL_MHSRV_PERBLK		64
#define	VL_MAXIPADDRS_PERMH	15
#define VL_MAX_ADDREXTBLKS	4
#define	VL_ADDREXTBLK_SIZE	8192
struct extentaddr {
    union ex_un {
	struct {
	    afs_int32 count;	/* # of valid addresses */
	    afs_int32 spares1[2];
	    afs_int32 flags;	/* must be in the same position as the vlentry's
				   flags field */
	    afs_uint32 contaddrs[VL_MAX_ADDREXTBLKS];
	    afs_int32 spares2[24];
	} _ex_header;
	struct {
	    afsUUID hostuuid;
	    afs_int32 uniquifier;
	    afs_uint32 addrs[VL_MAXIPADDRS_PERMH];
	    afs_uint32 flags;
	    afs_int32 spares[11];
	} _ex_addrentry;
    } _ex_un;
};
#define	ex_count	_ex_un._ex_header.count
#define	ex_hdrflags	_ex_un._ex_header.flags
#define	ex_contaddrs	_ex_un._ex_header.contaddrs
#define	ex_hostuuid	_ex_un._ex_addrentry.hostuuid
#define	ex_addrs	_ex_un._ex_addrentry.addrs
#define	ex_uniquifier	_ex_un._ex_addrentry.uniquifier
#define ex_srvflags	_ex_un._ex_addrentry.flags

#define VLog(level, str)   ViceLog(level, str)

#endif /* _VLSERVER_ */

/* End of prolog file ./vlserver.p.h. */

#define VL_IDEXIST                               (363520L)
#define VL_IO                                    (363521L)
#define VL_NAMEEXIST                             (363522L)
#define VL_CREATEFAIL                            (363523L)
#define VL_NOENT                                 (363524L)
#define VL_EMPTY                                 (363525L)
#define VL_ENTDELETED                            (363526L)
#define VL_BADNAME                               (363527L)
#define VL_BADINDEX                              (363528L)
#define VL_BADVOLTYPE                            (363529L)
#define VL_BADSERVER                             (363530L)
#define VL_BADPARTITION                          (363531L)
#define VL_REPSFULL                              (363532L)
#define VL_NOREPSERVER                           (363533L)
#define VL_DUPREPSERVER                          (363534L)
#define VL_RWNOTFOUND                            (363535L)
#define VL_BADREFCOUNT                           (363536L)
#define VL_SIZEEXCEEDED                          (363537L)
#define VL_BADENTRY                              (363538L)
#define VL_BADVOLIDBUMP                          (363539L)
#define VL_IDALREADYHASHED                       (363540L)
#define VL_ENTRYLOCKED                           (363541L)
#define VL_BADVOLOPER                            (363542L)
#define VL_BADRELLOCKTYPE                        (363543L)
#define VL_RERELEASE                             (363544L)
#define VL_BADSERVERFLAG                         (363545L)
#define VL_PERM                                  (363546L)
#define VL_NOMEM                                 (363547L)
#define VL_BADVERSION                            (363548L)
#define VL_INDEXERANGE                           (363549L)
#define VL_MULTIPADDR                            (363550L)
#define VL_BADMASK                               (363551L)
#define VL_DBBAD                                 (363552L)
extern void initialize_VL_error_table(void);
#define ERROR_TABLE_BASE_VL (363520L)

/* for compatibility with older versions... */
#define init_VL_err_tbl initialize_VL_error_table
#define VL_err_base ERROR_TABLE_BASE_VL

/* for compatibility with other users... */
#define ERROR_TABLE_BASE_vl (363520L)
#define init_vl_err_tbl initialize_VL_error_table
#define initialize_vl_error_table initialize_VL_error_table
#define vl_err_base ERROR_TABLE_BASE_vl
