/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import w from"@typo3/core/document-service.js";import I from"@typo3/backend/ajax-data-handler.js";import v from"@typo3/backend/icons.js";import s from"@typo3/core/event/regular-event.js";import{DataTransferTypes as f}from"@typo3/backend/enum/data-transfer-types.js";import S from"@typo3/backend/broadcast-service.js";import{BroadcastMessage as P}from"@typo3/backend/broadcast-message.js";import m from"@typo3/backend/utility/drag-drop-utility.js";var o;(function(r){r.content=".t3js-page-ce",r.draggableContentHandle='.t3js-page-ce-header[draggable="true"]',r.dropZone=".t3js-page-ce-dropzone-available",r.column=".t3js-page-column",r.addContent=".t3js-page-new-ce"})(o||(o={}));var g;(function(r){r.validDropZoneClass="active",r.dropPossibleHoverClass="t3-page-ce-dropzone-possible"})(g||(g={}));class Z{constructor(){w.ready().then(()=>{this.initialize()})}initialize(){new s("mousedown",(e,t)=>{const n=e.target.closest("a,img");n!==null&&t.contains(n)}).delegateTo(document,o.draggableContentHandle),new s("dragstart",this.onDragStart.bind(this)).delegateTo(document,o.draggableContentHandle),new s("dragenter",this.onDragEnter.bind(this)).delegateTo(document,o.draggableContentHandle),new s("dragend",this.onDragEnd.bind(this)).delegateTo(document,o.draggableContentHandle),new s("dragenter",(e,t)=>{t.classList.add(g.dropPossibleHoverClass),m.updateEventAndTooltipToReflectCopyMoveIntention(e)}).delegateTo(document,o.dropZone),new s("dragover",e=>{e.preventDefault(),m.updateEventAndTooltipToReflectCopyMoveIntention(e)}).delegateTo(document,o.dropZone),new s("dragleave",(e,t)=>{e.preventDefault(),t.classList.remove(g.dropPossibleHoverClass)}).delegateTo(document,o.dropZone),new s("drop",this.onDrop.bind(this),{capture:!0,passive:!0}).delegateTo(document,o.dropZone),new s("typo3:page-layout-drag-drop:elementChanged",this.onBroadcastElementChanged.bind(this)).bindTo(top.document)}onDragEnter(e){e.preventDefault(),m.updateEventAndTooltipToReflectCopyMoveIntention(e),this.showDropZones()}onDragStart(e,t){const n=t.closest(o.content);e.dataTransfer.setData(f.content,JSON.stringify({pid:this.getCurrentPageId(),uid:parseInt(n.dataset.uid,10),language:parseInt(n.dataset.languageUid,10),content:n.outerHTML,moveElementUrl:n.dataset.moveElementUrl}));const d=this.getDragTooltipMetadataFromContentElement(n);e.dataTransfer.setData(f.dragTooltip,JSON.stringify(d)),e.dataTransfer.effectAllowed="copyMove",m.updateEventAndTooltipToReflectCopyMoveIntention(e),n.querySelector(o.dropZone).hidden=!0}onDragEnd(){this.hideDropZones()}onDrop(e,t){let n;if(t.classList.remove(g.dropPossibleHoverClass),!e.dataTransfer.types.includes(f.content))return;const d=this.getColumnPositionForElement(t),a=JSON.parse(e.dataTransfer.getData(f.content));if(n=document.querySelector(`${o.content}[data-uid="${a.uid}"]`),n||(n=document.createRange().createContextualFragment(a.content).firstElementChild),typeof a.uid=="number"&&a.uid>0){const u={},i=t.closest(o.content).dataset.uid;let l;i===void 0?l=parseInt(t.closest("[data-page]").dataset.page,10):l=0-parseInt(i,10);let c=a.language;c!==-1&&(c=parseInt(t.closest("[data-language-uid]").dataset.languageUid,10));let p=0;l!==0&&(p=d);const h=m.isCopyModifierFromEvent(e)||t.classList.contains("t3js-paste-copy"),T=h?"copy":"move";u.cmd={tt_content:{[a.uid]:{[T]:{action:"paste",target:l,update:{colPos:p,sys_language_uid:c}}}}},this.ajaxAction(u,h).then(()=>{t.parentElement.classList.contains(o.content.substring(1))?t.closest(o.content).after(n):t.closest(o.dropZone).after(n),this.broadcast("elementChanged",{pid:a.pid,uid:a.uid,targetPid:this.getCurrentPageId(),action:h?"copy":"move"});const y=document.querySelector(`.t3-page-column-lang-name[data-language-uid="${c}"]`);if(y===null)return;const C=y.dataset.flagIdentifier,b=y.dataset.languageTitle;v.getIcon(C,v.sizes.small).then(E=>{const D=n.querySelector(".t3js-flag");D.title=b,D.innerHTML=E})})}}onBroadcastElementChanged(e){e.detail.payload.pid===this.getCurrentPageId()&&e.detail.payload.targetPid!==e.detail.payload.pid&&e.detail.payload.action==="move"&&document.querySelector(`${o.content}[data-uid="${e.detail.payload.uid}"]`).remove()}ajaxAction(e,t){const n=Object.keys(e.cmd).shift(),d=parseInt(Object.keys(e.cmd[n]).shift(),10),a={component:"dragdrop",action:t?"copy":"move",table:n,uid:d},u=document.querySelector(".t3-grid-container");return I.process(e,a).then(i=>{if(i.hasErrors)throw i.messages;(t||u?.dataset.defaultLanguageBinding==="1")&&self.location.reload()})}getColumnPositionForElement(e){const t=e.closest("[data-colpos]");return t!==null&&t.dataset.colpos!==void 0?parseInt(t.dataset.colpos,10):!1}getDragTooltipMetadataFromContentElement(e){let t,n;const d=[],u=e.querySelector(".t3-page-ce-header-title").innerText,i=e.querySelector(".element-preview");i&&(t=i.innerText,t.length>80&&(t=t.substring(0,80)+"..."));const l=e.querySelector(".t3js-icon");l&&(n=l.dataset.identifier);const c=e.querySelectorAll(".preview-thumbnails-element-image img");return c.length>0&&c.forEach(p=>{d.push({src:p.src,height:p.height,width:p.width})}),{statusIconIdentifier:"actions-move",tooltipIconIdentifier:n,tooltipLabel:u,tooltipDescription:t,thumbnails:d}}getCurrentPageId(){return parseInt(document.querySelector("[data-page]").dataset.page,10)}broadcast(e,t){S.post(new P("page-layout-drag-drop",e,t||{}))}showDropZones(){document.querySelectorAll(o.dropZone).forEach(e=>{e.hidden=!1;const t=e.parentElement.querySelector(o.addContent);t!==null&&(t.hidden=!0,e.classList.add(g.validDropZoneClass))})}hideDropZones(){document.querySelectorAll(o.dropZone).forEach(e=>{e.hidden=!0;const t=e.parentElement.querySelector(o.addContent);t!==null&&(t.hidden=!1),e.classList.remove(g.validDropZoneClass)})}}var q=new Z;export{q as default};
