# This file was auto-generated by lib/generators/tasks/generate.rb

module Slack
  module Endpoint
    module Im
      #
      # Close a direct message channel.
      #
      # @option options [Object] :channel
      #   Direct message channel to close.
      # @see https://api.slack.com/methods/im.close
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.close.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.close.json
      def im_close(options={})
        throw ArgumentError.new("Required arguments :channel missing") if options[:channel].nil?
        post("im.close", options)
      end

      #
      # Fetches history of messages and events from direct message channel.
      #
      # @option options [Object] :channel
      #   Direct message channel to fetch history for.
      # @option options [Object] :count
      #   Number of messages to return, between 1 and 1000.
      # @option options [Object] :inclusive
      #   Include messages with latest or oldest timestamp in results.
      # @option options [Object] :latest
      #   End of time range of messages to include in results.
      # @option options [Object] :oldest
      #   Start of time range of messages to include in results.
      # @option options [Object] :unreads
      #   Include unread_count_display in the output?
      # @see https://api.slack.com/methods/im.history
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.history.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.history.json
      def im_history(options={})
        throw ArgumentError.new("Required arguments :channel missing") if options[:channel].nil?
        post("im.history", options)
      end

      #
      # Lists direct message channels for the calling user.
      #
      # @option options [Object] :cursor
      #   Paginate through collections of data by setting the cursor parameter to a next_cursor attribute returned by a previous request's response_metadata. Default value fetches the first "page" of the collection. See pagination for more detail.
      # @option options [Object] :limit
      #   The maximum number of items to return. Fewer than the requested number of items may be returned, even if the end of the users list hasn't been reached.
      # @see https://api.slack.com/methods/im.list
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.list.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.list.json
      def im_list(options={})
        post("im.list", options)
      end

      #
      # Sets the read cursor in a direct message channel.
      #
      # @option options [Object] :channel
      #   Direct message channel to set reading cursor in.
      # @option options [Object] :ts
      #   Timestamp of the most recently seen message.
      # @see https://api.slack.com/methods/im.mark
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.mark.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.mark.json
      def im_mark(options={})
        throw ArgumentError.new("Required arguments :channel missing") if options[:channel].nil?
        throw ArgumentError.new("Required arguments :ts missing") if options[:ts].nil?
        post("im.mark", options)
      end

      #
      # Opens a direct message channel.
      #
      # @option options [Object] :user
      #   User to open a direct message channel with.
      # @option options [Object] :include_locale
      #   Set this to true to receive the locale for this im. Defaults to false
      # @option options [Object] :return_im
      #   Boolean, indicates you want the full IM channel definition in the response.
      # @see https://api.slack.com/methods/im.open
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.open.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.open.json
      def im_open(options={})
        throw ArgumentError.new("Required arguments :user missing") if options[:user].nil?
        post("im.open", options)
      end

      #
      # Retrieve a thread of messages posted to a direct message conversation
      #
      # @option options [Object] :channel
      #   Direct message channel to fetch thread from
      # @option options [Object] :thread_ts
      #   Unique identifier of a thread's parent message
      # @see https://api.slack.com/methods/im.replies
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.replies.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/im.replies.json
      def im_replies(options={})
        throw ArgumentError.new("Required arguments :channel missing") if options[:channel].nil?
        throw ArgumentError.new("Required arguments :thread_ts missing") if options[:thread_ts].nil?
        post("im.replies", options)
      end

    end
  end
end
