/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sablecc.sablecc.BooleanCast;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.AHelperDef;
import org.sablecc.sablecc.node.AIdBasic;
import org.sablecc.sablecc.node.AIgnTokens;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.AStateList;
import org.sablecc.sablecc.node.AStateListTail;
import org.sablecc.sablecc.node.AStates;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.ATransition;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.TId;
import org.sablecc.sablecc.node.TPkgId;
import org.sablecc.sablecc.node.TSlash;
import org.sablecc.sablecc.node.Token;

public class ResolveIds
extends DepthFirstAdapter {
    public final Map helpers = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map states = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map tokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ignTokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map prods = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map alts = new TypedHashMap(StringCast.instance, NodeCast.instance);
    public final Map elems = new TypedHashMap(StringCast.instance, NodeCast.instance);
    public final Map names = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map errorNames = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map elemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map altsElemNameTypes = new TypedHashMap(StringCast.instance, StringCast.instance);
    public final Map altsElemTypes = new TypedHashMap(StringCast.instance, StringCast.instance);
    public final Map fixedTokens = new TypedHashMap(NodeCast.instance, BooleanCast.instance);
    public final List tokenList = new TypedLinkedList(StringCast.instance);
    public final LinkedList stateList = new TypedLinkedList(StringCast.instance);
    public File pkgDir;
    public String pkgName = "";
    String currentProd;
    String currentAlt;
    private int lastLine;
    private int lastPos;
    private Map stateMap;

    public ResolveIds(File currentDir) {
        this.pkgDir = currentDir;
    }

    @Override
    public void inAGrammar(AGrammar node) {
        TPkgId[] temp = node.getPackage().toArray(new TPkgId[0]);
        if (temp.length > 0) {
            this.pkgName = temp[0].getText();
            this.pkgDir = new File(this.pkgDir, temp[0].getText());
            for (int i = 1; i < temp.length; ++i) {
                this.pkgName = this.pkgName + "." + temp[i].getText();
                this.pkgDir = new File(this.pkgDir, temp[i].getText());
            }
            if (!this.pkgDir.exists() && !this.pkgDir.mkdirs()) {
                throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
            }
        }
    }

    @Override
    public void caseAProd(AProd node) {
        this.currentProd = ResolveIds.name(node.getId().getText());
        String name = "P" + this.currentProd;
        if (this.prods.put(name, node) != null) {
            ResolveIds.error(node.getId(), name);
        }
        this.names.put(node, name);
        Object[] list_alt = node.getAlts().toArray();
        for (int i = 0; i < list_alt.length; ++i) {
            ((PAlt)list_alt[i]).apply(this);
        }
    }

    @Override
    public void caseAIdBasic(AIdBasic node) {
        String name = node.getId().getText();
        if (this.helpers.get(name) == null) {
            ResolveIds.error2(node.getId(), name);
        }
    }

    @Override
    public void outAHelperDef(AHelperDef node) {
        String name = node.getId().getText();
        if (this.helpers.put(name, node) != null) {
            ResolveIds.error(node.getId(), name);
        }
        this.names.put(node, name);
    }

    @Override
    public void outATokenDef(ATokenDef node) {
        String name = "T" + ResolveIds.name(node.getId().getText());
        String errorName = ResolveIds.errorName(node.getId().getText());
        if (this.tokens.put(name, node) != null) {
            ResolveIds.error(node.getId(), name);
        }
        this.names.put(node, name);
        this.errorNames.put(node, errorName);
        this.tokenList.add(name);
        if (node.getLookAhead() != null) {
            TSlash token = node.getSlash();
            throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Look ahead not yet supported.");
        }
    }

    @Override
    public void inAStates(AStates node) {
        Object[] list_id = node.getListId().toArray();
        for (int i = 0; i < list_id.length; ++i) {
            String name = ((TId)list_id[i]).getText().toUpperCase();
            if (this.states.put(name, list_id[i]) != null) {
                ResolveIds.error((TId)list_id[i], name);
            }
            this.names.put(list_id[i], name);
            this.stateList.add(name);
        }
    }

    @Override
    public void inAIgnTokens(AIgnTokens node) {
        Object[] list_id = node.getListId().toArray();
        for (int i = 0; i < list_id.length; ++i) {
            String name = "T" + ResolveIds.name(((TId)list_id[i]).getText());
            if (this.tokens.get(name) == null) {
                ResolveIds.error2((TId)list_id[i], name);
            }
            if (this.ignTokens.put(name, list_id[i]) != null) {
                ResolveIds.error((TId)list_id[i], name);
            }
            this.names.put(list_id[i], name);
        }
    }

    @Override
    public void inAStateList(AStateList node) {
        this.stateMap = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
        String name = node.getId().getText().toUpperCase();
        if (this.states.get(name) == null) {
            ResolveIds.error2(node.getId(), name);
        }
        if (this.stateMap.put(name, node) != null) {
            ResolveIds.error(node.getId(), name);
        }
    }

    @Override
    public void outAStateList(AStateList node) {
        this.stateMap = null;
    }

    @Override
    public void inAStateListTail(AStateListTail node) {
        String name = node.getId().getText().toUpperCase();
        if (this.states.get(name) == null) {
            ResolveIds.error2(node.getId(), name);
        }
        if (this.stateMap.put(name, node) != null) {
            ResolveIds.error(node.getId(), name);
        }
    }

    @Override
    public void inATransition(ATransition node) {
        String name = node.getId().getText().toUpperCase();
        if (this.states.get(name) == null) {
            ResolveIds.error2(node.getId(), name);
        }
    }

    @Override
    public void caseAAlt(AAlt alt) {
        if (alt.getAltName() != null) {
            this.currentAlt = "A" + ResolveIds.name(alt.getAltName().getText()) + this.currentProd;
            if (this.alts.put(this.currentAlt, alt) != null) {
                ResolveIds.error(alt.getAltName(), this.currentAlt);
            }
            this.names.put(alt, this.currentAlt);
        } else {
            this.currentAlt = "A" + this.currentProd;
            if (this.alts.put(this.currentAlt, alt) != null) {
                this.error(this.currentAlt);
            }
            this.names.put(alt, this.currentAlt);
        }
        AElem[] list_elem = alt.getElems().toArray(new AElem[0]);
        for (int i = 0; i < list_elem.length; ++i) {
            list_elem[i].apply(this);
        }
    }

    public void defaultcase(Node node) {
        if (node instanceof Token) {
            Token t = (Token)node;
            this.lastLine = t.getLine();
            this.lastPos = t.getPos() + t.getText().length();
        }
    }

    @Override
    public void caseAAst(AAst node) {
    }

    @Override
    public void caseAElem(AElem elem) {
        if (elem.getElemName() != null) {
            String name = this.currentAlt + "." + ResolveIds.name(elem.getElemName().getText());
            if (this.elems.put(name, elem) != null) {
                ResolveIds.error(elem.getElemName(), name);
            }
            if (elem.getElemName().getText().equals("class")) {
                ResolveIds.error5(elem.getElemName());
            }
            this.names.put(elem, ResolveIds.name(elem.getElemName().getText()));
        } else {
            String name = this.currentAlt + "." + ResolveIds.name(elem.getId().getText());
            if (this.elems.put(name, elem) != null) {
                ResolveIds.error(elem.getId(), name);
            }
            if (elem.getId().getText().equals("class")) {
                ResolveIds.error5(elem.getId());
            }
            this.names.put(elem, ResolveIds.name(elem.getId().getText()));
        }
    }

    @Override
    public void outAProductions(AProductions prod) {
        prod.apply(new DepthFirstAdapter(){

            @Override
            public void caseAProd(AProd node) {
                ResolveIds.this.currentProd = ResolveIds.name(node.getId().getText());
                Object[] list_alt = node.getAlts().toArray();
                for (int i = 0; i < list_alt.length; ++i) {
                    ((PAlt)list_alt[i]).apply(this);
                }
            }

            @Override
            public void caseAAlt(AAlt alt) {
                ResolveIds.this.currentAlt = alt.getAltName() != null ? "A" + ResolveIds.name(alt.getAltName().getText()) + ResolveIds.this.currentProd : "A" + ResolveIds.this.currentProd;
                AElem[] list_elem = alt.getElems().toArray(new AElem[0]);
                for (int i = 0; i < list_elem.length; ++i) {
                    list_elem[i].apply(this);
                }
            }

            @Override
            public void caseAElem(AElem node) {
                String name = ResolveIds.name(node.getId().getText());
                String nameOfElem = node.getElemName() != null ? node.getElemName().getText() : node.getId().getText();
                if (node.getSpecifier() != null) {
                    if (node.getSpecifier() instanceof ATokenSpecifier) {
                        if (ResolveIds.this.tokens.get("T" + name) == null) {
                            ResolveIds.error2(node.getId(), "T" + name);
                        }
                        if (ResolveIds.this.ignTokens.get("T" + name) != null) {
                            ResolveIds.error3(node.getId(), "T" + name);
                        }
                        ResolveIds.this.elemTypes.put(node, "T" + name);
                        if (node.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + node.getElemName().getText(), "T" + name);
                        }
                        String type_name = name;
                        if (node.getUnOp() instanceof AStarUnOp || node.getUnOp() instanceof AQMarkUnOp) {
                            type_name = type_name + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + nameOfElem, "T" + type_name);
                    } else {
                        if (ResolveIds.this.prods.get("P" + name) == null) {
                            ResolveIds.error2(node.getId(), "P" + name);
                        }
                        ResolveIds.this.elemTypes.put(node, "P" + name);
                        if (node.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + node.getElemName().getText(), "P" + name);
                        }
                        String type_name = name;
                        if (node.getUnOp() instanceof AStarUnOp || node.getUnOp() instanceof AQMarkUnOp) {
                            type_name = type_name + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + nameOfElem, "P" + type_name);
                    }
                } else {
                    Object token = ResolveIds.this.tokens.get("T" + name);
                    Object ignToken = ResolveIds.this.ignTokens.get("T" + name);
                    Object production = ResolveIds.this.prods.get("P" + name);
                    if (token == null && production == null) {
                        ResolveIds.error2(node.getId(), "P" + name + " and T" + name);
                    }
                    if (token != null) {
                        if (production != null) {
                            ResolveIds.error4(node.getId(), "P" + name + " and T" + name);
                        }
                        if (ignToken != null) {
                            ResolveIds.error3(node.getId(), "T" + name);
                        }
                        ResolveIds.this.elemTypes.put(node, "T" + name);
                        if (node.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + node.getElemName().getText(), "T" + name);
                        }
                        String type_name = name;
                        if (node.getUnOp() instanceof AStarUnOp || node.getUnOp() instanceof AQMarkUnOp) {
                            type_name = type_name + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + nameOfElem, "T" + type_name);
                    } else {
                        ResolveIds.this.elemTypes.put(node, "P" + name);
                        if (node.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + node.getElemName().getText(), "P" + name);
                        }
                        String type_name = name;
                        if (node.getUnOp() instanceof AStarUnOp || node.getUnOp() instanceof AQMarkUnOp) {
                            type_name = type_name + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + nameOfElem, "P" + type_name);
                    }
                }
            }
        });
    }

    public static String name(String s) {
        StringBuffer result = new StringBuffer();
        boolean upcase = true;
        int length = s.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '_': {
                    upcase = true;
                    continue block4;
                }
                case '$': {
                    result.append(c);
                    upcase = true;
                    continue block4;
                }
                default: {
                    if (upcase) {
                        result.append(Character.toUpperCase(c));
                        upcase = false;
                        continue block4;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String errorName(String s) {
        StringBuffer result = new StringBuffer();
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '_': {
                    result.append(' ');
                    continue block3;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public void reinit() {
        this.names.clear();
        this.elemTypes.clear();
    }

    private static void error(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Redefinition of " + name + ".");
    }

    private void error(String name) {
        throw new RuntimeException("[" + this.lastLine + "," + this.lastPos + "] " + "Redefinition of " + name + ".");
    }

    private static void error2(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + name + " undefined.");
    }

    private static void error3(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + name + " is ignored.");
    }

    private static void error4(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "ambiguous " + name + ".");
    }

    private static void error5(Token token) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "class is an invalid element name.");
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String nl = System.getProperty("line.separator");
        s.append("Helpers:");
        s.append(nl);
        s.append(this.helpers);
        s.append(nl);
        s.append("States:");
        s.append(nl);
        s.append(this.states);
        s.append(nl);
        s.append("Tokens:");
        s.append(nl);
        s.append(this.tokens);
        s.append(nl);
        s.append("Ignored Tokens:");
        s.append(nl);
        s.append(this.ignTokens);
        s.append(nl);
        s.append("Productions:");
        s.append(nl);
        s.append(this.prods);
        s.append(nl);
        s.append("Alternatives:");
        s.append(nl);
        s.append(this.alts);
        s.append(nl);
        s.append("Elements:");
        s.append(nl);
        s.append(this.elems);
        s.append(nl);
        return s.toString();
    }
}

