/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.markedPos = this.pos;
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos < 0) {
                throw new ArrayIndexOutOfBoundsException(this.pos);
            }
            if (this.pos < this.count) {
                return this.buf[this.pos++] & (char)-1;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int numChars = Math.min(this.count - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, numChars);
            this.pos += numChars;
            return numChars;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        boolean bl = false;
        if (this.pos < this.count) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.pos = this.markedPos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            long numChars = Math.min((long)(this.count - this.pos), n < 0L ? 0L : n);
            this.pos = (int)((long)this.pos + numChars);
            return numChars;
        }
    }

    public CharArrayReader(char[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public CharArrayReader(char[] buffer, int offset, int length) {
        if (offset < 0 || length < 0 || offset > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.buf = buffer;
        this.count = offset + length;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.markedPos = this.pos = offset;
    }
}

