/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration EMPTY_ENUMERATION = EmptyEnumeration.getInstance();
    protected MutableTreeNode parent;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public void add(MutableTreeNode child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void remove(MutableTreeNode node2) {
        this.children.remove(node2);
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    public void insert(MutableTreeNode node2, int index) {
        this.children.insertElementAt(node2, index);
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public Enumeration children() {
        if (this.children.size() == 0) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setParent(MutableTreeNode node2) {
        this.parent = node2;
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node2) {
        return this.children.indexOf(node2);
    }

    public void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void removeAllChildren() {
        this.children.removeAllElements();
    }

    public boolean isNodeAncestor(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        TreeNode current = this;
        while (current != null && current != node2) {
            current = current.getParent();
        }
        boolean bl = false;
        if (current == node2) {
            bl = true;
        }
        return bl;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode node2) {
        if (node2 == null) {
            return false;
        }
        TreeNode current = node2;
        while (current != null && current != this) {
            current = current.getParent();
        }
        boolean bl = false;
        if (current == this) {
            bl = true;
        }
        return bl;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode node2) {
        TreeNode current = this;
        ArrayList list2 = new ArrayList();
        while (current != null) {
            list2.add(current);
            current = current.getParent();
        }
        current = node2;
        while (current != null) {
            if (list2.contains(current)) {
                return current;
            }
            current = current.getParent();
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode node2) {
        if (node2 == null) {
            return false;
        }
        boolean bl = false;
        if (node2.getRoot() == this.getRoot()) {
            bl = true;
        }
        return bl;
    }

    public int getDepth() {
        if (!this.allowsChildren || this.children.size() == 0) {
            return 0;
        }
        Stack stack = new Stack();
        stack.push(new Integer(0));
        TreeNode node2 = this.getChildAt(0);
        int depth = 0;
        int current = 1;
        while (!stack.empty()) {
            int size;
            int index;
            if (node2.getChildCount() != 0) {
                node2 = node2.getChildAt(0);
                stack.push(new Integer(0));
                ++current;
                continue;
            }
            if (current > depth) {
                depth = current;
            }
            do {
                node2 = node2.getParent();
                size = node2.getChildCount();
                index = (Integer)stack.pop() + 1;
                --current;
            } while (index >= size && node2 != this);
            if (index >= size) continue;
            node2 = node2.getChildAt(index);
            stack.push(new Integer(index));
            ++current;
        }
        return depth;
    }

    public int getLevel() {
        int count = -1;
        TreeNode current = this;
        do {
            current = current.getParent();
            ++count;
        } while (current != null);
        return count;
    }

    protected TreeNode[] getPathToRoot(TreeNode node2, int depth) {
        if (node2 == null) {
            if (depth == 0) {
                return null;
            }
            return new TreeNode[depth];
        }
        TreeNode[] path = this.getPathToRoot(node2.getParent(), depth + 1);
        path[path.length - depth - 1] = node2;
        return path;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] path = this.getPathToRoot(this, 0);
        Object[] object = new Object[path.length];
        int index = 0;
        while (index < path.length) {
            object[index] = ((DefaultMutableTreeNode)path[index]).getUserObject();
            ++index;
        }
        return object;
    }

    public TreeNode getRoot() {
        TreeNode current = this;
        TreeNode check = current.getParent();
        while (check != null) {
            current = check;
            check = current.getParent();
        }
        return current;
    }

    public boolean isRoot() {
        boolean bl = false;
        if (this.parent == null) {
            bl = true;
        }
        return bl;
    }

    public DefaultMutableTreeNode getNextNode() {
        DefaultMutableTreeNode sibling;
        if (this.getChildCount() != 0) {
            return (DefaultMutableTreeNode)this.getChildAt(0);
        }
        DefaultMutableTreeNode node2 = this;
        do {
            sibling = node2.getNextSibling();
            node2 = (DefaultMutableTreeNode)node2.getParent();
        } while (sibling == null && node2 != null);
        return sibling;
    }

    public DefaultMutableTreeNode getPreviousNode() {
        if (this.parent == null) {
            return null;
        }
        DefaultMutableTreeNode sibling = this.getPreviousSibling();
        if (sibling == null) {
            return (DefaultMutableTreeNode)this.parent;
        }
        if (sibling.getChildCount() != 0) {
            return sibling.getLastLeaf();
        }
        return sibling;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException();
        }
        TreeNode parent = this;
        Vector nodes = new Vector();
        nodes.add(this);
        while (parent != node2 && parent != null) {
            parent = parent.getParent();
            nodes.add(0, parent);
        }
        if (parent != node2) {
            throw new IllegalArgumentException();
        }
        return nodes.elements();
    }

    public boolean isNodeChild(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        boolean bl = false;
        if (node2.getParent() == this) {
            bl = true;
        }
        return bl;
    }

    public TreeNode getFirstChild() {
        return (TreeNode)this.children.firstElement();
    }

    public TreeNode getLastChild() {
        return (TreeNode)this.children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode node2) {
        if (node2 == null || node2.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node2) + 1;
        if (index == this.getChildCount()) {
            return null;
        }
        return this.getChildAt(index);
    }

    public TreeNode getChildBefore(TreeNode node2) {
        if (node2 == null || node2.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node2) - 1;
        if (index < 0) {
            return null;
        }
        return this.getChildAt(index);
    }

    public boolean isNodeSibling(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        boolean bl = false;
        if (node2.getParent() == this.getParent() && this.getParent() != null) {
            bl = true;
        }
        return bl;
    }

    public int getSiblingCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this) + 1;
        if (index == this.parent.getChildCount()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this) - 1;
        if (index < 0) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public boolean isLeaf() {
        boolean bl = false;
        if (this.children.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        TreeNode current = this;
        while (current.getChildCount() > 0) {
            current = current.getChildAt(0);
        }
        return current;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        TreeNode current = this;
        int size = current.getChildCount();
        while (size > 0) {
            current = current.getChildAt(size - 1);
            size = current.getChildCount();
        }
        return current;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        if (this.parent == null) {
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        if (this.parent == null) {
            return null;
        }
        return null;
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration e = this.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode current = (TreeNode)e.nextElement();
            if (!current.isLeaf()) continue;
            ++count;
        }
        return count;
    }

    private final /* synthetic */ void this() {
        this.children = new Vector();
    }

    public DefaultMutableTreeNode() {
        this(null, true);
    }

    public DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.this();
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class PreorderEnumeration
    implements Enumeration {
        TreeNode next;
        Stack childrenEnums;

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode current = this.next;
            Enumeration children = (Enumeration)this.childrenEnums.peek();
            this.next = this.traverse(children);
            return current;
        }

        private final TreeNode traverse(Enumeration children) {
            if (children.hasMoreElements()) {
                TreeNode child = (TreeNode)children.nextElement();
                this.childrenEnums.push(child.children());
                return child;
            }
            this.childrenEnums.pop();
            if (this.childrenEnums.isEmpty()) {
                return null;
            }
            return this.traverse((Enumeration)this.childrenEnums.peek());
        }

        private final /* synthetic */ void this() {
            this.childrenEnums = new Stack();
        }

        PreorderEnumeration(TreeNode node2) {
            this.this();
            this.next = node2;
            this.childrenEnums.push(node2.children());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class PostorderEnumeration
    implements Enumeration {
        Stack nodes;
        Stack childrenEnums;

        public boolean hasMoreElements() {
            return this.nodes.isEmpty() ^ true;
        }

        public Object nextElement() {
            if (this.nodes.isEmpty()) {
                throw new NoSuchElementException("No more elements left!");
            }
            Enumeration children = (Enumeration)this.childrenEnums.peek();
            return this.traverse(children);
        }

        private final Object traverse(Enumeration children) {
            if (children.hasMoreElements()) {
                TreeNode node2 = (TreeNode)children.nextElement();
                this.nodes.push(node2);
                Enumeration newChildren = node2.children();
                this.childrenEnums.push(newChildren);
                return this.traverse(newChildren);
            }
            this.childrenEnums.pop();
            Object next = this.nodes.peek();
            this.nodes.pop();
            return next;
        }

        private final /* synthetic */ void this() {
            this.nodes = new Stack();
            this.childrenEnums = new Stack();
        }

        PostorderEnumeration(TreeNode node2) {
            this.this();
            this.nodes.push(node2);
            this.childrenEnums.push(node2.children());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BreadthFirstEnumeration
    implements Enumeration {
        LinkedList queue;

        public boolean hasMoreElements() {
            return this.queue.isEmpty() ^ true;
        }

        public Object nextElement() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode node2 = (TreeNode)this.queue.removeFirst();
            Enumeration children = node2.children();
            while (children.hasMoreElements()) {
                this.queue.add(children.nextElement());
            }
            return node2;
        }

        private final /* synthetic */ void this() {
            this.queue = new LinkedList();
        }

        BreadthFirstEnumeration(TreeNode node2) {
            this.this();
            this.queue.add(node2);
        }
    }
}

