###############################################################################
# A script for sirc by THX-1138 <francois.fleuret@inria.fr>
# Copyright (C) 1998-1999 Francois Fleuret
# v1.3 Check http://www-rocq.inria.fr/~fleuret for news
#

#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation.
#

$thx_version = "1.4";

$add_ons.="+thx-v$thx_version.pl" if $add_ons !~ /thx/;

###############################################################################
# First a hook to highlight some of the public sentences

sub cmd_highlight {
    &getarg;
    if($newarg eq "-") { $highlight_pat = ""; }
    elsif($newarg) { $highlight_pat = $newarg; }
    if($highlight_pat) { &tell("*\cbt\cb* Highlightning pattern set to $highlight_pat"); }
    else { &tell("*\cbt\cb* Highlightning switched off"); }
}

sub hook_indique {
    if($highlight_pat) {
	if ($_[1] =~ /$highlight_pat/i) {
	    if(&eq ($_[0], $talkchannel)) {
		&tell("<\cb$who\cb> $_[1]");
	    } else {
		&tell("<\cb$who/$_[0]\cb> $_[1]");
	    };
	    $silent=1;
	}
    }
}

&addcmd("highlight");
&addhook("public", "indique");

###############################################################################
# A command to change login and reconnect ... to avoid login bans

sub cmd_chl {
    &tell("*\cbt\cb* Changing username, connect to $server.");
    &getarg;
    $username=$newarg;
    &docommand("/server $server");
    &tell("*\cbt\cb* Ok.");
}

&addcmd("chl");

###############################################################################
# A host-ban command

sub cmd_hban {
  &getarg;
  &tell("*\cbt\cb* Must specify a nick to host ban"), return unless $newarg;
  &tell("*\cbt\cb* You're not on a channel"), return unless $talkchannel;
  &userhost($newarg, "&sl(\"MODE $talkchannel +b *!*\\\@\$host\");");
}
&addcmd("hban");

###############################################################################
# Some corrections of n0thing's bugs ...  Login of 10 chars length
# with no ~ (identd running) were not banned correctly

sub cmd_kb {
  &getarg;
  local($why)=($args);
  $why="game over, man.  game over." unless $why;
  &tell("*\cb0\cb* Must specify a nick to kickban"), return unless $newarg;
  &tell("*\cb0\cb* You're not on a channel"), return unless $talkchannel;
  &userhost($newarg, "\$host=&n_hostpat(\$host); \$user =~ s/^\\~//; \$user =~ s/(\.{8})\.\*/\$1\*/;
&sl(\"MODE $talkchannel -o+b $newarg *!*\$user\\\@\$host\");
&sl(\"KICK $talkchannel $newarg :$why\");");
}
&addcmd("kb");

sub cmd_ban {
  &tell("*\cb0\cb* Must specify a nick to ban"), return unless $args;
  &tell("*\cb0\cb* You're not on a channel"), return unless $talkchannel;
  while (&getarg, $newarg ne '') {
    &userhost($newarg, "\$host=&n_hostpat(\$host); \$user =~ s/^\\~//; \$user =~ s/(\.{8})\.\*/\$1\*/;
      &sl(\"MODE $talkchannel +b *!*\$user\\\@\$host\");");
  }
}
&addcmd("ban");

###############################################################################
# A smart-message handler. Each message (msg or dcc chat) is stored
# until you send a msg (or send a dcc chat) to its sender. That way
# you can deal with many people at the same time. A '!' is added on
# the left in the status line if messages are waiting. If you dont
# send messages (private, public or dcc) for more than 5 minutes, any
# person msging you will get a warning in notice

$n_msg_max = 25;

sub hook_msg_handler {
    local($delay) = "";

    local($w) = $who; $w =~ tr/[A-Z]/[a-z]/;
    if($not_reply{$w}[0] < $n_msg_max)
    {
	$not_reply{$w}[0]++;
	$not_reply{$w}[1] .= "> $_[0]\n";
    } else {
	&tell("*\cbt\cb* \cb$who\cb sent to many messages!\n");
    }

    $delta_time = time - $reply_time;
    if($delta_time > 300) {
	use integer;
	if($delta_time > 86400) { $delay .= $delta_time/86400 . " days "; }
	if($delta_time > 3600) { $delay .= ($delta_time%86400)/3600 . " h "; }
	$delay .= ($delta_time%3600)/60 . " min";
	&sl("NOTICE $who :I have been quiet for $delay, I may be away ... messages are logged anyway"), $t_warningsent{$w}=1 unless $t_warningsent{$w};
    }

    $not_reply{$w}[2] = time;
    if($user) { $not_reply{$w}[3] = "${user}\@${host}"; }
    else { $not_reply{$w}[3] = "DCC"; }

    &dostatus;
} 

sub hook_msg_handler_dcc {
    hook_msg_handler($what);
}

sub hook_send_msg {
    local($w) = $towho; $w =~ tr/[A-Z]/[a-z]/;
    delete $not_reply{$w};
    &dostatus;
    $reply_time = time;
    delete @t_warningsent{keys %t_warningsent};
}

sub cmd_showmsg {
    if(keys %not_reply) {
	foreach $w ( keys %not_reply ) {
	    &tell("*\cbt\cb* \cb$w\cb ($not_reply{$w}[3] ".&date($not_reply{$w}[2]).")\n$not_reply{$w}[1]");
	}
    } else {
	&tell("*\cbt\cb* No messages.\n");
    }
}

sub cmd_clearmsg {
    &getarg;
    if($newarg) {
	local($w) = $newarg; $w =~ tr/[A-Z]/[a-z]/;
	delete $not_reply{$w};
	&tell("*\cbt\cb* Messages from $w erased.\n");
    } else {
	delete @not_reply{keys %not_reply};
	&tell("*\cbt\cb* Message list erased.\n");
    }
    &dostatus;
}

sub cmd_saway {
  &me("is away - $args - msgs are logged") if $talkchannel;
  &sl("AWAY :$args");
}

&addhook("send_text", "send_msg");
&addhook("send_dcc_chat", "send_msg");
&addhook("msg", "msg_handler");
&addhook("dcc_chat", "msg_handler_dcc");
&addcmd("showmsg");
&addcmd("clearmsg");
&addcmd("saway");

sub hook_msg_status {
    if(keys %not_reply) { $_[0] =~ s/./\!/; }
}

&addhook("status", "msg_status");

###############################################################################
# Random nick generator. If a "Nick alread taken" occurs, the script
# generates automatically a random nick by adding 4 random digits to
# the $thx_script string

sub hook_gennick {
    if($thx_nick) {
	$skip=1;
	if ($connected==2) {
	    &tell("*\cbt\cb* Nick already taken, you're still \"$nick\"");
	} else {
	    &tell("*\cbt\cb* Nick already taken! Generate a random one!");
	    $nick = $thx_nick . int(rand(10000));
	    &sl("NICK $nick");
	    &dostatus;
	}
    }
}

sub cmd_rndnick {
    &getarg;
    if($newarg eq "-") { $thx_nick = ""; }
    elsif($newarg) { $thx_nick = $newarg; }
    if($thx_nick) { &tell("*\cbt\cb* Random nick prefix set to $thx_nick"); }
    else { &tell("*\cbt\cb* Random nick generator switched off"); }
}

&addhook("433", "gennick");
&addcmd("rndnick");

###############################################################################
# Smart ban system. Find in a list what kind of ban (login, host,
# domain) to use for a given person
# !CONSTRUCTION IN PROGRESS!

#sub add_ban_policy {
#    local($pat, $policy)=@_;
#    $ban_policy{&slashify($pat)} = $policy;
#}
#
#sub smart_pattern {
#    local($uah)=@_;
#
#    foreach $pat ( keys %ban_policy ) {
#	&tell("*\cbt\cb* Looking for policy for $uah");
#	if($uah =~ /$pat/) {
#	    &tell("*\cbt\cb* Policy for $uah is $ban_policy{$pat}");
#	}
#    }
#    
#    return "*!*toto\@chose.truc.fr";
#}
#
#sub cmd_b {
#  &getarg;
#  &tell("*\cbt\cb* Must specify a nick to smart ban"), return unless $newarg;
#  &tell("*\cbt\cb* You're not on a channel"), return unless $talkchannel;
#  &userhost($newarg, "\$ban_pattern=\&smart_pattern(\$host); &sl(\"MODE $talkchannel +b \$ban_pattern\");");
#}
#&addcmd("b");
#
#add_ban_policy("*!*\@*cybercable.fr", "host");
#add_ban_policy("*!*\@*.fi", "domain");
#add_ban_policy("*!*\@*univ*.fr", "login");

&addhelp("thx", "List of \cbthx.pl\cb's functions :

/showmsg                shows the list of non-answered messages
/clearmsg [<nick>]      erases some or all messages from the list
/highlight <string>|-   sets, erases or shows the highlighting string
/rndnick <string>|-     sets, erases or shows the random nick prefix
/hban <nick>            bans the host on current channel
/chl <login>            changes the \$USERNAME and reconnect to the server
/saway <message>        sets away and do a /me message

Mail comments & bug reports to <francois.fleuret\@inria.fr>");

$reply_time = time;

&print("*\cbt\cb* \cbTHX-1138\cb's thx.pl v$thx_version loaded, type /help thx for help");
