.\" $Header: /home/vikas/netmgt/nocol/src/doc/RCS/perlnocol.3,v 1.3 1994/11/29 20:12:56 vikas Exp $
.\"
.TH PERLNOCOL 3 "December 1994"
.SH NAME
perlnocol \- PERL interface to NOCOL
.SH SYNOPSIS
.I nocollib.pl
is a library of useful PERL routines to facilitate writing PERL monitoring
scripts for NOCOL.
.\"
.SH DESCRIPTION
.LP
There is a collection of useful 
.I perl
subroutines in the file
.B nocollib.pl
which can be used to write new NOCOL monitors in the perl language.
A number of monitors are provided with the distribution (monitors for Unix
host performance, SNMP variables such as RMON, Novell services and routes,
Appletalk, modem-line usage).
Use these as examples to create new monitors. The PERL interface can
be used to parse the output of any Unix program (or command) and create 
NOCOL format data files.
.LP
The 
.B nocollib.pl
interface relies on a list of associative arrays (one for
each field on the nocol EVENT structure\-
.I $sender, $siteaddr, $varname, etc.
) which are global in the
main routines. Given an 'index' into this set of arrays, they
work on all these arrays as a set (packing, unpacking, updating, etc.).
The index is controlled by the 
.I main
of the programs and is typically an element of the list 
.IR @items .
.RS
.IP &nocol_startup
creates default config filenames, pidfilename, and sender name if none
provided. Sets up signal handlers to clean out datafile and pidfile on
exiting. Then kills any currently running process and writes its new pid to
the pidfile. Sets the variable
.I $ostype
with the operating system and version and forks if
.I $debug 
is not set.
.IP &init_event
takes an index and fills in startup default values for each of the
associative arrays mentioned above. It uses the 
.I $varunits, $varname
values initially set in the monitor.
.IP &calc_status
Given the three thresholds and a variable value, it calculates the
state (UP/DOWN), the threshold exceeded, and the maximum severity level
that it should be escalated to.
.IP &update_event
takes an index, status (up/down), value and severity as arguments.
It then updates the associative arrays (changes the severity, loglevel
and logs to
.IR noclogd )
based on the level change.
.IP &writeevent
This routine takes an index and packs the associative arrays into
a nocol packed structure. It then writes this structure out to 
the specified output data file.
.RE
.LP
To write a new monitor, use one of the existing monitors as a sample
and:
.RS
.IP -
Initialize the variables such as the Unix program to run, directories,
variable name, etc.
.IP -
Create a subroutine\-
.B readconf
to read a configuration file and create a list of items to monitor (structure
.IR @items ).
.IP -
Create a subroutine\-
.B dotest
to do the test. This can call the library routine
.B &calc_status
to find the state and severity of an item.
The results of the test can be returned immediately
to the main calling routine (for individual tests) or else pushed into
a list (if extracting multiple parameters in a single run).
.IP -
Call the subroutine
.B &nocol_main
which calls &dotest() and &calc_status().
Alternatively, you can create your own
.I main
routine which calls the above sub-routines, calls
.I &init_event
and writes out the datafile using 
.IR &writeevent .
.RE
.LP
Note that the status of the items being monitored are usually being stored
and tracked by the perl monitors (and not being read from the datafile in
each pass as some other C monitors do).
However, there is no reason that the datafile cannot be read and written to
if so desired.
.\"
.SH INSTALLATION
.LP
.IP -
Edit the variables at the top of the file \-
.B nocollib.pl
where indicated (more importantly, set
.I $nocolroot, $NLOG_HOST
at the minimum).
.IP -
Use the existing samples (
.I SAMPLE-monitor, armon, modemmon, novellmon
) to create new monitors.
.IP -
You might need to tweak the
.I $event_t
template and change the null padding for the packed
.I $event
structure (see CAVEATS below).
.IP -
Some of the monitoring agents use 
.B rcisco
to log into a remote host and run a command. Edit this program and put
your router's password in this file. Then install this with mode 750.
.LP
The PERL package is available from most popular archives on the Internet (
.I ftp.uu.net, ftp.netlabs.com
).
.\"
.SH CAVEATS
.I C 
compilers tend to align structure fields on even byte boundaries. In
packing a structure in PERL, the fields might not align evenly and
null byte(s) padding might be necessary in the
.I $event_t
template.
.SH AUTHOR
Library extracted and consolidated by Vikas Aggarwal, (vikas@navya.com) 
from the initial version from  Jim Wobus, Syracuse University
(jmwobus@mailbox.syr.edu). Contributions by many.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

