# Generated by Django 1.11.13 on 2018-08-10 10:29
from __future__ import unicode_literals

from django.db import migrations


def update_titles(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Page = apps.get_model('cms', 'Page')
    for page in Page.objects.using(db_alias):
        page.title_set.update(
            created_by=page.created_by,
            changed_by=page.changed_by,
            changed_date=page.changed_date,
            in_navigation=page.in_navigation,
            soft_root=page.soft_root,
            limit_visibility_in_menu=page.limit_visibility_in_menu,
            template=page.template,
            xframe_options=page.xframe_options,
        )


def set_page_url(apps, schema_editor):
    Page = apps.get_model('cms', 'Page')
    PageUrl = apps.get_model('cms', 'PageUrl')
    db_alias = schema_editor.connection.alias
    create_url = PageUrl.objects.using(db_alias).create

    for cms_page in Page.objects.all():
        for translation in cms_page.title_set.all():
            create_url(
                page=cms_page,
                slug=translation.slug,
                path=translation.path,
                managed=not bool(translation.has_url_overwrite),
                language=translation.language,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('cms', '0029_create_title_fields_and_url_model'),
    ]

    operations = [
        migrations.RunPython(update_titles),
        migrations.RunPython(set_page_url),
    ]
