'''OpenGL extension NV.polygon_mode

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.polygon_mode to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a PolygonModeNV entry point which can be used to change
	the polygon rasterization method. Using this extension, state consistent
	with rendering triangle primitives can trivially be toggled to render
	primitives as lines or points. In addition, independent enables are
	provided for polygon offset in conjunction with these new point and line
	polygon modes.
	
	This introduces a level of support for PolygonMode comparable with the
	OpenGL 4.3 core profile.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/polygon_mode.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.polygon_mode import *
from OpenGL.raw.GLES2.NV.polygon_mode import _EXTENSION_NAME

def glInitPolygonModeNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION