/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

public class BasicSliderUI
extends SliderUI {
    public static final int MAX_SCROLL = 2;
    public static final int MIN_SCROLL = -2;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int POSITIVE_SCROLL = 1;
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected TrackListener trackListener;
    protected Insets focusInsets;
    protected Insets insetCache;
    protected Rectangle contentRect;
    protected Rectangle focusRect;
    protected Rectangle thumbRect;
    protected Rectangle tickRect;
    protected Rectangle labelRect;
    protected Rectangle trackRect;
    protected int trackBuffer;
    protected boolean leftToRightCache;
    protected Timer scrollTimer;
    protected JSlider slider;
    private transient Color shadowColor;
    private transient Color highlightColor;
    private transient Color focusColor;

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent b) {
        return new BasicSliderUI((JSlider)b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSlider) {
            this.slider = (JSlider)c;
            this.focusRect = new Rectangle();
            this.contentRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.trackRect = new Rectangle();
            this.tickRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.insetCache = this.slider.getInsets();
            this.leftToRightCache = this.slider.getInverted() ^ true;
            this.scrollTimer = new Timer(200, null);
            this.scrollTimer.setRepeats(true);
            this.installDefaults(this.slider);
            this.installListeners(this.slider);
            this.installKeyboardActions(this.slider);
            this.calculateFocusRect();
            this.calculateContentRect();
            this.calculateThumbSize();
            this.calculateTrackBuffer();
            this.calculateTrackRect();
            this.calculateThumbLocation();
            this.calculateTickRect();
            this.calculateLabelRect();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallKeyboardActions(this.slider);
        this.uninstallListeners(this.slider);
        this.scrollTimer = null;
        this.focusRect = null;
        this.contentRect = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.tickRect = null;
        this.labelRect = null;
        this.focusInsets = null;
    }

    protected void installDefaults(JSlider slider) {
        LookAndFeel.installColors(slider, "Slider.background", "Slider.foreground");
        LookAndFeel.installBorder(slider, "Slider.border");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = UIManager.getInsets("Slider.focusInsets");
        slider.setOpaque(true);
    }

    protected TrackListener createTrackListener(JSlider slider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSlider slider) {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener(JSlider slider) {
        return new FocusHandler();
    }

    protected ScrollListener createScrollListener(JSlider slider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new PropertyChangeHandler();
    }

    protected void installListeners(JSlider slider) {
        this.propertyChangeListener = this.createPropertyChangeListener(slider);
        this.componentListener = this.createComponentListener(slider);
        this.trackListener = this.createTrackListener(slider);
        this.focusListener = this.createFocusListener(slider);
        this.changeListener = this.createChangeListener(slider);
        this.scrollListener = this.createScrollListener(slider);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        slider.addComponentListener(this.componentListener);
        slider.addMouseListener(this.trackListener);
        slider.addMouseMotionListener(this.trackListener);
        slider.addFocusListener(this.focusListener);
        slider.getModel().addChangeListener(this.changeListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    protected void uninstallListeners(JSlider slider) {
        slider.removePropertyChangeListener(this.propertyChangeListener);
        slider.removeComponentListener(this.componentListener);
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        slider.removeFocusListener(this.focusListener);
        slider.getModel().removeChangeListener(this.changeListener);
        this.scrollTimer.removeActionListener(this.scrollListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.trackListener = null;
        this.focusListener = null;
        this.changeListener = null;
        this.scrollListener = null;
    }

    protected void installKeyboardActions(JSlider slider) {
    }

    protected void uninstallKeyboardActions(JSlider slider) {
    }

    public Dimension getPreferredHorizontalSize() {
        int width;
        Insets insets = this.slider.getInsets();
        int n = this.getWidthOfWidestLabel();
        int n2 = 0;
        if (this.slider.getLabelTable() != null) {
            n2 = this.slider.getLabelTable().size();
        }
        if ((width = n * n2) < 200) {
            width = 200;
        }
        width += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right;
        int height = this.getThumbSize().height;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            height += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            height += this.getHeightOfTallestLabel();
        }
        return new Dimension(width, height += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
    }

    public Dimension getPreferredVerticalSize() {
        int height;
        Insets insets = this.slider.getInsets();
        int n = this.getHeightOfTallestLabel();
        int n2 = 0;
        if (this.slider.getLabelTable() != null) {
            n2 = this.slider.getLabelTable().size();
        }
        if ((height = n * n2) < 200) {
            height = 200;
        }
        height += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom;
        int width = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            width += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            width += this.getWidthOfWidestLabel();
        }
        return new Dimension(width += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, height);
    }

    public Dimension getMinimumHorizontalSize() {
        Insets insets = this.slider.getInsets();
        int height = this.getThumbSize().height;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            height += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            height += this.getHeightOfTallestLabel();
        }
        return new Dimension(36, height += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
    }

    public Dimension getMinimumVerticalSize() {
        Insets insets = this.slider.getInsets();
        int width = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            width += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            width += this.getWidthOfWidestLabel();
        }
        return new Dimension(width += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, 36);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.slider.getOrientation() == 0) {
            return this.getPreferredHorizontalSize();
        }
        return this.getPreferredVerticalSize();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.slider.getOrientation() == 0) {
            return this.getMinimumHorizontalSize();
        }
        return this.getMinimumVerticalSize();
    }

    public Dimension getMaximumSize(JComponent c) {
        Insets insets = this.slider.getInsets();
        if (this.slider.getOrientation() == 0) {
            int height = this.getThumbSize().height;
            if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
                height += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                height += this.getHeightOfTallestLabel();
            }
            return new Dimension(Short.MAX_VALUE, height += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
        }
        int width = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            width += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            width += this.getWidthOfWidestLabel();
        }
        return new Dimension(width += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, Short.MAX_VALUE);
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.insetCache = this.slider.getInsets();
        this.focusRect = SwingUtilities.calculateInnerArea(this.slider, this.focusRect);
        if (this.focusRect.width < 0) {
            this.focusRect.width = 0;
        }
        if (this.focusRect.height < 0) {
            this.focusRect.height = 0;
        }
    }

    protected void calculateThumbSize() {
        Dimension d = this.getThumbSize();
        this.thumbRect.width = d.width;
        this.thumbRect.height = d.height;
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y = this.trackRect.y;
        } else {
            this.thumbRect.x = this.trackRect.x;
        }
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - this.focusInsets.left - this.focusInsets.right;
        this.contentRect.height = this.focusRect.height - this.focusInsets.top - this.focusInsets.bottom;
        if (this.contentRect.width < 0) {
            this.contentRect.width = 0;
        }
        if (this.contentRect.height < 0) {
            this.contentRect.height = 0;
        }
    }

    protected void calculateThumbLocation() {
        int value = this.slider.getValue();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = this.xPositionForValue(value) - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = this.yPositionForValue(value) - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(11, 20);
        }
        return new Dimension(20, 11);
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            int h = this.getThumbSize().height;
            if (this.slider.getPaintTicks() && (this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0)) {
                h += this.getTickLength();
            }
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - h) / 2 - 1;
            this.trackRect.width = this.contentRect.width - 2 * this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int w = this.getThumbSize().width;
            if (this.slider.getPaintTicks() && (this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0)) {
                w += this.getTickLength();
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - w) / 2 - 1;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - 2 * this.trackBuffer;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (this.tickRect.y + this.tickRect.height > this.contentRect.y + this.contentRect.height) {
                this.tickRect.height = this.contentRect.y + this.contentRect.height - this.tickRect.y;
            }
        } else {
            this.tickRect.x = this.trackRect.x + this.trackRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.width = this.getTickLength();
            this.tickRect.height = this.trackRect.height;
            if (this.tickRect.x + this.tickRect.width > this.contentRect.x + this.contentRect.width) {
                this.tickRect.width = this.contentRect.x + this.contentRect.width - this.tickRect.x;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.contentRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.contentRect.width;
            this.labelRect.height = this.contentRect.height - this.labelRect.y;
        } else {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.contentRect.y;
            this.labelRect.width = this.contentRect.width - this.labelRect.x;
            this.labelRect.height = this.contentRect.height;
        }
    }

    protected int getWidthOfWidestLabel() {
        int widest = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration list2 = this.slider.getLabelTable().elements();
        while (list2.hasMoreElements()) {
            Component label;
            Dimension pref;
            Object comp = list2.nextElement();
            if (!(comp instanceof Component) || (pref = (label = (Component)comp).getPreferredSize()) == null || pref.width <= widest) continue;
            widest = pref.width;
        }
        return widest;
    }

    protected int getHeightOfTallestLabel() {
        int tallest = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration list2 = this.slider.getLabelTable().elements();
        while (list2.hasMoreElements()) {
            Component label;
            Dimension pref;
            Object comp = list2.nextElement();
            if (!(comp instanceof Component) || (pref = (label = (Component)comp).getPreferredSize()) == null || pref.height <= tallest) continue;
            tallest = pref.height;
        }
        return tallest;
    }

    protected int getWidthOfHighValueLabel() {
        Component highValueLabel = this.getHighestValueLabel();
        if (highValueLabel != null) {
            return highValueLabel.getWidth();
        }
        return 0;
    }

    protected int getWidthOfLowValueLabel() {
        Component lowValueLabel = this.getLowestValueLabel();
        if (lowValueLabel != null) {
            return lowValueLabel.getWidth();
        }
        return 0;
    }

    protected int getHeightOfHighValueLabel() {
        Component highValueLabel = this.getHighestValueLabel();
        if (highValueLabel != null) {
            return highValueLabel.getHeight();
        }
        return 0;
    }

    protected int getHeightOfLowValueLabel() {
        Component lowValueLabel = this.getLowestValueLabel();
        if (lowValueLabel != null) {
            return lowValueLabel.getHeight();
        }
        return 0;
    }

    protected boolean drawInverted() {
        return this.slider.getInverted() ^ this.leftToRightCache ^ true;
    }

    protected Component getLowestValueLabel() {
        Integer key = new Integer(Integer.MAX_VALUE);
        Dictionary labelTable = this.slider.getLabelTable();
        if (labelTable == null) {
            return null;
        }
        Enumeration list2 = labelTable.keys();
        while (list2.hasMoreElements()) {
            Integer tmpKey;
            Object value = list2.nextElement();
            if (!(value instanceof Integer) || (tmpKey = (Integer)value) >= key) continue;
            key = tmpKey;
        }
        Object comp = labelTable.get(key);
        if (!(comp instanceof Component)) {
            return null;
        }
        return (Component)comp;
    }

    protected Component getHighestValueLabel() {
        Integer key = new Integer(Integer.MIN_VALUE);
        Dictionary labelTable = this.slider.getLabelTable();
        if (labelTable == null) {
            return null;
        }
        Enumeration list2 = labelTable.keys();
        while (list2.hasMoreElements()) {
            Integer tmpKey;
            Object value = list2.nextElement();
            if (!(value instanceof Integer) || (tmpKey = (Integer)value) <= key) continue;
            key = tmpKey;
        }
        Object comp = labelTable.get(key);
        if (!(comp instanceof Component)) {
            return null;
        }
        return (Component)comp;
    }

    public void paint(Graphics g, JComponent c) {
        boolean bl = false;
        if (this.slider.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
            bl = true;
        }
        this.leftToRightCache = bl;
        this.calculateGeometry();
        if (this.slider.getPaintTrack()) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks()) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels()) {
            this.paintLabels(g);
        }
        this.paintThumb(g);
    }

    protected void recalculateIfInsetsChanged() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    protected void recalculateIfOrientationChanged() {
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    public void paintFocus(Graphics g) {
        Color saved_color = g.getColor();
        g.setColor(this.getFocusColor());
        g.drawRect(this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        g.setColor(saved_color);
    }

    public void paintTrack(Graphics g) {
        int height;
        int width;
        Color saved_color = g.getColor();
        Point a = new Point(this.trackRect.x, this.trackRect.y);
        Point b = new Point(a);
        Point c = new Point(a);
        Point d = new Point(a);
        if (this.slider.getOrientation() == 0) {
            width = this.trackRect.width;
            int n = 1;
            if (this.thumbRect.height / 4 != 0) {
                n = this.thumbRect.height / 4;
            }
            height = n;
            a.translate(0, this.trackRect.height / 2 - height / 2);
            b.translate(0, this.trackRect.height / 2 + height / 2);
            c.translate(this.trackRect.width, this.trackRect.height / 2 + height / 2);
            d.translate(this.trackRect.width, this.trackRect.height / 2 - height / 2);
        } else {
            int n = 1;
            if (this.thumbRect.width / 4 != 0) {
                n = this.thumbRect.width / 4;
            }
            width = n;
            height = this.trackRect.height;
            a.translate(this.trackRect.width / 2 - width / 2, 0);
            b.translate(this.trackRect.width / 2 - width / 2, this.trackRect.height);
            c.translate(this.trackRect.width / 2 + width / 2, this.trackRect.height);
            d.translate(this.trackRect.width / 2 + width / 2, 0);
        }
        g.setColor(Color.GRAY);
        g.fillRect(a.x, a.y, width, height);
        g.setColor(this.getHighlightColor());
        g.drawLine(b.x, b.y, c.x, c.y);
        g.drawLine(c.x, c.y, d.x, d.y);
        g.setColor(this.getShadowColor());
        g.drawLine(b.x, b.y, a.x, a.y);
        g.drawLine(a.x, a.y, d.x, d.y);
        g.setColor(saved_color);
    }

    public void paintTicks(Graphics g) {
        int i;
        double increment;
        double loc;
        int max = this.slider.getMaximum();
        int min = this.slider.getMinimum();
        int majorSpace = this.slider.getMajorTickSpacing();
        int minorSpace = this.slider.getMinorTickSpacing();
        if (majorSpace > 0) {
            if (this.slider.getOrientation() == 0) {
                loc = (double)this.tickRect.x + 0.5;
                double d = increment = max == min ? 0.0 : (double)majorSpace * (double)(this.tickRect.width - 1) / (double)(max - min);
                if (this.drawInverted()) {
                    loc += (double)this.tickRect.width;
                    increment *= -1.0;
                }
                g.translate(0, this.tickRect.y);
                i = min;
                while (i <= max) {
                    this.paintMajorTickForHorizSlider(g, this.tickRect, (int)loc);
                    loc += increment;
                    i += majorSpace;
                }
                g.translate(0, -this.tickRect.y);
            } else {
                loc = (double)(this.tickRect.height + this.tickRect.y) + 0.5;
                double d = increment = max == min ? 0.0 : (double)(-majorSpace) * (double)(this.tickRect.height - 1) / (double)(max - min);
                if (this.drawInverted()) {
                    loc = (double)this.tickRect.y + 0.5;
                    increment *= -1.0;
                }
                g.translate(this.tickRect.x, 0);
                i = min;
                while (i <= max) {
                    this.paintMajorTickForVertSlider(g, this.tickRect, (int)loc);
                    loc += increment;
                    i += majorSpace;
                }
                g.translate(-this.tickRect.x, 0);
            }
        }
        if (minorSpace > 0) {
            if (this.slider.getOrientation() == 0) {
                loc = (double)this.tickRect.x + 0.5;
                double d = increment = max == min ? 0.0 : (double)minorSpace * (double)(this.tickRect.width - 1) / (double)(max - min);
                if (this.drawInverted()) {
                    loc += (double)this.tickRect.width;
                    increment *= -1.0;
                }
                g.translate(0, this.tickRect.y);
                i = min;
                while (i <= max) {
                    this.paintMinorTickForHorizSlider(g, this.tickRect, (int)loc);
                    loc += increment;
                    i += minorSpace;
                }
                g.translate(0, -this.tickRect.y);
            } else {
                loc = (double)(this.tickRect.height + this.tickRect.y) + 0.5;
                double d = increment = max == min ? 0.0 : (double)(-minorSpace) * (double)(this.tickRect.height - 1) / (double)(max - min);
                if (this.drawInverted()) {
                    loc = (double)this.tickRect.y + 0.5;
                    increment *= -1.0;
                }
                g.translate(this.tickRect.x, 0);
                i = min;
                while (i <= max) {
                    this.paintMinorTickForVertSlider(g, this.tickRect, (int)loc);
                    loc += increment;
                    i += minorSpace;
                }
                g.translate(-this.tickRect.x, 0);
            }
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int y = this.tickRect.height / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x, y + this.tickRect.height / 4);
        g.setColor(saved);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int y = this.tickRect.height / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x, y + this.tickRect.height / 2);
        g.setColor(saved);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int x = this.tickRect.width / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x + this.tickRect.width / 4, y);
        g.setColor(saved);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int x = this.tickRect.width / 4;
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x, y, x + this.tickRect.width / 2, y);
        g.setColor(saved);
    }

    public void paintLabels(Graphics g) {
        block4: {
            if (this.slider.getLabelTable() == null) break block4;
            Dictionary table = this.slider.getLabelTable();
            if (this.slider.getOrientation() == 0) {
                Enumeration list2 = table.keys();
                while (list2.hasMoreElements()) {
                    Integer tmpKey;
                    Object element;
                    Object key = list2.nextElement();
                    if (!(key instanceof Integer) || !((element = table.get(tmpKey = (Integer)key)) instanceof JLabel)) continue;
                    Component label = (Component)element;
                    this.paintHorizontalLabel(g, tmpKey, label);
                }
            } else {
                Enumeration list3 = table.keys();
                while (list3.hasMoreElements()) {
                    Integer tmpKey;
                    Object element;
                    Object key = list3.nextElement();
                    if (!(key instanceof Integer) || !((element = table.get(tmpKey = (Integer)key)) instanceof JLabel)) continue;
                    Component label = (Component)element;
                    this.paintVerticalLabel(g, tmpKey, label);
                }
            }
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        Dimension dim = label.getPreferredSize();
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        int max = this.slider.getMaximum();
        int min = this.slider.getMinimum();
        if (value > max || value < min) {
            return;
        }
        int xpos = this.xPositionForValue(value) - w / 2;
        int ypos = this.labelRect.y;
        if (xpos < 0) {
            xpos = 0;
        }
        if (xpos + w > this.labelRect.x + this.labelRect.width) {
            w = this.labelRect.x + this.labelRect.width - xpos;
        }
        if (h > this.labelRect.height) {
            h = this.labelRect.height;
        }
        label.setBounds(xpos, ypos, w, h);
        SwingUtilities.paintComponent(g, label, null, label.getBounds());
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        Dimension dim = label.getPreferredSize();
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        int max = this.slider.getMaximum();
        int min = this.slider.getMinimum();
        if (value > max || value < min) {
            return;
        }
        int xpos = this.labelRect.x;
        int ypos = this.yPositionForValue(value) - h / 2;
        if (ypos < 0) {
            ypos = 0;
        }
        if (ypos + h > this.labelRect.y + this.labelRect.height) {
            h = this.labelRect.y + this.labelRect.height - ypos;
        }
        if (w > this.labelRect.width) {
            w = this.labelRect.width;
        }
        label.setBounds(xpos, ypos, w, h);
        SwingUtilities.paintComponent(g, label, null, label.getBounds());
    }

    public void paintThumb(Graphics g) {
        Polygon all;
        Polygon light;
        Polygon dark;
        Polygon bright;
        Color saved_color = g.getColor();
        Point a = new Point(this.thumbRect.x, this.thumbRect.y);
        Point b = new Point(a);
        Point c = new Point(a);
        Point d = new Point(a);
        Point e = new Point(a);
        if (this.slider.getOrientation() == 0) {
            int turnPoint = this.thumbRect.height * 3 / 4;
            b.translate(this.thumbRect.width - 1, 0);
            c.translate(this.thumbRect.width - 1, turnPoint);
            d.translate(this.thumbRect.width / 2 - 1, this.thumbRect.height - 1);
            e.translate(0, turnPoint);
            bright = new Polygon(new int[]{b.x - 1, a.x, e.x, d.x}, new int[]{b.y, a.y, e.y, d.y}, 4);
            dark = new Polygon(new int[]{b.x, c.x, d.x + 1}, new int[]{b.y, c.y - 1, d.y}, 3);
            light = new Polygon(new int[]{b.x - 1, c.x - 1, d.x + 1}, new int[]{b.y + 1, c.y - 1, d.y - 1}, 3);
            all = new Polygon(new int[]{a.x + 1, b.x - 2, c.x - 2, d.x, e.x + 1}, new int[]{a.y + 1, b.y + 1, c.y - 1, d.y - 1, e.y}, 5);
        } else {
            int turnPoint = this.thumbRect.width * 3 / 4 - 1;
            b.translate(turnPoint, 0);
            c.translate(this.thumbRect.width - 1, this.thumbRect.height / 2);
            d.translate(turnPoint, this.thumbRect.height - 1);
            e.translate(0, this.thumbRect.height - 1);
            bright = new Polygon(new int[]{c.x - 1, b.x, a.x, e.x}, new int[]{c.y - 1, b.y, a.y, e.y - 1}, 4);
            dark = new Polygon(new int[]{c.x, d.x, e.x}, new int[]{c.y, d.y, e.y}, 3);
            light = new Polygon(new int[]{c.x - 1, d.x, e.x + 1}, new int[]{c.y, d.y - 1, e.y - 1}, 3);
            all = new Polygon(new int[]{a.x + 1, b.x, c.x - 2, c.x - 2, d.x, e.x + 1}, new int[]{a.y + 1, b.y + 1, c.y - 1, c.y, d.y - 2, e.y - 2}, 6);
        }
        g.setColor(Color.WHITE);
        g.drawPolyline(bright.xpoints, bright.ypoints, bright.npoints);
        g.setColor(Color.BLACK);
        g.drawPolyline(dark.xpoints, dark.ypoints, dark.npoints);
        g.setColor(Color.GRAY);
        g.drawPolyline(light.xpoints, light.ypoints, light.npoints);
        g.setColor(Color.LIGHT_GRAY);
        g.drawPolyline(all.xpoints, all.ypoints, all.npoints);
        g.fillPolygon(all);
        g.setColor(saved_color);
    }

    public void setThumbLocation(int x, int y) {
        this.thumbRect.x = x;
        this.thumbRect.y = y;
    }

    public void scrollByBlock(int direction) {
        int unit = direction * (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
        int moveTo = this.slider.getValue() + unit;
        if (this.slider.getSnapToTicks()) {
            moveTo = this.findClosestTick(moveTo);
        }
        this.slider.setValue(moveTo);
    }

    public void scrollByUnit(int direction) {
        int moveTo = this.slider.getValue() + direction;
        if (this.slider.getSnapToTicks()) {
            moveTo = this.findClosestTick(moveTo);
        }
        this.slider.setValue(moveTo);
    }

    protected void scrollDueToClickInTrack(int dir) {
        this.scrollTimer.stop();
        this.scrollListener.setDirection(dir);
        this.scrollListener.setScrollByBlock(true);
        this.scrollTimer.start();
    }

    protected int xPositionForValue(int value) {
        int xPos;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.width - 1;
        int n = 0;
        if (max != min) {
            n = xPos = (value - min) * len / (max - min);
        }
        if (!this.drawInverted()) {
            xPos += this.trackRect.x;
        } else {
            xPos = len - xPos;
            xPos += this.trackRect.x;
        }
        return xPos;
    }

    protected int yPositionForValue(int value) {
        int yPos;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.height - 1;
        int n = 0;
        if (max != min) {
            n = yPos = (value - min) * len / (max - min);
        }
        if (!this.drawInverted()) {
            yPos = len - yPos;
            yPos += this.trackRect.y;
        } else {
            yPos += this.trackRect.y;
        }
        return yPos;
    }

    public int valueForYPosition(int yPos) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.height;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = !this.drawInverted() ? (len - (yPos - this.trackRect.y)) * (max - min) / len + min : (yPos - this.trackRect.y) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public int valueForXPosition(int xPos) {
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int len = this.trackRect.width;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = !this.drawInverted() ? (xPos - this.trackRect.x) * (max - min) / len + min : (len - (xPos - this.trackRect.x)) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    int findClosestTick(int value) {
        int lowerBound;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int majorSpace = this.slider.getMajorTickSpacing();
        int minorSpace = this.slider.getMinorTickSpacing();
        int minor = min - value;
        int major = min - value;
        if (majorSpace <= 0 && minorSpace <= 0) {
            return value;
        }
        if (majorSpace > 0) {
            lowerBound = (value - min) / majorSpace;
            int majLower = majorSpace * lowerBound + min;
            int majHigher = majorSpace * (lowerBound + 1) + min;
            major = majHigher <= max && majHigher - value <= value - majLower ? majHigher - value : majLower - value;
        }
        if (minorSpace > 0) {
            lowerBound = value / minorSpace;
            int minLower = minorSpace * lowerBound;
            int minHigher = minorSpace * (lowerBound + 1);
            minor = minHigher <= max && minHigher - value <= value - minLower ? minHigher - value : minLower - value;
        }
        if (Math.abs(minor) > Math.abs(major)) {
            return value + major;
        }
        return value + minor;
    }

    public BasicSliderUI(JSlider b) {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TrackListener
    extends MouseInputAdapter {
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) - this.offset : BasicSliderUI.this.valueForYPosition(this.currentMouseY) - this.offset;
                BasicSliderUI.this.slider.setValue(value);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
            if (BasicSliderUI.this.slider.getSnapToTicks()) {
                value = BasicSliderUI.this.findClosestTick(value);
            }
            if (!BasicSliderUI.this.thumbRect.contains(e.getPoint())) {
                if (value > BasicSliderUI.this.slider.getValue()) {
                    BasicSliderUI.this.scrollDueToClickInTrack(1);
                } else {
                    BasicSliderUI.this.scrollDueToClickInTrack(-1);
                }
            } else {
                BasicSliderUI.this.slider.setValueIsAdjusting(true);
                this.offset = value - BasicSliderUI.this.slider.getValue();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
                if (BasicSliderUI.this.slider.getSnapToTicks()) {
                    BasicSliderUI.this.slider.setValue(BasicSliderUI.this.findClosestTick(BasicSliderUI.this.slider.getValue()));
                }
            }
            if (BasicSliderUI.this.scrollTimer != null) {
                BasicSliderUI.this.scrollTimer.stop();
            }
        }

        public boolean shouldScroll(int direction) {
            int value = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
            if (direction == 1) {
                boolean bl = false;
                if (value > BasicSliderUI.this.slider.getValue()) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (value < BasicSliderUI.this.slider.getValue()) {
                bl = true;
            }
            return bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicSliderUI.this.calculateThumbLocation();
            BasicSliderUI.this.slider.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            BasicSliderUI.this.calculateGeometry();
            BasicSliderUI.this.slider.revalidate();
            BasicSliderUI.this.slider.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ScrollListener
    implements ActionListener {
        private transient int direction;
        private transient boolean block;

        public void actionPerformed(ActionEvent e) {
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                BasicSliderUI.this.scrollTimer.stop();
                return;
            }
            if (this.block) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.block = block;
        }

        public ScrollListener() {
            this.direction = 1;
            this.block = false;
        }

        public ScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.block = block;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("orientation")) {
                BasicSliderUI.this.recalculateIfOrientationChanged();
            } else if (e.getPropertyName().equals("model")) {
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                oldModel.removeChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.slider.getModel().addChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.calculateThumbLocation();
            }
            BasicSliderUI.this.slider.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ActionScroller
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
        }

        public ActionScroller(JSlider slider, int dir, boolean block) {
        }
    }
}

