/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.VerticalAlignment;
import org.diylc.core.IDIYComponent;
import org.diylc.core.annotations.EditableProperty;

public abstract class AbstractComponent<T>
implements IDIYComponent<T> {
    private static final long serialVersionUID = 1L;
    protected String name = "";
    public static Color SELECTION_COLOR = Color.red;
    public static Color LABEL_COLOR = Color.black;
    public static Color LABEL_COLOR_SELECTED = Color.red;
    public static Font LABEL_FONT = new Font("Tahoma", 0, 14);
    public static Color METAL_COLOR = Color.decode("#236B8E");

    @Override
    @EditableProperty(defaultable=false)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean canControlPointOverlap(int n) {
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getValueForDisplay() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    protected int getClosestOdd(double d) {
        return (int)d / 2 * 2 + 1;
    }

    protected boolean checkPointsClipped(Shape shape) {
        int n;
        for (n = 0; n < this.getControlPointCount(); ++n) {
            if (!shape.contains(this.getControlPoint(n))) continue;
            return false;
        }
        n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.getControlPointCount(); ++i) {
            Point point = this.getControlPoint(i);
            if (n > point.x) {
                n = point.x;
            }
            if (n3 < point.x) {
                n3 = point.x;
            }
            if (n2 > point.y) {
                n2 = point.y;
            }
            if (n4 >= point.y) continue;
            n4 = point.y;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, n3 - n, n4 - n2);
        return !shape.intersects(double_);
    }

    protected void drawCenteredText(Graphics2D graphics2D, String string, int n, int n2, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds(string, graphics2D).getBounds();
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        Rectangle rectangle2 = glyphVector.getVisualBounds().getBounds();
        int n3 = 0;
        switch (horizontalAlignment) {
            case CENTER: {
                n3 = n - rectangle.width / 2;
                break;
            }
            case LEFT: {
                n3 = n;
                break;
            }
            case RIGHT: {
                n3 = n - rectangle.width;
            }
        }
        int n4 = 0;
        switch (verticalAlignment) {
            case TOP: {
                n4 = n2 + rectangle.height;
                break;
            }
            case CENTER: {
                n4 = n2 - rectangle2.height / 2 - rectangle2.y;
                break;
            }
            case BOTTOM: {
                n4 = n2 - rectangle2.y;
            }
        }
        graphics2D.drawString(string, n3, n4);
    }

    @Override
    public IDIYComponent<T> clone() throws CloneNotSupportedException {
        try {
            AbstractComponent abstractComponent = (AbstractComponent)this.getClass().getConstructors()[0].newInstance(new Object[0]);
            Class<?> clazz = this.getClass();
            while (AbstractComponent.class.isAssignableFrom(clazz)) {
                Field[] fieldArray = clazz.getDeclaredFields();
                clazz = clazz.getSuperclass();
                for (Field field : fieldArray) {
                    if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object object = field.get(this);
                    if (object != null && object.getClass().isArray() && object.getClass().getComponentType().isAssignableFrom(Point.class)) {
                        Object object2 = Array.newInstance(object.getClass().getComponentType(), Array.getLength(object));
                        for (int i = 0; i < Array.getLength(object); ++i) {
                            Point point = (Point)Array.get(object, i);
                            Array.set(object2, i, new Point(point));
                        }
                        object = object2;
                    }
                    if (object != null && object instanceof Point) {
                        object = new Point((Point)object);
                    }
                    field.set(abstractComponent, object);
                }
            }
            return abstractComponent;
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Could not clone the component. Reason: " + exception.getMessage());
        }
    }

    @Override
    public boolean equalsTo(IDIYComponent<?> iDIYComponent) {
        if (iDIYComponent == null) {
            return false;
        }
        if (!iDIYComponent.getClass().equals(this.getClass())) {
            return false;
        }
        Class<?> clazz = this.getClass();
        while (AbstractComponent.class.isAssignableFrom(clazz)) {
            Field[] fieldArray = clazz.getDeclaredFields();
            clazz = clazz.getSuperclass();
            for (Field field : fieldArray) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                try {
                    Object object = field.get(this);
                    Object object2 = field.get(iDIYComponent);
                    if (this.compareObjects(object, object2)) continue;
                    return false;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return true;
    }

    private boolean compareObjects(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }
}

