/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.picl.SchemaParser;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private final String PICL_SCHEMA = "picl.rnc";
    private Schema piclSchema = null;
    private final PropertyMap properties;

    SchemaReceiverImpl(PropertyMap propertyMap) {
        this.properties = SinglePropertyMap.newInstance(ValidateProperty.ERROR_HANDLER, propertyMap.get(ValidateProperty.ERROR_HANDLER));
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) throws SAXException {
        SchemaParser schemaParser = new SchemaParser(this.properties, this.getPiclSchema());
        xMLReader.setContentHandler(schemaParser);
        return schemaParser;
    }

    private Schema getPiclSchema() throws SAXException {
        if (this.piclSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + "picl.rnc";
            URL uRL = SchemaReceiverImpl.getResource(string2);
            try {
                this.piclSchema = CompactSchemaReader.getInstance().createSchema(new InputSource(uRL.toString()), this.properties);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new SAXException("unexpected internal error in RNC schema for picl");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        return this.piclSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }
}

