/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.AWTUtilities;
import free.util.Localization;
import free.util.models.BooleanListener;
import free.util.models.BooleanModel;
import free.util.models.ConstBooleanModel;
import free.util.swing.LocalizationService;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJPanel;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FullscreenPanel
extends FixedJPanel {
    private final Component target;
    private final JPanel restorePanel;
    private boolean allowExclusiveMode;
    private final BooleanModel fullscreenModeModel;
    private boolean beingModified = false;
    private JFrame fullscreenFrame = null;
    private boolean isRealFullscreen;
    private int originalFrameState;
    private Frame originalFrame;

    public FullscreenPanel(Component component) {
        super(new BorderLayout());
        this.target = component;
        this.beingModified = true;
        this.add(component, "Center");
        this.beingModified = false;
        this.fullscreenModeModel = new BooleanModel(false);
        this.fullscreenModeModel.addListener(new BooleanListener(){

            public void modelChanged(ConstBooleanModel constBooleanModel) {
                FullscreenPanel.this.setFullscreen(constBooleanModel.isOn());
            }
        });
        this.restorePanel = this.createRestorePanel();
    }

    private JPanel createRestorePanel() {
        Localization localization = LocalizationService.getForClass(FullscreenPanel.class);
        JButton jButton = new JButton(localization.getString("restoreNormalModeButton.text"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullscreenPanel.this.getFullscreenModeModel().setOff();
            }
        });
        jButton.setAlignmentX(0.5f);
        JLabel jLabel = new JLabel(localization.getString("fullscreenInfoLabel.text"));
        jLabel.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    public void add(Component component, Object object, int n) {
        if (!this.beingModified) {
            throw new IllegalStateException("You may not add components to FullscreenPanel");
        }
        super.add(component, object, n);
    }

    public void remove(int n) {
        if (!this.beingModified) {
            throw new IllegalStateException("You may not remove components from FullscreenPanel");
        }
        super.remove(n);
    }

    public void setAllowExclusiveMode(boolean bl) {
        this.allowExclusiveMode = bl;
    }

    private void setFullscreen(boolean bl) {
        this.beingModified = true;
        if (bl) {
            this.makeFullscreen();
        } else {
            this.makeNormal();
        }
        this.beingModified = false;
    }

    public BooleanModel getFullscreenModeModel() {
        return this.fullscreenModeModel;
    }

    private void makeFullscreen() {
        this.remove(this.target);
        this.add(this.restorePanel);
        this.validate();
        if (this.allowExclusiveMode && FullscreenPanel.securityManagerAllowsFullscreen()) {
            this.fullscreenFrame = this.setRealFullscreen();
            this.isRealFullscreen = true;
        } else {
            this.fullscreenFrame = this.setFakeFullscreen();
        }
        this.fullscreenFrame.getContentPane().setLayout(new BorderLayout());
        this.fullscreenFrame.getContentPane().add(this.target, "Center");
        this.fullscreenFrame.getContentPane().validate();
    }

    private static boolean securityManagerAllowsFullscreen() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        try {
            securityManager.checkPermission(new AWTPermission("fullScreenExclusive"));
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private JFrame setRealFullscreen() {
        this.originalFrame = SwingUtils.frameForComponent(this);
        JFrame jFrame = new JFrame(this.originalFrame == null ? "" : this.originalFrame.getTitle());
        if (this.originalFrame != null) {
            jFrame.setIconImage(this.originalFrame.getIconImage());
        }
        jFrame.setUndecorated(true);
        jFrame.setResizable(false);
        GraphicsDevice graphicsDevice = SwingUtils.frameForComponent(this).getGraphicsConfiguration().getDevice();
        if (this.originalFrame != null) {
            this.originalFrameState = this.originalFrame.getExtendedState();
            this.originalFrame.setVisible(false);
            graphicsDevice.setFullScreenWindow(jFrame);
        }
        return jFrame;
    }

    private JFrame setFakeFullscreen() {
        this.originalFrame = SwingUtils.frameForComponent(this);
        JFrame jFrame = new JFrame(this.originalFrame == null ? "" : this.originalFrame.getTitle());
        jFrame.setUndecorated(true);
        jFrame.setResizable(false);
        Rectangle rectangle = AWTUtilities.getUsableScreenBounds();
        jFrame.setBounds(rectangle);
        jFrame.setVisible(true);
        jFrame.toFront();
        return jFrame;
    }

    private void makeNormal() {
        this.fullscreenFrame.getContentPane().remove(this.target);
        if (this.isRealFullscreen) {
            this.makeRealNormal();
        } else {
            this.makeFakeNormal();
        }
        this.remove(this.restorePanel);
        this.add(this.target, "Center");
        this.validate();
        this.fullscreenFrame = null;
    }

    private void makeRealNormal() {
        this.fullscreenFrame.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
        this.fullscreenFrame.dispose();
        if (this.originalFrame != null) {
            this.originalFrame.setExtendedState(this.originalFrameState);
            this.originalFrame.setVisible(true);
        }
    }

    private void makeFakeNormal() {
        this.fullscreenFrame.dispose();
    }
}

