/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_SZ_H
#define VATOMIC_CORE_SZ_H
/*******************************************************************************
 * @file core_sz.h
 * @brief Atomic functions for vatomicsz_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomicsz_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomicsz_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomicsz_init(vatomicsz_t *a, vsize_t v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_read(const vatomicsz_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline vsize_t vatomicsz_read_acq(const vatomicsz_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_read_rlx(const vatomicsz_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomicsz_write(vatomicsz_t *a, vsize_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomicsz_write_rel(vatomicsz_t *a, vsize_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomicsz_write_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_xchg(vatomicsz_t *a, vsize_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_xchg_acq(vatomicsz_t *a, vsize_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_xchg_rel(vatomicsz_t *a, vsize_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_xchg_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vsize_t vatomicsz_cmpxchg(vatomicsz_t *a, vsize_t e, vsize_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vsize_t vatomicsz_cmpxchg_acq(vatomicsz_t *a, vsize_t e,
                                            vsize_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vsize_t vatomicsz_cmpxchg_rel(vatomicsz_t *a, vsize_t e,
                                            vsize_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vsize_t vatomicsz_cmpxchg_rlx(vatomicsz_t *a, vsize_t e,
                                            vsize_t v);

/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_max(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_max_acq(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord release
 */
static inline vsize_t vatomicsz_get_max_rel(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_max_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_max_get(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord acquire
 */
static inline vsize_t vatomicsz_max_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord release
 */
static inline vsize_t vatomicsz_max_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_max_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord seq_cst
 */
static inline void vatomicsz_max(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord release
 */
static inline void vatomicsz_max_rel(vatomicsz_t *a, vsize_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord relaxed
 */
static inline void vatomicsz_max_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_and(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_and_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_and_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_and_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_and_get(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_and_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_and_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_and_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomicsz_and(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomicsz_and_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomicsz_and_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_or(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_or_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_or_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_or_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_or_get(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_or_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_or_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_or_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomicsz_or(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomicsz_or_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomicsz_or_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_xor(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_xor_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_xor_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_xor_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_xor_get(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_xor_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_xor_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_xor_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomicsz_xor(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomicsz_xor_rel(vatomicsz_t *a, vsize_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomicsz_xor_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_add(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_add_acq(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_add_rel(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_add_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_add_get(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_add_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_add_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_add_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord seq_cst
 */
static inline void vatomicsz_add(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord release
 */
static inline void vatomicsz_add_rel(vatomicsz_t *a, vsize_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord relaxed
 */
static inline void vatomicsz_add_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_inc(vatomicsz_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_inc_acq(vatomicsz_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_inc_rel(vatomicsz_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_inc_rlx(vatomicsz_t *a);

/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_inc_get(vatomicsz_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_inc_get_acq(vatomicsz_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord release
 */
static inline vsize_t vatomicsz_inc_get_rel(vatomicsz_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_inc_get_rlx(vatomicsz_t *a);

/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomicsz_inc(vatomicsz_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomicsz_inc_rel(vatomicsz_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomicsz_inc_rlx(vatomicsz_t *a);

/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_sub(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_sub_acq(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_sub_rel(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_sub_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_sub_get(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_sub_get_acq(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_sub_get_rel(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_sub_get_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord seq_cst
 */
static inline void vatomicsz_sub(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord release
 */
static inline void vatomicsz_sub_rel(vatomicsz_t *a, vsize_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord relaxed
 */
static inline void vatomicsz_sub_rlx(vatomicsz_t *a, vsize_t v);

/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_get_dec(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vsize_t vatomicsz_get_dec_acq(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vsize_t vatomicsz_get_dec_rel(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_get_dec_rlx(vatomicsz_t *a);

/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
static inline vsize_t vatomicsz_dec_get(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
static inline vsize_t vatomicsz_dec_get_acq(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
static inline vsize_t vatomicsz_dec_get_rel(vatomicsz_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
static inline vsize_t vatomicsz_dec_get_rlx(vatomicsz_t *a);

/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomicsz_dec(vatomicsz_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomicsz_dec_rel(vatomicsz_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomicsz_dec_rlx(vatomicsz_t *a);

#endif
