/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class NodeTypeTest
extends Test {
    final short type;
    final String data;

    public final short getNodeType() {
        return this.type;
    }

    public final String getData() {
        return this.data;
    }

    public final boolean matches(Node node2, int pos, int len) {
        short nodeType = node2.getNodeType();
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                if (this.type > 0) {
                    if (nodeType != this.type) {
                        return false;
                    }
                    if (this.data != null && !this.data.equals(node2.getNodeValue())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public final Test clone(Object context) {
        return new NodeTypeTest(this.type, this.data);
    }

    public final boolean references(QName var) {
        return false;
    }

    public final String toString() {
        switch (this.type) {
            case 0: {
                return "node()";
            }
            case 3: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                if (this.data != null) {
                    return "processing-instruction('" + this.data + "')";
                }
                return "processing-instruction()";
            }
        }
        throw new IllegalStateException();
    }

    public NodeTypeTest(short type) {
        this(type, null);
    }

    public NodeTypeTest(short type, String data) {
        this.type = type;
        this.data = data;
    }
}

