/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class VCFContigHeaderLine
extends VCFSimpleHeaderLine {
    final Integer contigIndex;

    public VCFContigHeaderLine(String line, VCFHeaderVersion version, String key, int contigIndex) {
        super(line, version, key, null, Collections.emptyList());
        if (contigIndex < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = contigIndex;
    }

    public VCFContigHeaderLine(Map<String, String> mapping, int contigIndex) {
        super("contig", mapping);
        if (contigIndex < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = contigIndex;
    }

    VCFContigHeaderLine(final SAMSequenceRecord sequenceRecord, final String assembly) {
        super("contig", (Map<String, String>)new LinkedHashMap<String, String>(){
            {
                this.put("ID", sequenceRecord.getSequenceName());
                this.put("length", Integer.toString(sequenceRecord.getSequenceLength()));
                if (assembly != null) {
                    this.put("assembly", assembly);
                }
            }
        });
        this.contigIndex = sequenceRecord.getSequenceIndex();
    }

    public Integer getContigIndex() {
        return this.contigIndex;
    }

    public SAMSequenceRecord getSAMSequenceRecord() {
        String lengthString = this.getGenericFieldValue("length");
        int length = lengthString == null ? 0 : Integer.parseInt(lengthString);
        SAMSequenceRecord record = new SAMSequenceRecord(this.getID(), length);
        record.setAssembly(this.getGenericFieldValue("assembly"));
        record.setSequenceIndex(this.contigIndex);
        return record;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        VCFContigHeaderLine that = (VCFContigHeaderLine)o;
        return this.contigIndex.equals(that.contigIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.contigIndex.hashCode();
        return result;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof VCFContigHeaderLine) {
            return this.contigIndex.compareTo(((VCFContigHeaderLine)other).contigIndex);
        }
        return super.compareTo(other);
    }
}

