/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.filechooser.SubtreeFileChooserUI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;

public class FileTransferHandler
implements DropTargetListener {
    private JFileChooser fileChooser;

    public FileTransferHandler(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public void setFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public void dragEnter(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    private void handleDrag(DropTargetDragEvent evt) {
        if (!evt.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
            evt.rejectDrag();
        }
        if (evt.getDropAction() != 1) {
            if ((evt.getSourceActions() & 1) != 0) {
                evt.acceptDrag(1);
            } else {
                evt.rejectDrag();
            }
        }
    }

    public void dragOver(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
        this.handleDrag(evt);
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void drop(DropTargetDropEvent evt) {
        evt.acceptDrop(1);
        boolean success = false;
        try {
            List files;
            File[] fileArray;
            if (this.fileChooser != null && (fileArray = (files = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[files.size()])).length > 0) {
                if (this.fileChooser.getUI() instanceof SubtreeFileChooserUI) {
                    File dir = fileArray[0];
                    if (dir.isDirectory() && fileArray.length == 1 && this.fileChooser.getFileSelectionMode() == 0) {
                        ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).setRootDirectory(dir);
                    } else {
                        if ((dir = dir.getParentFile()) != null) {
                            ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).setRootDirectory(dir);
                        }
                        this.fileChooser.setSelectedFiles(fileArray);
                    }
                } else {
                    this.fileChooser.setSelectedFiles(fileArray);
                }
            }
            success = true;
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        evt.dropComplete(success);
    }
}

