/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompactionMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new CompactionMetadataSerializer();
    public final Set<Integer> ancestors;
    public final ICardinality cardinalityEstimator;

    public CompactionMetadata(Set<Integer> ancestors, ICardinality cardinalityEstimator) {
        this.ancestors = ancestors;
        this.cardinalityEstimator = cardinalityEstimator;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.COMPACTION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionMetadata that = (CompactionMetadata)o;
        return this.ancestors == null ? that.ancestors == null : this.ancestors.equals(that.ancestors);
    }

    public int hashCode() {
        return this.ancestors != null ? this.ancestors.hashCode() : 0;
    }

    public static class CompactionMetadataSerializer
    implements IMetadataComponentSerializer<CompactionMetadata> {
        @Override
        public int serializedSize(CompactionMetadata component, Version version) throws IOException {
            int size = 0;
            size += TypeSizes.NATIVE.sizeof(component.ancestors.size());
            for (int g : component.ancestors) {
                size += TypeSizes.NATIVE.sizeof(g);
            }
            byte[] serializedCardinality = component.cardinalityEstimator.getBytes();
            return size += TypeSizes.NATIVE.sizeof(serializedCardinality.length) + serializedCardinality.length;
        }

        @Override
        public void serialize(CompactionMetadata component, Version version, DataOutputPlus out) throws IOException {
            out.writeInt(component.ancestors.size());
            for (int g : component.ancestors) {
                out.writeInt(g);
            }
            ByteBufferUtil.writeWithLength(component.cardinalityEstimator.getBytes(), (DataOutput)out);
        }

        @Override
        public CompactionMetadata deserialize(Version version, DataInput in) throws IOException {
            int nbAncestors = in.readInt();
            HashSet<Integer> ancestors = new HashSet<Integer>(nbAncestors);
            for (int i = 0; i < nbAncestors; ++i) {
                ancestors.add(in.readInt());
            }
            HyperLogLogPlus cardinality = HyperLogLogPlus.Builder.build((byte[])ByteBufferUtil.readBytes(in, in.readInt()));
            return new CompactionMetadata(ancestors, (ICardinality)cardinality);
        }
    }
}

