/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.settings;

import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.settings.MLCompletionSettingsCollector;
import com.intellij.completion.ml.sorting.RankingSupport;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="CompletionMLRankingSettings", storages={@Storage(value="completionMLRanking.xml", roamingType=RoamingType.DISABLED)})
public final class CompletionMLRankingSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(CompletionMLRankingSettings.class);
    private final State myState = new State();

    @NotNull
    public static CompletionMLRankingSettings getInstance() {
        CompletionMLRankingSettings completionMLRankingSettings = (CompletionMLRankingSettings)ApplicationManager.getApplication().getService(CompletionMLRankingSettings.class);
        if (completionMLRankingSettings == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(0);
        }
        return completionMLRankingSettings;
    }

    public boolean isRankingEnabled() {
        return this.myState.rankingEnabled;
    }

    public boolean isShowDiffEnabled() {
        return this.myState.showDiff;
    }

    public boolean isDecorateRelevantEnabled() {
        return this.myState.decorateRelevant;
    }

    public void setRankingEnabled(boolean value) {
        if (value == this.isRankingEnabled()) {
            return;
        }
        this.myState.rankingEnabled = value;
        CompletionMLRankingSettings.disableExperiment();
        this.triggerSettingsChanged(value);
    }

    public boolean isLanguageEnabled(@NotNull String rankerId) {
        if (rankerId == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(1);
        }
        return this.myState.language2state.getOrDefault(rankerId, false);
    }

    public void setLanguageEnabled(@NotNull String rankerId, boolean isEnabled) {
        if (rankerId == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(2);
        }
        if (isEnabled == this.isLanguageEnabled(rankerId)) {
            return;
        }
        this.myState.language2state.put(rankerId, isEnabled);
        this.logCompletionState(rankerId, isEnabled);
        CompletionMLRankingSettings.disableExperiment();
        if (this.isRankingEnabled()) {
            MLCompletionSettingsCollector.rankingSettingsChanged(rankerId, isEnabled, CompletionMLRankingSettings.isEnabledByDefault(rankerId), true);
        }
    }

    public void setShowDiffEnabled(boolean isEnabled) {
        if (isEnabled == this.isShowDiffEnabled()) {
            return;
        }
        this.myState.showDiff = isEnabled;
        CompletionMLRankingSettings.disableExperiment();
        MLCompletionSettingsCollector.decorationSettingChanged(isEnabled);
    }

    public void setDecorateRelevantEnabled(boolean isEnabled) {
        this.myState.decorateRelevant = isEnabled;
    }

    @ApiStatus.Internal
    public void updateShowDiffInExperiment(boolean isEnabled) {
        this.myState.showDiff = isEnabled;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(3);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(4);
        }
        this.myState.rankingEnabled = state.rankingEnabled;
        this.myState.showDiff = state.showDiff;
        this.myState.language2state.putAll(state.language2state);
    }

    private void logCompletionState(@NotNull String languageName, boolean isEnabled) {
        if (languageName == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(5);
        }
        boolean enabled = this.myState.rankingEnabled && isEnabled;
        boolean showDiff = enabled && this.myState.showDiff;
        LOG.info("ML Completion " + (enabled ? "enabled" : "disabled") + " ,show diff " + (showDiff ? "on" : "off") + " for: " + languageName);
    }

    private static void disableExperiment() {
        ExperimentStatus status = ExperimentStatus.Companion.getInstance();
        if (!status.isDisabled()) {
            LOG.info("Leave A/B ML completion experiment group");
        }
        status.disable();
    }

    private static boolean isEnabledByDefault(@NotNull String rankerId) {
        if (rankerId == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(6);
        }
        return ExperimentModelProvider.enabledByDefault().contains(rankerId);
    }

    private void triggerSettingsChanged(boolean enabled) {
        for (String ranker : this.getEnabledRankers()) {
            MLCompletionSettingsCollector.rankingSettingsChanged(ranker, enabled, CompletionMLRankingSettings.isEnabledByDefault(ranker), false);
        }
    }

    private List<String> getEnabledRankers() {
        return this.myState.language2state.entrySet().stream().filter(x -> (Boolean)x.getValue()).map(x -> (String)x.getKey()).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/completion/ml/settings/CompletionMLRankingSettings";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rankerId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/completion/ml/settings/CompletionMLRankingSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logCompletionState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        public boolean rankingEnabled;
        public boolean showDiff;
        public boolean decorateRelevant;
        public final Map<String, Boolean> language2state = new HashMap<String, Boolean>();

        public State() {
            ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
            boolean isEAP = ApplicationInfoEx.getInstanceEx().isEAP();
            for (Language language : Language.getRegisteredLanguages()) {
                RankingModelProvider ranker = RankingSupport.INSTANCE.findProviderSafe(language);
                if (ranker == null) continue;
                ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
                if (!experimentStatus.isDisabled() && experimentInfo.getInExperiment()) {
                    boolean useMLRanking = experimentInfo.getShouldRank();
                    this.language2state.put(ranker.getId(), useMLRanking);
                    if (!useMLRanking) continue;
                    LOG.info("ML Completion enabled, experiment group=" + experimentInfo.getVersion() + " for: " + language.getDisplayName());
                    continue;
                }
                this.language2state.put(ranker.getId(), ranker.isEnabledByDefault());
                if (!isEAP) continue;
                this.decorateRelevant |= ranker.getDecoratingPolicy() != DecoratingItemsPolicy.Companion.getDISABLED();
            }
            this.rankingEnabled = this.language2state.containsValue(true);
        }
    }
}

