/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinGW
extends CPPToolSetWithHome {
    private static Pattern W64_MAJOR_MINOR_VERSION_PATTERN = Pattern.compile("^[\\s]*#[\\s]*define[\\s]+__MINGW64_VERSION_((MAJOR)|(MINOR))[\\s]+([\\S]+)$", 8);
    private static Pattern MING32_MAJOR_MINOR_VERSION_PATTERN = Pattern.compile("^[\\s]*#[\\s]*define[\\s]+__MINGW32_((MAJOR)|(MINOR))_VERSION[\\s]+([\\S]+)$", 8);
    private static Pattern OLD_MING32_VERSION_PATTERN = Pattern.compile("^[\\s]*#[\\s]*define[\\s]+__MINGW(32)?_VERSION[\\s]+([\\S]+)$", 8);
    private static Pattern MINGW_W64_GCC_HOME_PATTERN = Pattern.compile("((i686)|(x86_64))-w64-mingw32");
    @Nullable
    private Boolean myIsW64;
    private final File myGCCHome;

    public MinGW(@NotNull File home) {
        if (home == null) {
            MinGW.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.MINGW, home);
        this.myGCCHome = MinGW.findGCCHome(home);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.isMinGW64() ? ToolchainsBundle.message("mingw64", new Object[0]) : super.getName();
        if (string == null) {
            MinGW.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isMinGW64() {
        if (this.myIsW64 == null) {
            File f = MinGW.findMingwHeaderFile(this.myHome);
            this.myIsW64 = "_mingw_mac.h".equals(f.getName());
        }
        return this.myIsW64;
    }

    @Override
    public boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            MinGW.$$$reportNull$$$0(2);
        }
        if (debuggerKind == CPPDebugger.Kind.CUSTOM_GDB) {
            return true;
        }
        if (debuggerKind == CPPDebugger.Kind.BUNDLED_GDB) {
            return !this.isMinGW64();
        }
        if (debuggerKind == CPPDebugger.Kind.BUNDLED_LLDB) {
            return SystemProperties.is((String)"idea.is.internal");
        }
        return false;
    }

    @NotNull
    public String getGCCHomePath() {
        String string = this.myGCCHome.getPath();
        if (string == null) {
            MinGW.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public String readVersion() {
        return MinGW.readVersion(this.myHome);
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        String version = this.readVersion();
        return version == null ? null : MinGW.parseToolVersion(version);
    }

    @Nullable
    public static String readVersion(@Nullable File home) {
        if (home == null) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.logReadVersion("MinGW", null);
            }
            return null;
        }
        try {
            return MinGW.parseVersion(FileUtil.loadFile((File)MinGW.findMingwHeaderFile(home)));
        }
        catch (IOException e) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.LOG.debug("MinGW.readVersion() file: '" + home + "' error", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            MinGW.$$$reportNull$$$0(4);
        }
        return MinGW.checkVersion(version, this.isMinGW64());
    }

    @Nullable
    public static String checkVersion(@NotNull String version, boolean isW64) {
        ToolVersion toolVersion;
        if (version == null) {
            MinGW.$$$reportNull$$$0(5);
        }
        return (toolVersion = MinGW.parseToolVersion(version)).isUnknown() ? ToolchainsBundle.message("settings.select.UnsupportedVersion.unknown", toolVersion) : null;
    }

    @NotNull
    private static ToolVersion parseToolVersion(@NotNull String version) {
        if (version == null) {
            MinGW.$$$reportNull$$$0(6);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
        if (toolVersion == null) {
            MinGW.$$$reportNull$$$0(7);
        }
        return toolVersion;
    }

    @NotNull
    private static File findMingwHeaderFile(@NotNull File home) {
        File gccHome;
        File f;
        if (home == null) {
            MinGW.$$$reportNull$$$0(8);
        }
        if ((f = new File(gccHome = new File(MinGW.findGCCHome(home), "include"), "_mingw_mac.h")).exists()) {
            File file = f;
            if (file == null) {
                MinGW.$$$reportNull$$$0(9);
            }
            return file;
        }
        return new File(gccHome, "_mingw.h");
    }

    @NotNull
    private static File findGCCHome(@NotNull File home) {
        if (home == null) {
            MinGW.$$$reportNull$$$0(10);
        }
        File gccHome = home;
        CommonProcessors.FindFirstProcessor<File> processor = new CommonProcessors.FindFirstProcessor<File>(){

            protected boolean accept(File o) {
                return MINGW_W64_GCC_HOME_PATTERN.matcher(o.getName()).matches();
            }
        };
        Object[] files = home.listFiles();
        if (files != null) {
            ContainerUtil.process((Object[])files, (Processor)processor);
            if (processor.getFoundValue() != null) {
                gccHome = (File)processor.getFoundValue();
            }
        }
        File file = gccHome;
        if (file == null) {
            MinGW.$$$reportNull$$$0(11);
        }
        return file;
    }

    @Contract(value="null -> null")
    public File getGCCSubFile(@Nullable String relativePath) {
        if (relativePath == null) {
            return null;
        }
        return new File(this.myGCCHome, relativePath);
    }

    @Override
    @NotNull
    public File getGDBPath() {
        File file = this.getSubFile("bin/gdb.exe");
        if (file == null) {
            MinGW.$$$reportNull$$$0(12);
        }
        return file;
    }

    @Override
    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<CPPToolSet.Option> options) {
        if (cl == null) {
            MinGW.$$$reportNull$$$0(13);
        }
        if (prepareFor == null) {
            MinGW.$$$reportNull$$$0(14);
        }
        if (options == null) {
            MinGW.$$$reportNull$$$0(15);
        }
        MinGW.prependPathVariable(cl, this.getSubFilePath("bin"));
    }

    static String parseVersion(@NotNull String text) {
        String parsed;
        if (text == null) {
            MinGW.$$$reportNull$$$0(16);
        }
        if ((parsed = MinGW.parseMajorMinorVersion(W64_MAJOR_MINOR_VERSION_PATTERN, text)) != null) {
            return "w64 " + parsed;
        }
        parsed = MinGW.parseMajorMinorVersion(MING32_MAJOR_MINOR_VERSION_PATTERN, text);
        if (parsed != null) {
            return parsed;
        }
        Matcher matcher = OLD_MING32_VERSION_PATTERN.matcher(text);
        if (matcher.find()) {
            String result = matcher.group(2);
            if (matcher.group(1) != null && matcher.find()) {
                result = matcher.group(2);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static String parseMajorMinorVersion(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put(matcher.group(1), matcher.group(4));
            if (matcher.find()) {
                map2.put(matcher.group(1), matcher.group(4));
                return (String)map2.get("MAJOR") + "." + (String)map2.get("MINOR");
            }
        }
        return null;
    }

    @Override
    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.WINDOWS_UNIX;
        if (cidrFileSeparators == null) {
            MinGW.$$$reportNull$$$0(17);
        }
        return cidrFileSeparators;
    }

    public static boolean processMinGWInstallations(CPPToolSet.InstallationProcessor processor) {
        return MinGW.processMinGWInstallations(new File("C:\\"), EnvironmentUtil.getValue((String)"PATH"), processor);
    }

    static boolean processMinGWInstallations(@NotNull File root, @Nullable String pathVariable, CPPToolSet.InstallationProcessor processor) {
        if (root == null) {
            MinGW.$$$reportNull$$$0(18);
        }
        List<Trinity<String, File, Boolean>> found = MinGW.createSortedVersionsList();
        for (File file : Arrays.asList(root, new File(root, "Program Files"), new File(root, "Program Files (x86)"))) {
            File[] dirs = file.listFiles();
            if (dirs == null) continue;
            for (File eachDir : dirs) {
                if (!eachDir.isDirectory() || !StringUtil.containsIgnoreCase((String)eachDir.getName(), (String)"mingw")) continue;
                MinGW.findRecursively(eachDir, 4, found);
            }
        }
        if (pathVariable != null) {
            for (String string : PathEnvironmentVariableUtil.getPathDirs((String)pathVariable)) {
                File parentDir;
                String version;
                if (!PathUtil.getFileName((String)string).equalsIgnoreCase("bin") || !StringUtil.containsIgnoreCase((String)string, (String)"mingw") || (version = MinGW.readVersion(parentDir = new File(string).getParentFile())) == null) continue;
                found.add((Trinity<String, File, Boolean>)Trinity.create((Object)version, (Object)parentDir, (Object)true));
            }
        }
        for (Trinity trinity : found) {
            if (processor.process((File)trinity.second, true)) continue;
            return false;
        }
        return true;
    }

    private static void findRecursively(@NotNull File dir, int maxLevel, List<Trinity<String, File, Boolean>> result) {
        if (dir == null) {
            MinGW.$$$reportNull$$$0(19);
        }
        if (maxLevel == 0) {
            return;
        }
        String version = MinGW.readVersion(dir);
        if (version != null) {
            result.add((Trinity<String, File, Boolean>)Trinity.create((Object)version, (Object)dir, (Object)true));
            return;
        }
        File[] dirs = dir.listFiles();
        if (dirs != null) {
            for (File child : dirs) {
                if (!child.isDirectory()) continue;
                MinGW.findRecursively(child, maxLevel - 1, result);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MinGW";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MinGW";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGCCHomePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToolVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findMingwHeaderFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findGCCHome";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseToolVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMingwHeaderFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findGCCHome";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMinGWInstallations";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

