/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSL
extends CPPToolSet {
    public static final Logger LOG = Logger.getInstance(WSL.class);
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;
    private final String myWslDistributionName;
    private final AtomicNullableLazyValue<@Nullable WSLDistribution> myWslDistribution;
    private static final int RESOLVE_SYMLINK_TIMEOUT = 5000;

    public WSL(@NotNull String name) {
        if (name == null) {
            WSL.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.WSL);
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.myWslDistributionName = name;
        this.myWslDistribution = AtomicNullableLazyValue.createValue(() -> WSL.getDistribution(name));
    }

    @NotNull
    public String getWslDistributionName() {
        String string = this.myWslDistributionName;
        if (string == null) {
            WSL.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return (WSLDistribution)this.myWslDistribution.getValue();
    }

    @Override
    @Nullable
    public String readVersion() {
        WSLDistribution distribution = this.getWslDistribution();
        return distribution != null ? distribution.readReleaseInfo() : null;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        String string = this.readVersion();
        return string == null ? null : ToolVersion.parse((String)string, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            WSL.$$$reportNull$$$0(2);
        }
        return null;
    }

    public static List<String> getDistributions() {
        List result = ContainerUtil.map(WSLCidrUtil.getAvailableDistributions(), dist -> dist.getMsId());
        return Collections.unmodifiableList(result);
    }

    @Override
    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.UNIX;
        if (cidrFileSeparators == null) {
            WSL.$$$reportNull$$$0(3);
        }
        return cidrFileSeparators;
    }

    @Override
    @NotNull
    public File getGDBPath() {
        return new File("/usr/bin/gdb");
    }

    @Override
    public boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            WSL.$$$reportNull$$$0(4);
        }
        return debuggerKind == CPPDebugger.Kind.CUSTOM_GDB;
    }

    @Contract(value="_,null -> null; _,!null -> !null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        String winPath;
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        Object localPath = absoluteOrRelativeEnvPath;
        if (!FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath) && localBaseDir != null) {
            localPath = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)localPath);
        WSLDistribution distribution = this.getWslDistribution();
        if (distribution == null) {
            return canonicalPath;
        }
        if (FileUtil.isUnixAbsolutePath((String)canonicalPath) && (winPath = distribution.getWindowsPath(canonicalPath)) != null) {
            return winPath;
        }
        return canonicalPath;
    }

    @Contract(value="null -> null; !null -> !null")
    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        WSLDistribution distribution = this.getWslDistribution();
        String path = distribution != null ? distribution.getWslPath(localPath) : null;
        return FileUtil.toSystemIndependentName((String)(path != null ? path : localPath));
    }

    @NotNull
    String resolveSymlink(@NotNull String path) {
        WSLDistribution distribution;
        if (path == null) {
            WSL.$$$reportNull$$$0(5);
        }
        if ((distribution = this.getWslDistribution()) == null) {
            String string = path;
            if (string == null) {
                WSL.$$$reportNull$$$0(6);
            }
            return string;
        }
        return WSL.resolveSymlink(path, distribution, this.mySymlinkCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String resolveSymlink(@NotNull String path, @NotNull WSLDistribution distribution, @NotNull @NotNull SLRUMap<@NotNull String, @NotNull String> cache) {
        if (path == null) {
            WSL.$$$reportNull$$$0(7);
        }
        if (distribution == null) {
            WSL.$$$reportNull$$$0(8);
        }
        if (cache == null) {
            WSL.$$$reportNull$$$0(9);
        }
        SLRUMap<String, String> sLRUMap = cache;
        synchronized (sLRUMap) {
            String result = (String)cache.get((Object)path);
            if (result != null) {
                String string = result;
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                if (string == null) {
                    WSL.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        String result = distribution.resolveSymlink(path, 5000);
        SLRUMap<String, String> sLRUMap2 = cache;
        synchronized (sLRUMap2) {
            cache.put((Object)path, (Object)result);
        }
        String string = result;
        if (string == null) {
            WSL.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isAbsolutePath(@NotNull String wslOrWindowsPath) {
        if (wslOrWindowsPath == null) {
            WSL.$$$reportNull$$$0(12);
        }
        return FileUtil.isAbsolutePlatformIndependent((String)wslOrWindowsPath);
    }

    @Nullable
    private static WSLDistribution getDistribution(@NotNull String name) {
        WSLDistribution distribution;
        if (name == null) {
            WSL.$$$reportNull$$$0(13);
        }
        if ((distribution = WSLCidrUtil.getDistributionByMsId(name)) == null) {
            distribution = WSLCidrUtil.getDistributionByExecutionPath(name);
        }
        return distribution;
    }

    public static void initTestWSLToolchain(@NotNull CPPToolchains.Toolchain testToolchain, @NotNull String name) {
        if (testToolchain == null) {
            WSL.$$$reportNull$$$0(14);
        }
        if (name == null) {
            WSL.$$$reportNull$$$0(15);
        }
        if (LOG.assertTrue(WSLCidrUtil.hasAvailableDistributions())) {
            WSLDistribution wslDistribution = WSLCidrUtil.getDistributionByMsId(name);
            if (wslDistribution == null) {
                throw new RuntimeException("WSL: cannot find distribution by name (msId): " + name);
            }
            testToolchain.setToolSetKind(CPPToolSet.Kind.WSL);
            testToolchain.setToolSetPath(wslDistribution.getMsId());
            testToolchain.setCustomCMakePath(System.getProperty("cpp.test.wsl.cmake", "/usr/bin/cmake"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslOrWindowsPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testToolchain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDistribution";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initTestWSLToolchain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

