/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCidrUtil {
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        List<WSLDistribution> distributions = WSLCidrUtil.getInstalledDistributions();
        ArrayList<WSLDistributionWithRootInternal> result = new ArrayList<WSLDistributionWithRootInternal>(distributions.size());
        for (WSLDistribution distribution : distributions) {
            if (distribution instanceof WSLDistributionLegacy) continue;
            result.add(WSLCidrUtil.patchDistribution(distribution));
        }
        List<WSLDistribution> list = Collections.unmodifiableList(result);
        if (list == null) {
            WSLCidrUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static WSLDistributionWithRootInternal patchDistribution(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLCidrUtil.$$$reportNull$$$0(1);
        }
        return new WSLDistributionWithRootInternal(distribution){

            @Override
            @Nullable
            public String getWindowsPath(@NotNull String wslPath) {
                if (wslPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)wslPath, (boolean)true)) {
                    return wslPath;
                }
                return super.getWindowsPath(wslPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wslPath", "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$1", "getWindowsPath"));
            }
        };
    }

    public static boolean hasAvailableDistributions() {
        return !WSLCidrUtil.getInstalledDistributions().isEmpty();
    }

    @NotNull
    private static List<WSLDistribution> getInstalledDistributions() {
        List list = SystemUtil.executeOrRunTask(() -> WslDistributionManager.getInstance().getInstalledDistributions());
        if (list == null) {
            WSLCidrUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static WSLDistribution getDistributionByExecutionPath(@NotNull String exePath) {
        if (exePath == null) {
            WSLCidrUtil.$$$reportNull$$$0(3);
        }
        if (exePath.isEmpty()) {
            return null;
        }
        WSLDistribution result = (WSLDistribution)ContainerUtil.find((Iterable)WSLUtil.getAvailableDistributions(), d -> {
            Path path = d.getExecutablePath();
            return path != null && exePath.equals(path.toString());
        });
        return result == null ? null : WSLCidrUtil.patchDistribution(result);
    }

    @Nullable
    public static WSLDistribution getDistributionByMsId(@NotNull String name) {
        if (name == null) {
            WSLCidrUtil.$$$reportNull$$$0(4);
        }
        if (name.isEmpty()) {
            return null;
        }
        return (WSLDistribution)ContainerUtil.find(WSLCidrUtil.getAvailableDistributions(), d -> name.equals(d.getMsId()));
    }

    public static boolean exists(@NotNull Path path) {
        if (path == null) {
            WSLCidrUtil.$$$reportNull$$$0(5);
        }
        return path.toFile().exists();
    }

    public static boolean delete(@NotNull Path path) {
        if (path == null) {
            WSLCidrUtil.$$$reportNull$$$0(6);
        }
        return path.toFile().delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "patchDistribution";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByExecutionPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByMsId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WSLDistributionWithRootInternal
    extends WSLDistribution {
        private static final NotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = NotNullLazyValue.atomicLazy(() -> {
            HashMap<String, CallSite> result = new HashMap<String, CallSite>();
            String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
            List distributions = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
            WSLUtil.LOG.debug("Processing Lxss registry: " + distributions.size());
            for (String distribution : distributions) {
                String name = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"DistributionName");
                String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"BasePath");
                WSLUtil.LOG.debug(name + ": " + path);
                if (path == null) continue;
                result.put(name, (CallSite)((Object)(path + "\\rootfs")));
            }
            return Collections.unmodifiableMap(result);
        });
        @Nullable
        protected final String myWslRootInHost;

        private WSLDistributionWithRootInternal(@NotNull WSLDistribution wslDistribution) {
            String p9root;
            boolean checkP9root;
            if (wslDistribution == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(0);
            }
            super(wslDistribution);
            File uncRoot = this.getUNCRoot();
            String wslRootInHost = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
            boolean isDirectory = wslRootInHost != null && new File(wslRootInHost).isDirectory();
            boolean bl = checkP9root = Experiments.getInstance().isFeatureEnabled("wsl.prefer.p9.support") || !isDirectory;
            if (Experiments.getInstance().isFeatureEnabled("wsl.p9.support") && checkP9root && FileUtil.exists((String)(p9root = FileUtil.toSystemDependentName((String)uncRoot.getPath())))) {
                wslRootInHost = p9root;
            }
            if (!FileUtil.exists((String)wslRootInHost)) {
                WSLUtil.LOG.warn("WSL rootfs doesn't exist: " + wslRootInHost);
                wslRootInHost = null;
            }
            this.myWslRootInHost = wslRootInHost;
        }

        @Nullable
        public String getWslPath(@NotNull String windowsPath) {
            if (windowsPath == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(1);
            }
            String canonicalPath = FileUtil.toCanonicalPath((String)windowsPath);
            if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)canonicalPath, (boolean)true)) {
                return FileUtil.toSystemIndependentName((String)canonicalPath.substring(this.myWslRootInHost.length()));
            }
            return super.getWslPath(canonicalPath);
        }

        @Nullable
        public String getWindowsPath(@NotNull String wslPath) {
            String windowsPath;
            if (wslPath == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(2);
            }
            if ((windowsPath = WSLUtil.getWindowsPath((String)wslPath, (String)this.getMntRoot())) != null) {
                return windowsPath;
            }
            if (this.myWslRootInHost == null) {
                return null;
            }
            return FileUtil.toSystemDependentName((String)(this.myWslRootInHost + FileUtil.toCanonicalPath((String)wslPath)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslDistribution";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowsPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$WSLDistributionWithRootInternal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getWslPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getWindowsPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WSLHost
    extends LocalHost {
        @NotNull
        private final WSL myWSL;

        public WSLHost(@NotNull WSL wsl) {
            if (wsl == null) {
                WSLHost.$$$reportNull$$$0(0);
            }
            this.myWSL = wsl;
        }

        public boolean isRemote() {
            return true;
        }

        @NotNull
        public OSType getOSType() {
            OSType oSType = OSType.LINUX;
            if (oSType == null) {
                WSLHost.$$$reportNull$$$0(1);
            }
            return oSType;
        }

        @NotNull
        public String convertToLocal(@NotNull String remotePath) {
            if (remotePath == null) {
                WSLHost.$$$reportNull$$$0(2);
            }
            String string = this.myWSL.toLocalPath(null, remotePath);
            if (string == null) {
                WSLHost.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String convertToRemote(@NotNull String localPath) {
            if (localPath == null) {
                WSLHost.$$$reportNull$$$0(4);
            }
            String string = this.myWSL.toEnvPath(localPath);
            if (string == null) {
                WSLHost.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public NamedPipe openNamedPipe() throws ExecutionException {
            NamedPipe namedPipe = RemoteUtil.openPipe((HostMachine)this);
            if (namedPipe == null) {
                WSLHost.$$$reportNull$$$0(6);
            }
            return namedPipe;
        }

        @NotNull
        public CidrProcessBuilder createProcessBuilder() {
            final WSLDistribution distribution = this.myWSL.getWslDistribution();
            return new CidrProcessBuilder(){

                @NotNull
                protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) throws ExecutionException {
                    if (cl == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (params == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (distribution == null) {
                        throw new ExecutionException(ToolchainsBundle.message("wsl.toolchain.not.found", myWSL.getWslDistributionName()));
                    }
                    cl = this.patchCommandLine(distribution, cl, params.isElevated());
                    Object processHandler = params.isColored() ? new LocalHost.ParameterizedColoredProcessHandler(cl, params) : (params.isCapturedOutput() ? new LocalHost.ParameterizedCapturingProcessHandler(cl, params) : new LocalHost.ParameterizedOSProcessHandler(cl, params));
                    CidrToolsUtil.setHasPty((OSProcessHandler)processHandler, (boolean)params.isPty());
                    LocalHost.ParameterizedColoredProcessHandler parameterizedColoredProcessHandler = processHandler;
                    if (parameterizedColoredProcessHandler == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return parameterizedColoredProcessHandler;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "cl";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "params";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$WSLHost$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$WSLHost$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "build";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "build";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        @NotNull
        private GeneralCommandLine patchCommandLine(@NotNull WSLDistribution dist, @NotNull GeneralCommandLine cl, boolean isElevated) throws ExecutionException {
            if (dist == null) {
                WSLHost.$$$reportNull$$$0(7);
            }
            if (cl == null) {
                WSLHost.$$$reportNull$$$0(8);
            }
            if (cl instanceof PtyCommandLine) {
                ((PtyCommandLine)cl).withInitialColumns(2500);
            }
            String exe = cl.getExePath();
            cl.setExePath(this.convertToRemote(exe));
            File wd = cl.getWorkDirectory();
            String wdPath = wd == null ? null : this.convertToRemote(wd.getPath());
            WSLCommandLineOptions options = new WSLCommandLineOptions().setSudo(isElevated).setRemoteWorkingDirectory(wdPath).setSleepTimeoutSec(Registry.doubleValue((String)"clion.wsl.sleep.timeout"));
            GeneralCommandLine generalCommandLine = dist.patchCommandLine(cl, null, options);
            if (generalCommandLine == null) {
                WSLHost.$$$reportNull$$$0(9);
            }
            return generalCommandLine;
        }

        public void killProcessTree(@NotNull BaseProcessHandler handler) {
            if (handler == null) {
                WSLHost.$$$reportNull$$$0(10);
            }
            OSProcessUtil.killProcessTree((Process)handler.getProcess());
        }

        public int sendSignal(int pid, @NotNull String signalName) {
            if (signalName == null) {
                WSLHost.$$$reportNull$$$0(11);
            }
            return SystemUtil.sendUnixSignal((HostMachine)this, pid, signalName);
        }

        @NotNull
        public Path getTempDirectory() {
            Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
            if (path == null) {
                WSLHost.$$$reportNull$$$0(12);
            }
            return path;
        }

        @NotNull
        public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
            if (prefix == null) {
                WSLHost.$$$reportNull$$$0(13);
            }
            Path path = FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
            if (path == null) {
                WSLHost.$$$reportNull$$$0(14);
            }
            return path;
        }

        @NotNull
        public Path getPath(String first, String ... more) {
            String[] others = new String[more.length];
            for (int i = 0; i < more.length; ++i) {
                others[i] = this.convertToLocal(more[i]);
            }
            Path path = Paths.get(this.convertToLocal(first), others);
            if (path == null) {
                WSLHost.$$$reportNull$$$0(15);
            }
            return path;
        }

        @NotNull
        public File resolvePath(@NotNull Path remoteFile) {
            if (remoteFile == null) {
                WSLHost.$$$reportNull$$$0(16);
            }
            return new File(this.convertToLocal(remoteFile.toString()));
        }

        @NotNull
        public File resolvePath(@NotNull File localFile) {
            if (localFile == null) {
                WSLHost.$$$reportNull$$$0(17);
            }
            File file = localFile;
            if (file == null) {
                WSLHost.$$$reportNull$$$0(18);
            }
            return file;
        }

        @NotNull
        public List<String> resolveAndCache(@NotNull List<String> paths) {
            if (paths == null) {
                WSLHost.$$$reportNull$$$0(19);
            }
            List list = ContainerUtil.map(paths, path -> this.convertToLocal((String)path));
            if (list == null) {
                WSLHost.$$$reportNull$$$0(20);
            }
            return list;
        }

        @NotNull
        public String toCanonicalPath(@NotNull String filePath, boolean resolveSymlink) {
            String envFilePath;
            if (filePath == null) {
                WSLHost.$$$reportNull$$$0(21);
            }
            if (!(envFilePath = this.myWSL.toEnvPath(filePath)).startsWith("/mnt/") && resolveSymlink) {
                String resolvedPath = this.myWSL.resolveSymlink(envFilePath);
                String string = this.myWSL.toLocalPath(null, resolvedPath);
                if (string == null) {
                    WSLHost.$$$reportNull$$$0(22);
                }
                return string;
            }
            String string = FileUtil.toCanonicalPath((String)filePath, (boolean)resolveSymlink);
            if (string == null) {
                WSLHost.$$$reportNull$$$0(23);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wsl";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$WSLHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dist";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cl";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signalName";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteFile";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$WSLHost";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToLocal";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToRemote";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "openNamedPipe";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patchCommandLine";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTempDirectory";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTempDirectory";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolvePath";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveAndCache";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCanonicalPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToLocal";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToRemote";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "patchCommandLine";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "killProcessTree";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "sendSignal";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createTempDirectory";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "resolvePath";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveAndCache";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "toCanonicalPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

