/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import com.jetbrains.cidr.execution.ConsoleOptions;
import com.jetbrains.cidr.execution.ElevationOptions;
import com.jetbrains.cidr.execution.EnvironmentFileOptions;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrProgramParametersConfigurator
extends ProgramParametersConfigurator {
    public void configureConfiguration(@NotNull SimpleProgramParameters parameters, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (parameters == null) {
            CidrProgramParametersConfigurator.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            CidrProgramParametersConfigurator.$$$reportNull$$$0(1);
        }
        super.configureConfiguration(parameters, configuration);
        if (parameters instanceof CidrProgramParameters) {
            CidrProgramParameters cidrParameters = (CidrProgramParameters)parameters;
            if (configuration instanceof InputRedirectAware.InputRedirectOptions) {
                InputRedirectAware.InputRedirectOptions redirectOptions = (InputRedirectAware.InputRedirectOptions)configuration;
                String redirectInputPath = this.getRedirectInputPath(redirectOptions, configuration.getProject(), CidrProgramParameters.pathToFile(parameters.getWorkingDirectory()));
                cidrParameters.setRedirectInputPath(redirectInputPath);
            }
            if (configuration instanceof ElevationOptions) {
                ElevationOptions elevationOptions = (ElevationOptions)configuration;
                cidrParameters.setElevated(elevationOptions.isElevated());
            }
            if (configuration instanceof EnvironmentFileOptions) {
                cidrParameters.setEnvironmentFile(((EnvironmentFileOptions)configuration).getEnvironmentFile());
            }
            if (configuration instanceof ConsoleOptions) {
                ConsoleOptions consoleOptions = (ConsoleOptions)configuration;
                cidrParameters.setUseExternalConsole(consoleOptions.isUseExternalConsole());
            }
        }
    }

    @Nullable
    private String getRedirectInputPath(@NotNull InputRedirectAware.InputRedirectOptions redirectOptions, @NotNull Project project, @Nullable File workDirectory) {
        if (redirectOptions == null) {
            CidrProgramParametersConfigurator.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CidrProgramParametersConfigurator.$$$reportNull$$$0(3);
        }
        if (!redirectOptions.isRedirectInput()) {
            return null;
        }
        String redirectInputPath = redirectOptions.getRedirectInputPath();
        if (redirectInputPath == null) {
            return null;
        }
        File redirectInputFile = CidrProgramParameters.pathToFile(redirectInputPath = this.expandPathAndMacros(redirectInputPath, null, project));
        if (redirectInputFile == null) {
            return null;
        }
        if (workDirectory != null && !redirectInputFile.isAbsolute()) {
            redirectInputFile = new File(workDirectory, redirectInputPath);
        }
        return redirectInputFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redirectOptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrProgramParametersConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRedirectInputPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

