/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculatorBase {
    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project, @NotNull String name) {
        OCLanguageKind result;
        if (name == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(0);
        }
        if ((result = OCLanguageKindCalculatorBase.tryFileExtension(project, name)) != null) {
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(name);
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(1);
        }
        if (project == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project, name);
            if (result == null) continue;
            return result;
        }
        return !OCFileTypeHelpers.isHeaderFile(name) ? OCFileTypeHelpers.getLanguageKindStrict(name) : null;
    }

    @NotNull
    static List<OCLanguageKindCalculatorHelper> getHelpers() {
        List list = OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
        if (list == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    static OCLanguageKind trySpecifiedFileType(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculatorBase.trySpecifiedFileType(project, file);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculatorBase.tryFileExtension(project, file.getName());
        if (result != null) {
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinimalKindByExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryFileExtension";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

