/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInterner;
import com.jetbrains.cidr.lang.workspace.compiler.CachedTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CompilerInfoCache {
    private static final ExecutorService ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    @NotNull
    protected final Map<CompilerSettingsKey, Result> myCache = this.createCacheMap();
    @NotNull
    private final Map<CompilerSettingsKey, CompletableFuture<Result>> myInProcess = new HashMap<CompilerSettingsKey, CompletableFuture<Result>>();
    @NotNull
    protected final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ExecutorService createExecutor(int maxProcesses) {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CompilerInfoCache Pool", (int)maxProcesses);
        if (executorService == null) {
            CompilerInfoCache.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    public static <ID extends Comparable<ID>> void flushConsoleMessages(@NotNull @NonNls String prefix, @NotNull Message.Type flushMessagesType, @NotNull MultiMap<ID, Message> messages, @NotNull BiConsumer<ID, String> messagesCollector) {
        if (prefix == null) {
            CompilerInfoCache.$$$reportNull$$$0(1);
        }
        if (flushMessagesType == null) {
            CompilerInfoCache.$$$reportNull$$$0(2);
        }
        if (messages == null) {
            CompilerInfoCache.$$$reportNull$$$0(3);
        }
        if (messagesCollector == null) {
            CompilerInfoCache.$$$reportNull$$$0(4);
        }
        for (Map.Entry entry : ContainerUtil.sorted((Collection)messages.entrySet(), Map.Entry.comparingByKey())) {
            List filtered = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), it -> it.getType() == flushMessagesType ? it.getText() : null);
            if (filtered.isEmpty()) continue;
            LinkedHashSet unique = new LinkedHashSet(filtered);
            String text = "\n" + prefix + ":\n\t" + StringUtil.replace((String)String.join((CharSequence)"\n", unique), (String)"\n", (String)"\n\t");
            messagesCollector.accept((Comparable)entry.getKey(), text);
        }
    }

    @NotNull
    protected Map<CompilerSettingsKey, Result> createCacheMap() {
        return new ConcurrentHashMap<CompilerSettingsKey, Result>();
    }

    @NotNull
    @TestOnly
    public Result getCompilerInfo(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull OCWorkspaceInterner interner) {
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(5);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(6);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(7);
        }
        if (compilerKind == null) {
            CompilerInfoCache.$$$reportNull$$$0(8);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(9);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(10);
        }
        if (environment == null) {
            CompilerInfoCache.$$$reportNull$$$0(11);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(12);
        }
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory), oldKey -> new CompilerSettingsKey(interner.intern(oldKey.getValue())));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, TempFilesPool.INSTANCE);
        Result result = this.getCompilerInfo(interner, compiler, lang, key, switches, ourExecutor, environment);
        if (result == null) {
            CompilerInfoCache.$$$reportNull$$$0(13);
        }
        return result;
    }

    @NotNull
    public CompletableFuture<Result> getCompilerInfoAsync(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull Executor executor, @NotNull TempFilesPool tempFilesPool, @NotNull OCWorkspaceInterner interner) {
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(14);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(15);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(16);
        }
        if (compilerKind == null) {
            CompilerInfoCache.$$$reportNull$$$0(17);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(18);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(19);
        }
        if (environment == null) {
            CompilerInfoCache.$$$reportNull$$$0(20);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(21);
        }
        if (tempFilesPool == null) {
            CompilerInfoCache.$$$reportNull$$$0(22);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(23);
        }
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, tempFilesPool);
        CompletableFuture<Result> completableFuture = this.getCompilerInfoAsync(interner, compiler, lang, key, switches, executor, environment);
        if (completableFuture == null) {
            CompilerInfoCache.$$$reportNull$$$0(24);
        }
        return completableFuture;
    }

    @NotNull
    public static CompilerSettingsKey createCompilerKey(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory) {
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(25);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(26);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(27);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(28);
        }
        StringBuilder builder = new StringBuilder().append(compilerExecutable.getPath()).append("\u0000").append(compilerWorkingDirectory).append("\u0000").append(lang.getDisplayName()).append("\u0000");
        StringUtil.join(switches.getList(CidrCompilerSwitches.Format.RAW), (String)"\u0000", (StringBuilder)builder);
        return new CompilerSettingsKey(builder.toString());
    }

    @NotNull
    Result getCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(29);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(30);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(31);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(32);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(33);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(34);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(35);
        }
        CompletableFuture<Result> future = this.getCompilerInfoAsync(interner, compiler, lang, key, switches, executor, env);
        while (true) {
            Result result;
            ProgressManager.checkCanceled();
            try {
                result = future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            if (result == null) {
                CompilerInfoCache.$$$reportNull$$$0(36);
            }
            return result;
            break;
        }
    }

    @NotNull
    CompletableFuture<Result> getCompilerInfoAsync(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey originalKey, @NotNull CidrCompilerSwitches originalSwitches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        CompletionStage future;
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(37);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(38);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(39);
        }
        if (originalKey == null) {
            CompilerInfoCache.$$$reportNull$$$0(40);
        }
        if (originalSwitches == null) {
            CompilerInfoCache.$$$reportNull$$$0(41);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(42);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(43);
        }
        if (!this.preparseCompilerSwitches(compiler)) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        HostMachine host = env.getHostMachine();
        boolean isWindows = host.getOSType() == OSType.WIN;
        CompilerSplitArgs splitArgs = CompilerSplitArgs.parse(originalSwitches, Set.of(CompilerSplitArgs.ArgType.INCLUDE), true, isWindows);
        List<String> nonBuiltinSearchPaths = splitArgs.getIncludes();
        CidrCompilerSwitches switches = splitArgs.getFilteredSwitches();
        if (splitArgs.hasPrecompiledOrImplicitHeaders() || nonBuiltinSearchPaths.isEmpty()) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        File executable = ((OCCompilerBase)compiler).myExecutable;
        File workingDirectory = ((OCCompilerBase)compiler).myWorkingDirectory;
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, executable, workingDirectory));
        CompletableFuture<Result> result = this.getCompilerInfoAsyncInternal(interner, compiler, lang, key, switches, executor, env);
        CompletionStage completionStage = future = result.thenApply(res -> {
            CompilerInfo info = res.getInfo();
            if (info != null) {
                ArrayList<CallSite> paths = new ArrayList<CallSite>(nonBuiltinSearchPaths);
                for (int i = 0; i < paths.size(); ++i) {
                    String path = (String)paths.get(i);
                    if (env.isEnvAbsolute(path)) continue;
                    paths.set(i, (CallSite)((Object)(env.toEnvPath(workingDirectory.getPath()) + "/" + path)));
                }
                String[] canonicalPaths = host.toCanonicalPath(paths, true);
                List<String> resolvedPaths = CompilerInfoCache.resolvePaths(env, Arrays.asList(canonicalPaths));
                HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
                pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
                for (String path : resolvedPaths) {
                    pathTree.addSearchPathCompacting(new HeadersSearchPath(interner.intern(path), false, HeadersSearchPath.Kind.SYSTEM, false));
                }
                List<HeadersSearchPath> headersSearchPaths = pathTree.getCompactedPaths();
                CidrCompilerSwitches compilerSwitches = lang.isCuda() ? info.getSwitches() : originalSwitches;
                CompilerInfo updatedInfo = new CompilerInfo(compilerSwitches, info.getDefines(), info.getFeatures(), headersSearchPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode());
                return Result.create(originalKey, updatedInfo);
            }
            return Result.error(originalKey, Objects.requireNonNull(res.getError()));
        });
        if (completionStage == null) {
            CompilerInfoCache.$$$reportNull$$$0(44);
        }
        return completionStage;
    }

    protected boolean preparseCompilerSwitches(@NotNull OCCompiler compiler) {
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(45);
        }
        return Registry.is((String)"cidr.compiler.info.parse.switches", (boolean)true) && compiler instanceof OCCompilerBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CompletableFuture<Result> getCompilerInfoAsyncInternal(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        Result cached;
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(46);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(47);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(48);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(49);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(50);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(51);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(52);
        }
        if ((cached = this.myCache.get(key)) != null) {
            CompletableFuture<Result> completableFuture = CompletableFuture.completedFuture(cached);
            if (completableFuture != null) return completableFuture;
            CompilerInfoCache.$$$reportNull$$$0(53);
            return completableFuture;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        cached = this.myCache.get(key);
        if (cached != null) {
            CompletableFuture<Result> completableFuture = CompletableFuture.completedFuture(cached);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            CompilerInfoCache.$$$reportNull$$$0(54);
            return completableFuture;
        }
        CompletableFuture<Result> processing = this.myInProcess.get(key);
        if (processing == null) {
            processing = CompletableFuture.supplyAsync(() -> {
                try {
                    ProgressManager.checkCanceled();
                    Result result = CompilerInfoCache.doCollectCompilerInfo(interner, compiler, lang, key, switches, env);
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myCache.put(key, result);
                        this.myInProcess.remove(key);
                        this.cacheDidChange();
                    }
                    return result;
                }
                catch (ProcessCanceledException e) {
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myInProcess.remove(key);
                    }
                    throw e;
                }
            }, executor);
            this.myInProcess.put(key, processing);
        }
        CompletableFuture<Result> completableFuture = processing;
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        CompilerInfoCache.$$$reportNull$$$0(55);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUncleanResults() {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList keysToRemove = new ArrayList();
            this.myCache.forEach((key, result) -> {
                CompilerInfo info = result.getInfo();
                if (info != null && info.getCompilerExitCode() != 0) {
                    keysToRemove.add(key);
                }
            });
            for (CompilerSettingsKey key2 : keysToRemove) {
                this.myCache.remove(key2);
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Result doCollectCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment env) {
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(56);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(57);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(58);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(59);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(60);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(61);
        }
        CidrEventSpan ignored = new CidrEventSpan("compilerInfo", () -> "collectCompilerInfo", () -> StringUtil.firstLast((String)switches.toString(), (int)1000));
        CompilerInfo info = compiler.collectInfo(lang, switches);
        HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
        pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
        List<HeadersSearchPath> compactedInternedPaths = CompilerInfoCache.resolve(env, pathTree.getCompactedPaths(), interner);
        Result result = Result.create(key, new CompilerInfo(interner.intern(info.getSwitches(), oldSwitches -> new CidrCompilerSwitches(interner.intern(oldSwitches.getList(CidrCompilerSwitches.Format.RAW), switchesList -> ContainerUtil.map((Collection)switchesList, switchValue -> interner.intern(switchValue))))), interner.intern(info.getDefines(), oldDefines -> ContainerUtil.map((Collection)oldDefines, define -> interner.intern(define))), interner.intern(info.getFeatures()), compactedInternedPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode()));
        ignored.close();
        Result result2 = result;
        if (result2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(62);
        }
        return result2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (com.intellij.execution.ExecutionException e) {
                    Result result3 = Result.error(key, e);
                    if (result3 == null) {
                        CompilerInfoCache.$$$reportNull$$$0(63);
                    }
                    return result3;
                }
            }
        }
    }

    @NotNull
    private static List<HeadersSearchPath> resolve(@NotNull CidrToolEnvironment env, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull OCWorkspaceInterner interner) {
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(64);
        }
        if (headersSearchPaths == null) {
            CompilerInfoCache.$$$reportNull$$$0(65);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(66);
        }
        HostMachine host = env.getHostMachine();
        List paths = ContainerUtil.map(headersSearchPaths, p -> p.getPath());
        List resolved = host.resolveAndCache(paths);
        int size = headersSearchPaths.size();
        assert (size == resolved.size());
        ArrayList<HeadersSearchPath> result = new ArrayList<HeadersSearchPath>(size);
        for (int i = 0; i < size; ++i) {
            result.add(new HeadersSearchPath(interner.intern((String)resolved.get(i)), headersSearchPaths.get(i).getFlags()));
        }
        ArrayList<HeadersSearchPath> arrayList = result;
        if (arrayList == null) {
            CompilerInfoCache.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> resolvePaths(@NotNull CidrToolEnvironment env, @NotNull List<String> paths) {
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(68);
        }
        if (paths == null) {
            CompilerInfoCache.$$$reportNull$$$0(69);
        }
        HostMachine host = env.getHostMachine();
        List resolved = host.resolveAndCache(paths);
        assert (paths.size() == resolved.size());
        List list = ContainerUtil.map((Collection)resolved, p -> env.toLocalPath(p));
        if (list == null) {
            CompilerInfoCache.$$$reportNull$$$0(70);
        }
        return list;
    }

    protected void cacheDidChange() {
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CompilerInfoCache.$$$reportNull$$$0(71);
        }
        return this.createSession(indicator, null);
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
        if (indicator == null) {
            CompilerInfoCache.$$$reportNull$$$0(72);
        }
        return new Session(this, indicator, interner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushMessagesType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesCollector";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 15: 
            case 25: 
            case 31: 
            case 39: 
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 7: 
            case 16: 
            case 26: 
            case 33: 
            case 50: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 9: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 10: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: 
            case 23: 
            case 29: 
            case 37: 
            case 46: 
            case 56: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 21: 
            case 34: 
            case 42: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 30: 
            case 38: 
            case 45: 
            case 47: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 32: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 35: 
            case 43: 
            case 52: 
            case 61: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalKey";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSwitches";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headersSearchPaths";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 13: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfo";
                break;
            }
            case 24: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfoAsync";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfoAsyncInternal";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollectCompilerInfo";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flushConsoleMessages";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfo";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfoAsync";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerKey";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "preparseCompilerSwitches";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfoAsyncInternal";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "doCollectCompilerInfo";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resolvePaths";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Message {
        @NotNull
        public final Type type;
        @NotNull
        @NlsSafe
        public final String text;

        public Message(@NotNull Type type, @NotNull String text) {
            if (type == null) {
                Message.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Message.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.text = text;
        }

        @NotNull
        public Type getType() {
            Type type = this.type;
            if (type == null) {
                Message.$$$reportNull$$$0(2);
            }
            return type;
        }

        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                Message.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Type {
            ERROR,
            WARNING;

        }
    }

    public static final class Result {
        @NotNull
        private final CompilerSettingsKey myKey;
        @Nullable
        private final CompilerInfo myInfo;
        @Nullable
        private final Throwable myError;

        @Contract(value="_,null,null -> fail; _,!null,!null -> fail")
        private Result(@NotNull CompilerSettingsKey key, @Nullable CompilerInfo info, @Nullable Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(0);
            }
            assert (info != null ^ error != null);
            this.myKey = key;
            this.myInfo = info;
            this.myError = error;
        }

        @NotNull
        @Contract(pure=true)
        public CompilerSettingsKey getKey() {
            CompilerSettingsKey compilerSettingsKey = this.myKey;
            if (compilerSettingsKey == null) {
                Result.$$$reportNull$$$0(1);
            }
            return compilerSettingsKey;
        }

        @Nullable
        @Contract(pure=true)
        public CompilerInfo getInfo() {
            return this.myInfo;
        }

        @Nullable
        @Contract(pure=true)
        public Throwable getError() {
            return this.myError;
        }

        public static Result create(@NotNull CompilerSettingsKey key, @NotNull CompilerInfo info) {
            if (key == null) {
                Result.$$$reportNull$$$0(2);
            }
            if (info == null) {
                Result.$$$reportNull$$$0(3);
            }
            return new Result(key, info, null);
        }

        public static Result error(@NotNull CompilerSettingsKey key, @NotNull Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(4);
            }
            if (error == null) {
                Result.$$$reportNull$$$0(5);
            }
            return new Result(key, null, error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Session<ID> {
        @NotNull
        private final CompilerInfoCache myCache;
        @NotNull
        private final ProgressIndicator myCallerProgressIndicator;
        @NotNull
        private final ProgressIndicator myJobsProgressIndicator;
        @NotNull
        private final CancelableExecutor myCancelableJobsExecutor;
        @NotNull
        private final TempFilesPool myTempFilesPool;
        @NotNull
        private final OCWorkspaceInterner myInterner;
        @NotNull
        private final List<Pair<Future<List<Message>>, ID>> myJobs;
        @NotNull
        private final AtomicLong myTimeBefore;
        @NotNull
        private final AtomicInteger myCompletedJobs;
        @NotNull
        private final AtomicInteger myExpectedJobsCount;

        private Session(@NotNull CompilerInfoCache cache, @NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
            if (cache == null) {
                Session.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                Session.$$$reportNull$$$0(1);
            }
            this.myTempFilesPool = new CachedTempFilesPool();
            this.myJobs = new ArrayList<Pair<Future<List<Message>>, ID>>();
            this.myTimeBefore = new AtomicLong(0L);
            this.myCompletedJobs = new AtomicInteger(0);
            this.myExpectedJobsCount = new AtomicInteger(0);
            this.myCache = cache;
            this.myInterner = interner != null ? interner : new OCWorkspaceInterner();
            this.myCallerProgressIndicator = indicator;
            this.myCallerProgressIndicator.setIndeterminate(false);
            this.myJobsProgressIndicator = new SensitiveProgressWrapper(indicator);
            this.myCancelableJobsExecutor = new CancelableExecutor(this.myJobsProgressIndicator);
        }

        public void schedule(@NotNull ID id, @NotNull OCResolveConfiguration.ModifiableModel model, @NotNull CidrToolEnvironment environment) {
            if (id == null) {
                Session.$$$reportNull$$$0(2);
            }
            if (model == null) {
                Session.$$$reportNull$$$0(3);
            }
            if (environment == null) {
                Session.$$$reportNull$$$0(4);
            }
            if (this.myTimeBefore.get() == 0L) {
                this.myTimeBefore.set(System.currentTimeMillis());
            }
            CompletableFuture<List<Message>> future = OCWorkspaceImplUtilKt.collectCompilerSettingsAsync(model, environment, this.myCache, this.myCancelableJobsExecutor, this.myTempFilesPool, this.myInterner, () -> {
                int completedJobs = this.myCompletedJobs.incrementAndGet();
                int expectedJobsCount = this.myExpectedJobsCount.get();
                if (expectedJobsCount == 0) {
                    expectedJobsCount = this.myJobs.size();
                }
                if (!this.myCallerProgressIndicator.isIndeterminate() && expectedJobsCount > 0) {
                    this.myCallerProgressIndicator.setFraction((double)completedJobs / (double)expectedJobsCount);
                }
            });
            this.myJobs.add(Pair.create(future, id));
        }

        public void waitForAll(@NotNull MultiMap<ID, Message> result) {
            if (result == null) {
                Session.$$$reportNull$$$0(5);
            }
            Throwable toReport = null;
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    result.putValues(eachJob.second, (Collection)((Future)eachJob.first).get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ProcessCanceledException) {
                        this.myCallerProgressIndicator.cancel();
                        continue;
                    }
                    if (toReport == null) {
                        toReport = new RuntimeException(e);
                        continue;
                    }
                    toReport.addSuppressed(e);
                }
            }
            this.cleanTempFilesPool();
            if (toReport != null) {
                throw toReport;
            }
            this.myCallerProgressIndicator.checkCanceled();
            this.myCallerProgressIndicator.setFraction(1.0);
            long timeAfter = System.currentTimeMillis();
            OCWorkspaceImplUtilKt.getLOG().debug("Compiler info setup took " + StringUtil.formatDuration((long)(timeAfter - this.myTimeBefore.get())));
        }

        public void dispose() {
            this.myJobsProgressIndicator.cancel();
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    ((Future)eachJob.first).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException executionException) {
                }
            }
            this.cleanTempFilesPool();
        }

        public void setExpectedJobsCount(int expectedJobsCount) {
            this.myExpectedJobsCount.set(expectedJobsCount);
        }

        private void cleanTempFilesPool() {
            this.myTempFilesPool.clean();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Session";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "waitForAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class CancelableExecutor
        implements Executor {
            @NotNull
            ProgressIndicator myIndicator;

            private CancelableExecutor(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    CancelableExecutor.$$$reportNull$$$0(0);
                }
                this.myIndicator = indicator;
            }

            @Override
            public void execute(@NotNull Runnable command) {
                if (command == null) {
                    CancelableExecutor.$$$reportNull$$$0(1);
                }
                ourExecutor.execute(() -> {
                    SensitiveProgressWrapper jobIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    ProgressManager.getInstance().runProcess(command, (ProgressIndicator)jobIndicator);
                    if (jobIndicator.isCanceled()) {
                        this.myIndicator.cancel();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Session$CancelableExecutor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

