/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.files;

import com.jetbrains.gsa.data.HashItr;
import com.jetbrains.gsa.files.File;
import com.jetbrains.gsa.files.NontermFile;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.others.Nonterms;
import com.jetbrains.gsa.terms.StartTables;
import com.jetbrains.gsa.terms.Terms;

public class ParserFile
extends File {
    public ParserFile(String filename) {
        super(filename);
    }

    @Override
    public void collect() throws GSAException {
        super.collect();
        Nonterms.checkUndefined();
        Nonterms.buildStartTables();
        String parsersString = Nonterms.writeParsers().toString();
        this.data.appendf("///////////////////////////////////////////////////////\n");
        this.data.appendf("// This file was generated by GSA\n\n");
        HashItr itr = new HashItr(NontermFile.packageTable);
        if (!itr.isDone()) {
            this.data.appendf("\n");
        }
        while (!itr.isDone()) {
            this.data.appendf("import " + itr.get().name + ".*;\n");
            itr.next();
        }
        this.data.appendf("\npublic class Parser\n{\n");
        this.data.appendf("private Lexer lexer;\n");
        this.data.appendf("private Context context;\n");
        this.data.appendf("private TokenInfo lexem, lastLexem;\n\n");
        this.data.appendf("public Parser ( Lexer lexer, Context context ) throws ParseException");
        this.data.appendf("\n{\nthis.lexer = lexer;\nthis.context = context;\nlexem = lexer.getNext();\n");
        if (StartTables.numOfTables > 0) {
            this.data.appendf("start = new boolean[ " + StartTables.numOfTables + " ][];\n\n");
            this.data.appendf("for ( int i = 0; i < " + StartTables.numOfTables + "; i ++ )\n{\nstart [ i ] = new boolean[ ");
            this.data.appendf(Terms.numElems + " ];\nboolean curValue = startRLE[ i ][ 0 ] == 1;\n");
            this.data.appendf("int curTermNumber = 0;\n\nfor ( int j = 1; j < startRLE [ i ].length; j ++ )\n{\n");
            this.data.appendf("for ( int k = 0; k < startRLE[ i ][ j ]; k ++ )\nstart[ i ][ curTermNumber ++ ] = curValue;\n");
            this.data.appendf("\ncurValue = ! curValue;\n}\n}\n");
        }
        this.data.appendf("}\n\n///////////////////////////////////////////////////////\n");
        this.data.appendf("// First table\n\n");
        this.data.appendf(StartTables.writeTables().toString());
        this.data.appendf("\n///////////////////////////////////////////////////////\n");
        this.data.appendf("// Parsers for each nonterm");
        this.data.append(parsersString);
        this.data.appendf("\n}");
    }
}

