/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.others;

import com.jetbrains.gsa.data.HashElem;
import com.jetbrains.gsa.data.HashItr;
import com.jetbrains.gsa.data.HashTab;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.syntax.BCVisitor;
import com.jetbrains.gsa.syntax.BSTVisitor;
import com.jetbrains.gsa.syntax.GrammarParser;
import com.jetbrains.gsa.syntax.NontermNode;
import com.jetbrains.gsa.text.ReadString;
import com.jetbrains.gsa.text.SearchString;
import com.jetbrains.gsa.text.WriteString;

public class Nonterms {
    static HashTab store = new HashTab();

    public static Nonterm add(Nonterm elem) {
        return (Nonterm)store.add(elem);
    }

    public static void checkUndefined() throws GSAException {
        HashItr itr = new HashItr(store);
        while (!itr.isDone()) {
            if (((Nonterm)itr.get()).ntTree == null) {
                throw new GSAException("Nonterm " + itr.get().name + " is undefined");
            }
            itr.next();
        }
    }

    public static void buildStartTables() throws GSAException {
        BSTVisitor visitor;
        Nonterm nonterm;
        boolean notAllBuilt = false;
        HashItr itr = new HashItr(store);
        while (!itr.isDone()) {
            ((Nonterm)itr.get()).status = 0;
            itr.next();
        }
        itr = new HashItr(store);
        while (!itr.isDone()) {
            nonterm = (Nonterm)itr.get();
            if (nonterm.status == 0) {
                nonterm.status = 1;
                visitor = new BSTVisitor(nonterm.name);
                nonterm.ntTree.accept(visitor);
                notAllBuilt |= visitor.notAllBuilt;
                nonterm.status = 2;
            }
            itr.next();
        }
        while (notAllBuilt) {
            notAllBuilt = false;
            itr = new HashItr(store);
            while (!itr.isDone()) {
                nonterm = (Nonterm)itr.get();
                visitor = new BSTVisitor(nonterm.name);
                nonterm.ntTree.accept(visitor);
                notAllBuilt |= visitor.notAllBuilt;
                itr.next();
            }
        }
    }

    public static WriteString writeParsers() throws GSAException {
        WriteString ans = new WriteString();
        HashItr itr = new HashItr(store);
        while (!itr.isDone()) {
            ans.append(((Nonterm)itr.get()).writeParser().toString());
            itr.next();
        }
        return ans;
    }

    public static class Nonterm
    extends HashElem {
        public static final int UNDONE = 0;
        public static final int WORKING = 1;
        public static final int DONE = 2;
        HashTab varsTable;
        HashTab procsTable;
        public NontermNode ntTree = null;
        public int status;

        public Nonterm(String name) {
            super(name);
        }

        public void readGrammar(ReadString grammar) throws GSAException {
            if (this.ntTree != null) {
                throw new GSAException(grammar, "The grammar in class " + this.name + " already defined");
            }
            if (grammar.str.endsWith("*/")) {
                grammar = new ReadString(grammar.str.substring(0, grammar.str.length() - 2), grammar);
            }
            GrammarParser parser = new GrammarParser(grammar);
            this.ntTree = parser.parse();
            this.varsTable = parser.varsTable;
            this.procsTable = parser.procsTable;
            grammar.skipSpace();
            if (grammar.ptr < grammar.str.length()) {
                throw new GSAException(grammar, "End of grammar reached");
            }
        }

        WriteString writeParser() throws GSAException {
            BCVisitor visitor = new BCVisitor();
            WriteString str = visitor.resCode = new WriteString();
            str.curTab = 1;
            str.appendf("\n\npublic void parse( " + this.name + " nonterm ) throws ParseException\n{\n");
            str.appendf("int startPoint = lexem.location[ 0 ];\n");
            str.appendf("int line = lexem.location[ 2 ];\n");
            str.appendf("int offset = lexem.location[ 3 ];\n");
            this.ntTree.accept(visitor);
            str.appendf("nonterm.location = new int[] { startPoint,\nstartPoint == ");
            str.appendf("lexem.location[ 0 ] ? startPoint :\nlastLexem.location[ 1 ], line, offset };\n");
            str.appendf("}");
            return str;
        }

        public WriteString genDefs(ReadString clcode) {
            int ptrSave = clcode.ptr;
            WriteString ans = new WriteString();
            HashItr itr = new HashItr(this.varsTable);
            while (!itr.isDone()) {
                if (!clcode.findSubstr(new SearchString(itr.get().name))) {
                    ans.append("\n" + itr.get().name);
                }
                clcode.ptr = ptrSave;
                itr.next();
            }
            itr = new HashItr(this.procsTable);
            while (!itr.isDone()) {
                String func = ((SemanticHashElem)itr.get()).getFuncPrototype();
                if (!clcode.findSubstr(new SearchString(func))) {
                    ans.append("\n\n" + func + "\n{\n// TODO\n}");
                }
                clcode.ptr = ptrSave;
                itr.next();
            }
            return ans;
        }
    }

    public static class SemanticHashElem
    extends HashElem {
        public boolean isSemanticOr = false;
        private boolean lexemNeeded;

        public SemanticHashElem(String name, boolean lexemNeeded) {
            super(name);
            this.lexemNeeded = lexemNeeded;
        }

        public String getFuncPrototype() {
            if (this.isSemanticOr) {
                return "public boolean " + this.name + "()";
            }
            if (this.lexemNeeded) {
                return "public void " + this.name + "( TokenInfo token )";
            }
            return "public void " + this.name + "()";
        }
    }
}

