/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.syntax;

import com.jetbrains.gsa.data.ListItr;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.syntax.NTCat;
import com.jetbrains.gsa.syntax.NTEmpty;
import com.jetbrains.gsa.syntax.NTFew;
import com.jetbrains.gsa.syntax.NTNonterm;
import com.jetbrains.gsa.syntax.NTOne;
import com.jetbrains.gsa.syntax.NTProduct;
import com.jetbrains.gsa.syntax.NTTerm;
import com.jetbrains.gsa.syntax.NTUnion;
import com.jetbrains.gsa.syntax.NontermNode;
import com.jetbrains.gsa.syntax.Visitor;
import com.jetbrains.gsa.terms.StartTables;
import com.jetbrains.gsa.text.WriteString;

public class BCVisitor
implements Visitor {
    public WriteString resCode;

    private String checkStart(StartTables.StartTable table) {
        if (table.hasOneTerm()) {
            return "lexem.number == " + table.oneTerm;
        }
        return "start[ " + table.getNumber() + " ][ lexem.number ]";
    }

    @Override
    public void visit(NTUnion node) throws GSAException {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        NontermNode emptySon = null;
        if (node.state == 2) {
            this.resCode.appendf("boolean stillUndef = true;\n");
        }
        ListItr itr = new ListItr(node.kids);
        while (!itr.isDone()) {
            NontermNode son = (NontermNode)itr.get();
            if (node.state == 1) {
                this.resCode.appendf("if ( nonterm. " + son.precFunc + " ())\n{\n");
                son.accept(this);
                this.resCode.appendf("}\nelse ");
            } else if (node.state == 2) {
                this.resCode.appendf("if ( stillUndef && " + this.checkStart(son.sTable) + " )\ntry\n{\n");
                son.accept(this);
                this.resCode.appendf("stillUndef = false;\n}\ncatch ( ParseException e ) {}\n");
            } else if (son.sTable.transparent()) {
                emptySon = son;
            } else {
                this.resCode.appendf("if ( " + this.checkStart(son.sTable) + " )\n{\n");
                son.accept(this);
                this.resCode.appendf("}\nelse ");
            }
            itr.next();
        }
        if (emptySon != null) {
            this.resCode.appendf("{\n");
            emptySon.accept(this);
            this.resCode.appendf("}\n");
        } else {
            if (node.state == 2) {
                this.resCode.appendf("if ( stillUndef )");
            }
            this.resCode.appendf("\nthrow new ParseException( lexem.location, \"Parse error\" );\n");
        }
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTCat node) throws GSAException {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        ListItr itr = new ListItr(node.kids);
        while (!itr.isDone()) {
            ((NontermNode)itr.get()).accept(this);
            itr.next();
        }
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTProduct node) throws GSAException {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        node.kids[0].accept(this);
        this.resCode.appendf("while ( " + this.checkStart(node.kids[1].sTable) + " )\n{\n");
        node.kids[1].accept(this);
        node.kids[0].accept(this);
        this.resCode.appendf("}\n");
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTOne node) throws GSAException {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        this.resCode.appendf("if ( " + this.checkStart(node.son.sTable) + " )\n{\n");
        node.son.accept(this);
        this.resCode.appendf("}\n");
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTFew node) throws GSAException {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        this.resCode.appendf("while ( " + this.checkStart(node.son.sTable) + " )\n{\n");
        node.son.accept(this);
        this.resCode.appendf("}\n");
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTTerm node) {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        this.resCode.appendf("if ( lexem.number != " + node.term.number + " )\nthrow new ParseException( lexem.location, \"Missed " + node.term.toQuotedString() + "\" );\nelse\n{\nlastLexem = lexem;\nlexem = lexer.getNext();\n}\n");
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTNonterm node) {
        this.resCode.appendf("nonterm." + node.varName + " = new " + node.nonterm.name + "( context );\n");
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        this.resCode.appendf("parse( nonterm. " + node.varName + " );\n");
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }

    @Override
    public void visit(NTEmpty node) {
        if (node.precFunc != null) {
            this.resCode.appendf("nonterm." + node.precFunc + "();\n");
        }
        if (node.conclFunc != null) {
            this.resCode.appendf("nonterm." + node.conclFunc + (node.wasTerm ? "( lastLexem );\n" : "();\n"));
        }
    }
}

