/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.terms;

import com.jetbrains.gsa.data.HashItr;
import com.jetbrains.gsa.data.List;
import com.jetbrains.gsa.data.ListItr;
import com.jetbrains.gsa.terms.Term;
import com.jetbrains.gsa.terms.Terms;
import com.jetbrains.gsa.text.CType;
import com.jetbrains.gsa.text.WriteString;

public class Automaton {
    static final int ATM_READ = 16384;
    static final int ATM_TERM = 8192;
    static queueElem[] queue = new queueElem[1024];
    static int start = 0;
    static int end = 1;

    static void initQueue() {
        for (int i = 0; i < queue.length; ++i) {
            Automaton.queue[i] = new queueElem();
        }
        Automaton.queue[0].pos = 0;
        Automaton.queue[0].validTerms = new List();
        HashItr itr = new HashItr(Terms.store);
        while (!itr.isDone()) {
            if (!CType.isID(itr.get().name)) {
                Automaton.queue[0].validTerms.add(itr.get());
            }
            itr.next();
        }
    }

    static int getCode(char letter) {
        int curPos = Automaton.queue[Automaton.start].pos;
        int valids = 0;
        List validList = new List();
        Term termFound = null;
        ListItr itr = new ListItr(Automaton.queue[Automaton.start].validTerms);
        while (!itr.isDone()) {
            Term cur = ((Term)itr.get()).cloneTerm();
            if (cur.name.length() == curPos) {
                termFound = cur;
            } else if (cur.name.length() > curPos && cur.name.charAt(curPos) == letter) {
                ++valids;
                validList.add(cur);
            }
            itr.next();
        }
        if (valids == 0 && termFound != null) {
            return 0x2000 | termFound.number;
        }
        if (valids == 1) {
            termFound = (Term)validList.head;
            if (termFound.name.length() == curPos + 1) {
                return 0x6000 | termFound.number;
            }
        }
        if (!validList.isEmpty()) {
            Automaton.queue[Automaton.end].pos = curPos + 1;
            Automaton.queue[Automaton.end].validTerms = validList;
            return 0x4000 | end++;
        }
        return 0;
    }

    public static WriteString writeAutomaton() {
        WriteString ans = new WriteString();
        ans.appendf("public static final int ATM_READ = 16384;\n");
        ans.appendf("public static final int ATM_TERM = 8192;\n\n");
        ans.appendf("public static final int atmTable[][] = {\n");
        Automaton.initQueue();
        while (start < end) {
            ans.appendf("{ ");
            for (int i = 0; i < 256; ++i) {
                ans.appendf(String.valueOf(Automaton.getCode((char)i)));
                if (i >= 255) continue;
                ans.appendf(", ");
            }
            ans.appendf(" }");
            if (++start >= end) continue;
            ans.appendf(",\n");
        }
        ans.appendf("\n};");
        return ans;
    }

    static class queueElem {
        List validTerms;
        int pos;

        queueElem() {
        }
    }
}

