/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.ui.console.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ProfileManager {
    private Map<QueryNode, ProfileData> map = new HashMap<QueryNode, ProfileData>();

    public void addDuration(QueryNode node, long duration, long bddSize) {
        ProfileData profileData = this.map.get(node);
        if (profileData == null) {
            profileData = new ProfileData();
            this.map.put(node, profileData);
        }
        profileData.totalDuration += duration;
        profileData.totalBddSize += bddSize;
        ++profileData.totalCount;
    }

    public void dump(Console console, String query) {
        ArrayList<QueryNode> nodes = new ArrayList<QueryNode>(this.map.keySet());
        nodes.sort((o1, o2) -> {
            long diff2 = this.map.get((Object)o1).totalDuration - this.map.get((Object)o2).totalDuration;
            return diff2 < 0L ? 1 : (diff2 > 0L ? -1 : 0);
        });
        console.println("Operations profile:");
        for (QueryNode node : nodes) {
            ProfileData profileData = this.map.get(node);
            int[] location = node.getLocation();
            String astString = query.substring(location[0], location[1]);
            console.println("time: " + (double)profileData.totalDuration / 1000.0 + ", BDD nodes: " + profileData.totalBddSize + ", invocations: " + profileData.totalCount + ", loc: " + location[2] + ":" + location[3] + "\t" + astString);
        }
    }

    private static class ProfileData {
        private long totalDuration;
        private long totalBddSize;
        private long totalCount;

        private ProfileData() {
        }
    }
}

