/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Factor;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;

public class RelVar
extends Nonterm {
    public Factor factor;
    public RelExpr relExpr;
    private DomainType[] types;
    private int domainIndex;
    private String relName;
    private String[] values;
    private int[] flags;

    public RelVar(Context context) {
        super(context);
    }

    public void setLeft(Factor factor, String left) {
        this.factor = factor;
        this.relName = left;
        this.types = this.context.variablesManager.getRelation(left);
        this.values = new String[this.types.length];
        this.flags = new int[this.types.length];
        this.domainIndex = 0;
    }

    public void domain(TokenInfo token) throws ParseException {
        if (this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-0"));
        }
        String name = token.getString();
        this.context.variablesManager.useDomain(name);
        if (this.context.variablesManager.getDomain(name) == null) {
            this.context.variablesManager.addDomain(name, this.types[this.domainIndex]);
        } else if (this.context.variablesManager.getDomain(name) != this.types[this.domainIndex]) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-1") + name + Messages.getString(RelVar.class.getName() + "-2") + this.context.variablesManager.getDomain(name).getName() + Messages.getString(RelVar.class.getName() + "-3") + this.types[this.domainIndex].getName() + "\"");
        }
        this.values[this.domainIndex] = name;
        this.flags[this.domainIndex++] = 0;
    }

    public void underscore(TokenInfo token) throws ParseException {
        if (this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-5"));
        }
        this.flags[this.domainIndex++] = 2;
    }

    public void term(TokenInfo token) throws ParseException {
        if (this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-6"));
        }
        this.values[this.domainIndex] = token.getString();
        this.flags[this.domainIndex++] = 1;
    }

    public void regexp(TokenInfo token) throws ParseException {
        if (this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-7"));
        }
        this.values[this.domainIndex] = token.getString();
        this.flags[this.domainIndex++] = 3;
    }

    public void id(TokenInfo token) throws ParseException {
        throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-8") + token.getString() + "\"");
    }

    public void finish(TokenInfo token) throws ParseException {
        if (this.domainIndex < this.types.length) {
            throw new ParseException(token.location, Messages.getString(RelVar.class.getName() + "-10"));
        }
        this.relExpr = new RelExprVar(this.relName, this.values, this.flags, this.context, this.factor, this);
    }
}

