/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.parser.Condition;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;

public class Term
extends Nonterm {
    public Expr expr;
    public RelExpr relExpr;
    public int type;
    public Condition condition;
    private int opCode = -1;

    public Term(Context context) {
        super(context);
    }

    public void and(TokenInfo token) {
        this.opCode = this.type == 0 ? 1 : 5;
    }

    public void mul(TokenInfo token) {
        this.opCode = 2;
    }

    public void div(TokenInfo token) {
        this.opCode = 3;
    }

    public void condition() throws ParseException {
        if (this.opCode == -1) {
            this.expr = this.condition.expr;
            this.relExpr = this.condition.relExpr;
            this.type = this.condition.type;
        } else {
            if (this.type != this.condition.type) {
                throw new ParseException(this.condition.location, Messages.getString(Term.class.getName() + "-0"));
            }
            if (this.type == 0) {
                if (this.opCode != 1) {
                    throw new ParseException(this.condition.location, Messages.getString(Term.class.getName() + "-1"));
                }
                this.relExpr = new RelExprBinary(this.opCode, this.relExpr, this.condition.relExpr, this.context, this);
            } else {
                if (this.type == 2 ^ this.opCode == 5) {
                    throw new ParseException(this.condition.location, Messages.getString(Term.class.getName() + "-2"));
                }
                this.expr = new ExprBinary(this.opCode, this.expr, this.condition.expr, this.context);
            }
        }
    }
}

