/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.symtable;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.symtable.AttributeInfo;
import com.jetbrains.sourceglider.symtable.HierarchicalStringsHolder;
import com.jetbrains.sourceglider.symtable.KnownDomainTypes;
import com.jetbrains.sourceglider.symtable.MultiDomainAttribute;
import com.jetbrains.sourceglider.symtable.SingleDomainAttribute;
import com.jetbrains.sourceglider.symtable.Vertex;
import com.jetbrains.sourceglider.symtable.WrongAttributeException;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.utils.Formatter;
import com.jetbrains.sourceglider.utils.PrettyName;
import com.jetbrains.sourceglider.utils.ReflectionHelper;
import com.jetbrains.sourceglider.utils.StringHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SymbolTable {
    private DomainType[] availableTypes;
    private String[] availableTypeNames;
    private HashMap<String, DomainType> nameToType = new HashMap();
    private HierarchicalStringsHolder keyHolder;
    private HierarchicalStringsHolder pathHolder;
    private HierarchicalStringsHolder nameHolder;
    private Map<String, AttributeInfo> fastKeysCache;
    private HashMap<SingleDomainAttribute, AttributeReference> backwardMap;
    private Map<String, Map<Object, String>> metaInfos = new HashMap<String, Map<Object, String>>();
    private boolean allowDomainsResize;
    private int curAnalysisSerialID = 0;
    private final UICallback uiCallback;
    private final Console console;

    public SymbolTable(UICallback uiCallback, Console console, Map<Object, Object> options) {
        this.installDomainTypes(options);
        this.createDomains();
        this.console = console;
        this.uiCallback = uiCallback;
    }

    public void init() {
        this.keyHolder = new HierarchicalStringsHolder();
        this.pathHolder = new HierarchicalStringsHolder();
        this.nameHolder = new HierarchicalStringsHolder();
        this.backwardMap = new HashMap();
        this.fastKeysCache = new HashMap<String, AttributeInfo>();
        for (DomainType availableType : this.availableTypes) {
            availableType.init();
        }
    }

    public void incAnalysisSerialID() {
        ++this.curAnalysisSerialID;
    }

    public void setAllowDomainsResize(boolean value) {
        this.allowDomainsResize = value;
    }

    public boolean allowsDomainResize() {
        return this.allowDomainsResize;
    }

    public void resetFastKeysCache() {
        this.fastKeysCache.clear();
    }

    private void installDomainTypes(Map<Object, Object> options) {
        int i;
        try {
            String[] customTypeNames = (String[])options.get(KnownDomainTypes.class);
            this.availableTypeNames = customTypeNames != null ? customTypeNames : (String[])ReflectionHelper.getAllFieldValues(KnownDomainTypes.class, String.class, "DOM_");
        }
        catch (Throwable e) {
            this.uiCallback.showException(e, true);
            return;
        }
        this.availableTypes = new DomainType[this.availableTypeNames.length];
        for (i = 0; i < this.availableTypeNames.length; ++i) {
            this.availableTypes[i] = new DomainType(this.availableTypeNames[i], this);
            this.nameToType.put(this.availableTypeNames[i], this.availableTypes[i]);
        }
        for (i = 0; i < KnownDomainTypes.metaInfo.length; ++i) {
            Map map2 = this.metaInfos.computeIfAbsent(KnownDomainTypes.metaInfo[i][0], k -> new HashMap());
            map2.put(KnownDomainTypes.metaInfo[i][1], KnownDomainTypes.metaInfo[i][2]);
        }
    }

    private void createDomains() {
        for (int i = 0; i < this.availableTypes.length; ++i) {
            this.availableTypes[i].installDomains(i);
        }
    }

    public String[] getAvailableDomainTypeNames() {
        return this.availableTypeNames;
    }

    public DomainType[] getAvailableDomainTypes() {
        return this.availableTypes;
    }

    public DomainType getDomainType(String name) {
        return this.nameToType.get(name);
    }

    public Map<Object, String> getMetaInfo(DomainType domainType) {
        return this.metaInfos.get(domainType.getName());
    }

    public int getAttributeInt(DomainType type, String attribute) {
        AttributeInfo attrInfo = this.fastKeysCache.get(attribute);
        if (attrInfo == null) {
            attrInfo = this.keyHolder.getValue(attribute);
            this.fastKeysCache.put(attribute, attrInfo);
        }
        if (attrInfo == null) {
            throw new WrongAttributeException(Messages.getString(SymbolTable.class.getName() + "-1") + attribute + "\"");
        }
        if (!attrInfo.allowsDomainType(type, this)) {
            throw new WrongAttributeException(Messages.getString(SymbolTable.class.getName() + "-3") + attribute + Messages.getString(SymbolTable.class.getName() + "-4") + type.getName() + Messages.getString(SymbolTable.class.getName() + "-5") + StringHelper.makeCommaList(attrInfo.getAllowableDomainTypeNames(this)) + " ]");
        }
        return attrInfo.getAttributeInfo((DomainType)type, (SymbolTable)this).index;
    }

    public int findAttributeInt(DomainType type, String attribute) {
        AttributeInfo attrInfo = this.fastKeysCache.get(attribute);
        if (attrInfo == null) {
            attrInfo = this.keyHolder.getValue(attribute);
            this.fastKeysCache.put(attribute, attrInfo);
        }
        if (attrInfo == null) {
            return -1;
        }
        if (!attrInfo.allowsDomainType(type, this)) {
            return -1;
        }
        return attrInfo.getAttributeInfo((DomainType)type, (SymbolTable)this).index;
    }

    public boolean containsAttr(String attribute) {
        if (this.fastKeysCache.get(attribute) != null) {
            return true;
        }
        return this.keyHolder.getValue(attribute) != null;
    }

    public DomainType[] getPossibleAttributeTypes(String key) {
        AttributeInfo attrInfo = this.keyHolder.getValue(key);
        if (attrInfo == null) {
            throw new WrongAttributeException(Messages.getString(SymbolTable.class.getName() + "-7") + key + "\"");
        }
        return attrInfo.getAllowableDomainTypes(this);
    }

    public Attribute getAttribute(DomainType domainType, int value) {
        if (domainType.isIntegerType()) {
            return new Attribute(String.valueOf(value), domainType, null, -1, -1, new PrettyName(String.valueOf(value)));
        }
        AttributeReference attr = this.backwardMap.get(new SingleDomainAttribute(domainType, value));
        return new Attribute(this.keyHolder.getPath(attr.keyVertex), domainType, this.pathHolder.getPath(attr.pathVertex), attr.srcPos, attr.srcLength, new PrettyName(this.nameHolder.getPath(attr.nameVertex), attr.prettyMarkedStart, attr.prettyMarkedEnd));
    }

    public Attribute getAttributeFromKey(DomainType domainType, String key) {
        int attrInt = this.getAttributeInt(domainType, key);
        if (attrInt != -1) {
            return this.getAttribute(domainType, attrInt);
        }
        return null;
    }

    public void addAttribute(Attribute attribute) {
        this.addAttribute(attribute, false);
    }

    public void addAttribute(Attribute attribute, boolean replace) {
        Vertex keyVertex;
        SingleDomainAttribute newAttrInfo;
        DomainType domainType = attribute.getType();
        if (domainType.isIntegerType()) {
            int value = Integer.valueOf(attribute.getKey());
            if (value >= domainType.getNumOfAttrs()) {
                domainType.addAttributes(value - domainType.getNumOfAttrs() + 1);
            }
            return;
        }
        boolean keysCacheFailed = false;
        AttributeInfo attrInfo = this.fastKeysCache.get(attribute.getKey());
        if (attrInfo == null) {
            attrInfo = this.keyHolder.getValue(attribute.getKey());
            keysCacheFailed = true;
        }
        if (attrInfo == null) {
            int value = domainType.addAttribute();
            newAttrInfo = new SingleDomainAttribute(domainType, value);
            keyVertex = this.keyHolder.addString(attribute.getKey(), newAttrInfo);
            this.fastKeysCache.put(attribute.getKey(), newAttrInfo);
        } else if (attrInfo.allowsDomainType(domainType, this)) {
            newAttrInfo = attrInfo.getAttributeInfo(domainType, this);
            if (!replace) {
                AttributeReference attrRef = this.backwardMap.get(newAttrInfo);
                if (attrRef.analysisSerialID == this.curAnalysisSerialID) {
                    return;
                }
                if (attribute.getSrcPos() == -1 && attrRef.srcPos != -1) {
                    return;
                }
            }
            if (!keysCacheFailed) {
                this.keyHolder.getValue(attribute.getKey());
            }
            keyVertex = this.keyHolder.getLastQueryVertex();
        } else {
            int value = domainType.addAttribute();
            newAttrInfo = new SingleDomainAttribute(domainType, value);
            MultiDomainAttribute multiAttrInfo = attrInfo instanceof SingleDomainAttribute ? new MultiDomainAttribute((SingleDomainAttribute)attrInfo, newAttrInfo) : ((MultiDomainAttribute)attrInfo).addAttributeInfo(newAttrInfo);
            keyVertex = this.keyHolder.addString(attribute.getKey(), multiAttrInfo);
            this.fastKeysCache.put(attribute.getKey(), multiAttrInfo);
        }
        this.backwardMap.put(newAttrInfo, new AttributeReference(keyVertex, this.pathHolder.addString(attribute.getCompUnitPath(), null), this.nameHolder.addString(attribute.getPrettyName().getText(), null), attribute.getSrcPos(), attribute.getSrcLength(), attribute.getPrettyName().getMarkStart(), attribute.getPrettyName().getMarkEnd(), this.curAnalysisSerialID));
    }

    public void serialize(ObjectOutputStream out, ThreadCallback threadCallback, double progressPart, String message) throws IOException {
        DomainType[] types;
        int allProgress = 100;
        int progressStart = (int)(progressPart * (double)allProgress);
        int progressLeft = allProgress - (int)progressPart * allProgress;
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-11"));
        threadCallback.informProgress(progressStart, allProgress, message);
        out.writeInt(this.curAnalysisSerialID);
        out.writeObject(this.backwardMap);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.25), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-13"));
        this.keyHolder.serialize(out);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.5), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-15"));
        this.pathHolder.serialize(out);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.75), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-17"));
        this.nameHolder.serialize(out);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        for (DomainType type : types = this.getAvailableDomainTypes()) {
            type.serialize(out);
        }
    }

    public void deserialize(ObjectInputStream in, ThreadCallback threadCallback, double progressPart, String message) throws IOException, ClassNotFoundException {
        DomainType[] types;
        int allProgress = 100;
        int progressStart = (int)(progressPart * (double)allProgress);
        int progressLeft = allProgress - (int)progressPart * allProgress;
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-19"));
        threadCallback.informProgress(progressStart, allProgress, message);
        this.curAnalysisSerialID = in.readInt();
        this.backwardMap = (HashMap)in.readObject();
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.25), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-21"));
        this.keyHolder = HierarchicalStringsHolder.deserialize(in);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.5), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-23"));
        this.pathHolder = HierarchicalStringsHolder.deserialize(in);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        if (threadCallback.checkCancelled()) {
            return;
        }
        threadCallback.informProgress(progressStart + (int)((double)progressLeft * 0.75), allProgress, message);
        this.console.print(Messages.getString(SymbolTable.class.getName() + "-25"));
        this.nameHolder = HierarchicalStringsHolder.deserialize(in);
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-OK"));
        for (DomainType type : types = this.getAvailableDomainTypes()) {
            type.deserialize(in);
        }
        this.createDomains();
    }

    public int getMemoryState() {
        return this.keyHolder.memorySize() + this.pathHolder.memorySize() + this.nameHolder.memorySize() + this.backwardMap.size() * 20;
    }

    public void printInfo() {
        int keyHolderSize = this.keyHolder.memorySize();
        int pathHolderSize = this.pathHolder.memorySize();
        int namesHolderSize = this.nameHolder.memorySize();
        int totalSize = keyHolderSize + pathHolderSize + namesHolderSize + this.backwardMap.size() * 20;
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-27") + Formatter.formatSize(keyHolderSize));
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-28") + Formatter.formatSize(pathHolderSize));
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-29") + Formatter.formatSize(namesHolderSize));
        this.console.println(Messages.getString(SymbolTable.class.getName() + "-30") + Formatter.formatSize(totalSize));
    }

    private static class AttributeReference
    implements Serializable {
        private static final long serialVersionUID = 5065508577142736423L;
        public Vertex keyVertex;
        public Vertex pathVertex;
        public Vertex nameVertex;
        public int srcPos;
        public int srcLength;
        public int prettyMarkedStart;
        public int prettyMarkedEnd;
        public int analysisSerialID;

        AttributeReference(Vertex keyVertex, Vertex pathVertex, Vertex nameVertex, int srcPos, int srcLength, int prettyMarkedStart, int prettyMarkedEnd, int analysisSerialID) {
            this.keyVertex = keyVertex;
            this.pathVertex = pathVertex;
            this.nameVertex = nameVertex;
            this.srcPos = srcPos;
            this.srcLength = srcLength;
            this.prettyMarkedStart = prettyMarkedStart;
            this.prettyMarkedEnd = prettyMarkedEnd;
            this.analysisSerialID = analysisSerialID;
        }
    }
}

