/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui;

import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class FileConfigs
implements IConfigs {
    private final UICallback uiCallback;
    private Properties properties;
    private String configsPath;

    public FileConfigs(String configsPath, UICallback callback) {
        this.configsPath = configsPath;
        this.properties = new Properties();
        this.uiCallback = callback;
    }

    @Override
    public String getValue(String key, String defaultValue) {
        this.read();
        if (this.properties.containsKey(key) && this.properties.getProperty(key).length() > 0) {
            return this.properties.getProperty(key);
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.properties.setProperty(key, defaultValue);
        this.write();
        return defaultValue;
    }

    @Override
    public String getValue(String key, String inputMessage, String defaultValue) {
        this.read();
        if (this.properties.containsKey(key) && this.properties.getProperty(key).length() > 0) {
            return this.properties.getProperty(key);
        }
        if (defaultValue.length() == 0 || defaultValue == null) {
            defaultValue = this.uiCallback.input(inputMessage, defaultValue);
        }
        this.properties.setProperty(key, defaultValue);
        this.write();
        return defaultValue;
    }

    @Override
    public int getIntValue(String key, int defaultValue) {
        return Integer.parseInt(this.getValue(key, Integer.toString(defaultValue)));
    }

    @Override
    public boolean getBooleanValue(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getValue(key, Boolean.toString(defaultValue)));
    }

    @Override
    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
        this.write();
    }

    @Override
    public void setIntValue(String key, int value) {
        this.properties.setProperty(key, Integer.toString(value));
        this.write();
    }

    @Override
    public void setBooleanValue(String key, boolean value) {
        this.properties.setProperty(key, Boolean.toString(value));
        this.write();
    }

    private void read() {
        if (this.configsPath == null) {
            return;
        }
        try {
            File file = new File(this.configsPath);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                this.properties.clear();
                this.properties.load(fis);
                fis.close();
            }
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(FileConfigs.class.getName() + "-0") + this.configsPath + "\"", e, false);
        }
    }

    private void write() {
        try {
            FileOutputStream fos = new FileOutputStream(this.configsPath);
            this.properties.store(fos, null);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(FileConfigs.class.getName() + "-1") + this.configsPath + "\"", e, false);
        }
    }
}

