/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui.console;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.dump.RelationsTextDump;
import com.jetbrains.sourceglider.repositories.HypoteticRelationsRepository;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.scripts.ScriptManager;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.StringHelper;
import com.jetbrains.sourceglider.visitors.Visitor;
import com.jetbrains.sourceglider.visitors.VisitorsManager;
import java.util.HashMap;

public class ConsoleCommandProcessor {
    public static final String KEY_DUMP_LOCATION = "DumpLocation";
    public static final int CMD_RELATIONS = 0;
    public static final int CMD_VISITORS = 1;
    public static final int CMD_SCRIPTS = 2;
    public static final int CMD_HELP = 4;
    public static final int CMD_RUN = 5;
    public static final int CMD_DUMP = 6;
    public static final int CMD_LOAD_DUMP = 7;
    public static final int CMD_MEM = 8;
    public static final int CMD_PROFILE = 9;
    private final ManagerInstancesProvider managerInstancesProvider;
    private final UIInstancesProvider uiInstancesProvider;
    private VisitorsManager visitorsManager;
    private ScriptManager scriptManager;
    private RelationsRepository relationsRepository;
    private HypoteticRelationsRepository hypoteticRepository;

    public ConsoleCommandProcessor(VisitorsManager visitorsManager, ScriptManager scriptManager, RelationsRepository relationsRepository, HypoteticRelationsRepository hypoteticRepository, ManagerInstancesProvider provider) {
        this.visitorsManager = visitorsManager;
        this.scriptManager = scriptManager;
        this.relationsRepository = relationsRepository;
        this.hypoteticRepository = hypoteticRepository;
        this.managerInstancesProvider = provider;
        this.uiInstancesProvider = provider.getUIInstancesProvider();
    }

    public void run(int cmdCode, String[] params, ThreadCallback threadCallback) {
        UICallback viewCallback = this.uiInstancesProvider.getUICallback();
        switch (cmdCode) {
            case 0: {
                String[] list = this.hypoteticRepository.getAvailableRelations();
                for (int i = 0; i < list.length; ++i) {
                    list[i] = this.relationsRepository.containsRelation(list[i]) ? Messages.getString(ConsoleCommandProcessor.class.getName() + "-1") + list[i] : Messages.getString(ConsoleCommandProcessor.class.getName() + "-2") + list[i];
                }
                this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-3") + StringHelper.makeNewlineList(list));
                break;
            }
            case 1: {
                Visitor[] visitors = this.visitorsManager.getAvailableVisitors();
                String[] names = new String[visitors.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = visitors[i].getName();
                }
                this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-4") + StringHelper.makeNewlineList(names));
                break;
            }
            case 2: {
                Script[] scripts = this.scriptManager.getAvailableScripts();
                String[] names = new String[scripts.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = scripts[i].getName();
                }
                this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-5") + StringHelper.makeNewlineList(names));
                break;
            }
            case 4: {
                this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-6") + StringHelper.makeNewlineList(new String[]{Messages.getString(ConsoleCommandProcessor.class.getName() + "-7"), Messages.getString(ConsoleCommandProcessor.class.getName() + "-8") + Messages.getString(ConsoleCommandProcessor.class.getName() + "-9"), Messages.getString(ConsoleCommandProcessor.class.getName() + "-0"), "load", "relations", "visitors", "scripts", "help", "log", "run <script> | <visitor>"}));
                break;
            }
            case 5: {
                if (this.visitorsManager.getVisitor(params[0]) != null) {
                    this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-18") + params[0] + "\"...");
                    this.visitorsManager.run(new Visitor[]{this.visitorsManager.getVisitor(params[0])}, new HashMap(), this.managerInstancesProvider, threadCallback);
                    this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-20"));
                    break;
                }
                if (this.scriptManager.getScript(params[0]) != null) {
                    this.scriptManager.run(this.scriptManager.getScript(params[0]), new HashMap(), this.relationsRepository, threadCallback, this.uiInstancesProvider);
                    break;
                }
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(ConsoleCommandProcessor.class.getName() + "-21") + params[0] + "\"", false);
                break;
            }
            case 6: {
                for (String param : params) {
                    if (this.relationsRepository.containsRelation(param)) continue;
                    viewCallback.showError(Messages.getString(ConsoleCommandProcessor.class.getName() + "-23") + param + "\"", false);
                    return;
                }
                String[] relations = params.length == 0 ? this.relationsRepository.getAvailableRelations() : params;
                String storeFile = this.uiInstancesProvider.getConfigs().getValue(KEY_DUMP_LOCATION, Messages.getString(ConsoleCommandProcessor.class.getName() + "-25"), "");
                if (storeFile.length() == 0) {
                    return;
                }
                try {
                    this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-27") + storeFile + "\"...");
                    new RelationsTextDump(storeFile, this.managerInstancesProvider).writeDump(relations, threadCallback);
                    this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-29"));
                }
                catch (Throwable e) {
                    viewCallback.showException(e, false);
                }
                break;
            }
            case 7: {
                ConsoleCommandProcessor.loadDump(null, threadCallback, this.managerInstancesProvider);
                break;
            }
            case 8: {
                String[] info;
                DomainType.printDomainInfo(this.uiInstancesProvider.getConsole(), this.managerInstancesProvider.getSymbolTable());
                for (String anInfo : info = this.managerInstancesProvider.getBDDManager().getInfo()) {
                    this.uiInstancesProvider.getConsole().println(anInfo);
                }
                this.managerInstancesProvider.getSymbolTable().printInfo();
                this.managerInstancesProvider.getVisitorsManager().printInfo(this.uiInstancesProvider.getConsole());
                break;
            }
            case 9: {
                String[] list = this.relationsRepository.getAvailableRelations();
                for (int i = 0; i < list.length; ++i) {
                    int n = i;
                    list[n] = list[n] + " tup:" + this.relationsRepository.getRelation(list[i]).getNumOfTuples() + " bdd:" + this.relationsRepository.getRelation(list[i]).getNumOfBDDNodes();
                }
                this.uiInstancesProvider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-31") + StringHelper.makeNewlineList(list));
                break;
            }
            default: {
                throw new RuntimeException(Messages.getString(ConsoleCommandProcessor.class.getName() + "-32"));
            }
        }
    }

    public static void loadDump(Task finalizer, ThreadCallback threadCallback, ManagerInstancesProvider provider) {
        String loadFile = provider.getUIInstancesProvider().getConfigs().getValue(KEY_DUMP_LOCATION, Messages.getString(ConsoleCommandProcessor.class.getName() + "-33"), "");
        if (loadFile.length() == 0) {
            return;
        }
        provider.init();
        RelationsTextDump dump2 = new RelationsTextDump(loadFile, provider);
        provider.getSymbolTable().setAllowDomainsResize(true);
        provider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-35") + loadFile + "\"...");
        dump2.readDomainsFromDump(threadCallback, provider.getSymbolTable());
        provider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-37") + loadFile + "\"...");
        dump2.readRelationsFromDump(threadCallback);
        provider.getConsole().println(Messages.getString(ConsoleCommandProcessor.class.getName() + "-39"));
        if (finalizer != null) {
            finalizer.run(threadCallback);
        }
    }
}

