/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestActionUtils {
    private HttpRequestActionUtils() {
    }

    public static void notifyAboutFail(@NotNull AnActionEvent e, @Nls String message2, @Nullable DataKey<? extends JComponent> elementDataKey) {
        if (e == null) {
            HttpRequestActionUtils.$$$reportNull$$$0(0);
        }
        JComponent label = HintUtil.createInformationLabel((String)message2);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(label).setDialogMode(true).setFillColor(HintUtil.getInformationColor()).createBalloon();
        JComponent hyperlinkLabel = (JComponent)ObjectUtils.doIfNotNull(elementDataKey, key2 -> (JComponent)e.getData(key2));
        if (hyperlinkLabel != null) {
            RelativePoint point = new RelativePoint((Component)hyperlinkLabel, new Point(hyperlinkLabel.getWidth() / 2, hyperlinkLabel.getHeight()));
            balloon.show(point, Balloon.Position.below);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            balloon.show(point, Balloon.Position.above);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/httpClient/actions/HttpRequestActionUtils", "notifyAboutFail"));
    }
}

