/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestCollectionProvider;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestFileUtils {
    public static boolean isLogFile(@NotNull Project project, @NotNull String pathToFile) {
        if (project == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(0);
        }
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(1);
        }
        try {
            HttpRequestHistoryManager historyManager = HttpRequestHistoryManager.getInstance(project);
            String pathToLogFile = historyManager.getLogDirectoryPath() + File.separator + historyManager.getLogFile().getName();
            return pathToLogFile.equals(pathToFile);
        }
        catch (HttpRequestInvalidLogFileException ex) {
            return false;
        }
    }

    public static boolean isFileFromCollections(@NotNull String pathToFile) {
        VirtualFile root;
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(2);
        }
        if ((root = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue()) == null) {
            return false;
        }
        return PathUtil.getParentPath((String)pathToFile).equals(root.getPath());
    }

    public static boolean isHttpRequestSystemFile(@NotNull Project project, @NotNull String pathToFile) {
        if (project == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(3);
        }
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(4);
        }
        return HttpRequestFileUtils.isLogFile(project, pathToFile) || HttpRequestFileUtils.isFileFromCollections(pathToFile);
    }

    @RequiresReadLock
    public static boolean hasHttpFilesInProject(@NotNull Project project) {
        Project project2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project2 == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(5);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> {
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project2).uniteWith(ScratchesSearchScope.getScratchesScope((Project)project2));
            boolean hasFilesInProject = FileTypeIndex.containsFileOfType((FileType)HttpRequestFileType.INSTANCE, (GlobalSearchScope)scope);
            return CachedValueProvider.Result.createSingleDependency((Object)hasFilesInProject, (Object)PsiModificationTracker.SERVICE.getInstance((Project)project2).forLanguage((Language)HttpRequestLanguage.INSTANCE));
        });
    }

    public static FileType findFileType(String mimeType) {
        Collection languages;
        PlainTextFileType fileType = PlainTextFileType.INSTANCE;
        if (mimeType != null && mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        if (HttpRequestFileUtils.isJson(languages = Language.findInstancesByMimeType((String)mimeType))) {
            return JsonFileType.INSTANCE;
        }
        for (Language language : languages) {
            LanguageFileType langFileType = language.getAssociatedFileType();
            if (langFileType == null) continue;
            fileType = langFileType;
            break;
        }
        return fileType;
    }

    private static boolean isJson(@NotNull Collection<Language> languages) {
        if (languages == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(6);
        }
        for (Language language : languages) {
            if (language != JsonLanguage.INSTANCE) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestFileUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLogFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileFromCollections";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpRequestSystemFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasHttpFilesInProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

