/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentSslConfigUtil;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestEnvironment {
    private static final String DEFAULT_EXECUTION_ENVIRONMENT = "rest.client.default.execution.environment";
    public static final String DEFAULT_NAME = "<Default Environment>";
    public static final String EMPTY_NAME = "<No Environment>";

    @Nullable
    public abstract String getVariableValue(@NotNull String var1);

    @Nullable
    public SslConfiguration getSslConfiguration() {
        return null;
    }

    public static void setDefaultEnvName(@NotNull Project project, @Nullable String env) {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(0);
        }
        PropertiesComponent.getInstance((Project)project).setValue(DEFAULT_EXECUTION_ENVIRONMENT, env);
    }

    @Nullable
    @NlsSafe
    public static String getDefaultEnvName(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT);
    }

    @Nullable
    public static HttpRequestEnvironment getDefault(@NotNull Project project, @Nullable PsiFile contextFile) throws HttpRequestValidationException {
        String env;
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(2);
        }
        return StringUtil.isNotEmpty((String)(env = PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT))) ? HttpRequestEnvironment.create(project, env, contextFile) : null;
    }

    public static boolean isDefaultEnvironmentValid(@NotNull Project project, @Nullable PsiFile contextFile) {
        String env;
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(3);
        }
        return StringUtil.isNotEmpty((String)(env = PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT))) && !HttpRequestIndex.getEnvironmentFiles(project, env, contextFile).isEmpty();
    }

    public static void clearDefaultIfInvalid(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(4);
        }
        if (!HttpRequestEnvironment.isDefaultEnvironmentValid(project, contextFile)) {
            PropertiesComponent.getInstance((Project)project).setValue(DEFAULT_EXECUTION_ENVIRONMENT, null);
        }
    }

    @NotNull
    public static HttpRequestEnvironment empty() {
        HttpRequestEmptyEnvironment httpRequestEmptyEnvironment = HttpRequestEmptyEnvironment.EMPTY_ENVIRONMENT;
        if (httpRequestEmptyEnvironment == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(5);
        }
        return httpRequestEmptyEnvironment;
    }

    @NotNull
    public static HttpRequestEnvironment create(@NotNull Project project, @Nullable String env, @Nullable PsiFile contextFile) throws HttpRequestValidationException {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)env)) {
            Collection<VirtualFile> files = HttpRequestIndex.getEnvironmentFiles(project, env, contextFile);
            if (files.isEmpty()) {
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.find.environment", env));
            }
            if (files.size() > 2) {
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.multiple.environments", env));
            }
            if (files.size() == 2) {
                return HttpRequestEnvironment.createComposite(project, env, files);
            }
            return HttpRequestEnvironment.create(project, env, files.iterator().next());
        }
        HttpRequestEmptyEnvironment httpRequestEmptyEnvironment = HttpRequestEmptyEnvironment.EMPTY_ENVIRONMENT;
        if (httpRequestEmptyEnvironment == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(7);
        }
        return httpRequestEmptyEnvironment;
    }

    @NotNull
    private static HttpRequestEnvironment createComposite(@NotNull Project project, @NotNull String env, @NotNull Collection<VirtualFile> files) throws HttpRequestValidationException {
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(8);
        }
        if (env == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(9);
        }
        if (files == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(10);
        }
        Iterator<VirtualFile> iterator = files.iterator();
        VirtualFile first = iterator.next();
        VirtualFile second = iterator.next();
        boolean isFirstPrivate = HttpRequestEnvironmentInputFilter.isPrivateEnvFile(first.getName());
        if (isFirstPrivate == HttpRequestEnvironmentInputFilter.isPrivateEnvFile(second.getName())) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.multiple.environments", env));
        }
        HttpRequestEnvironment firstEnv = HttpRequestEnvironment.create(project, env, first);
        HttpRequestEnvironment secondEnv = HttpRequestEnvironment.create(project, env, second);
        return new HttpCompositeEnvironment(isFirstPrivate ? secondEnv : firstEnv, isFirstPrivate ? firstEnv : secondEnv);
    }

    @NotNull
    private static HttpRequestEnvironment create(@NotNull Project project, @NotNull String env, @NotNull VirtualFile vFile) {
        PsiFile file2;
        if (project == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(11);
        }
        if (env == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(12);
        }
        if (vFile == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(13);
        }
        if ((file2 = PsiManager.getInstance((Project)project).findFile(vFile)) instanceof JsonFile) {
            JsonObject environment;
            JsonValue value = ((JsonFile)file2).getTopLevelValue();
            JsonObject jsonObject = environment = value instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)value), (String)env, JsonObject.class) : null;
            if (environment != null) {
                boolean isPrivate = HttpRequestEnvironmentInputFilter.isPrivateEnvFile(vFile.getName());
                return new HttpRequestJsonEnvironment(environment, isPrivate, ScratchRootType.getInstance().containsFile(vFile), !isPrivate ? null : () -> {
                    SmartList values = new SmartList();
                    values.add(vFile.getParent().getPresentableUrl());
                    if (ScratchRootType.getInstance().containsFile(vFile)) {
                        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                        String projectPath = projectDir != null ? projectDir.getPresentableUrl() : null;
                        ContainerUtil.addIfNotNull((Collection)values, (Object)projectPath);
                    }
                    return values;
                });
            }
        }
        HttpRequestEmptyEnvironment httpRequestEmptyEnvironment = HttpRequestEmptyEnvironment.EMPTY_ENVIRONMENT;
        if (httpRequestEmptyEnvironment == null) {
            HttpRequestEnvironment.$$$reportNull$$$0(14);
        }
        return httpRequestEmptyEnvironment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironment";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 7: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEnvName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEnvName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultEnvironmentValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearDefaultIfInvalid";
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpRequestEmptyEnvironment
    extends HttpRequestEnvironment {
        private static final HttpRequestEmptyEnvironment EMPTY_ENVIRONMENT = new HttpRequestEmptyEnvironment();

        private HttpRequestEmptyEnvironment() {
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            if (name == null) {
                HttpRequestEmptyEnvironment.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/httpClient/http/request/environment/HttpRequestEnvironment$HttpRequestEmptyEnvironment", "getVariableValue"));
        }
    }

    private static class HttpRequestJsonEnvironment
    extends HttpRequestEnvironment {
        private final boolean myIsPrivate;
        @Nullable
        private final Supplier<List<String>> myBasePathProvider;
        @NotNull
        private final JsonObject myVariables;
        private final boolean myIsScratch;

        HttpRequestJsonEnvironment(@NotNull JsonObject variables, boolean isPrivate, boolean scratch, @Nullable Supplier<List<String>> basePathProvider) {
            if (variables == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(0);
            }
            this.myVariables = variables;
            this.myIsPrivate = isPrivate;
            this.myBasePathProvider = basePathProvider;
            this.myIsScratch = scratch;
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            if (name == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            JsonLiteral value = (JsonLiteral)JsonUtil.getPropertyValueOfType((JsonObject)this.myVariables, (String)name, JsonLiteral.class);
            if (value instanceof JsonStringLiteral) {
                return ((JsonStringLiteral)value).getValue();
            }
            if (value instanceof JsonBooleanLiteral) {
                return String.valueOf(((JsonBooleanLiteral)value).getValue());
            }
            return value != null ? value.getText() : null;
        }

        @Override
        @Nullable
        public SslConfiguration getSslConfiguration() {
            return this.myIsPrivate ? HttpRequestEnvironmentSslConfigUtil.extractConfigFromJson(this.myVariables, this.myBasePathProvider, this.myIsScratch) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironment$HttpRequestJsonEnvironment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVariableValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpCompositeEnvironment
    extends HttpRequestEnvironment {
        private final HttpRequestEnvironment myApplicationEnv;
        private final HttpRequestEnvironment myPrivateEnv;

        HttpCompositeEnvironment(@NotNull HttpRequestEnvironment applicationEnv, @NotNull HttpRequestEnvironment privateEnv) {
            if (applicationEnv == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(0);
            }
            if (privateEnv == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(1);
            }
            this.myApplicationEnv = applicationEnv;
            this.myPrivateEnv = privateEnv;
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            String value;
            if (name == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(2);
            }
            if ((value = this.myPrivateEnv.getVariableValue(name)) != null) {
                return value;
            }
            return this.myApplicationEnv.getVariableValue(name);
        }

        @Override
        @Nullable
        public SslConfiguration getSslConfiguration() {
            return this.myPrivateEnv.getSslConfiguration();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationEnv";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "privateEnv";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironment$HttpCompositeEnvironment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVariableValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

