/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.DynamicBundle;
import com.intellij.application.options.editor.CodeFoldingOptionsProvider;
import com.intellij.application.options.editor.CodeFoldingOptionsProviderEP;
import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableBuilder;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CodeFoldingConfigurable
extends CompositeConfigurable<CodeFoldingOptionsProvider>
implements EditorOptionsProvider,
Configurable.WithEpDependencies {
    public static final String ID = "editor.preferences.folding";
    private JCheckBox myCbFolding;
    private JPanel myRootPanel;
    private JPanel myFoldingPanel;

    public CodeFoldingConfigurable() {
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"group.code.folding", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.code.folding";
    }

    public JComponent createComponent() {
        this.myFoldingPanel.removeAll();
        JBIterable providers = JBIterable.from(this.getConfigurables()).sort(Comparator.comparing(CodeFoldingConfigurable::sortByTitle));
        for (CodeFoldingOptionsProvider provider2 : providers) {
            JComponent component2 = provider2.createComponent();
            assert (component2 != null) : "CodeFoldingOptionsProvider " + provider2.getClass() + " has a null component.";
            this.myFoldingPanel.add((Component)component2, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public boolean isModified() {
        return this.myCbFolding.isSelected() != EditorSettingsExternalizable.getInstance().isFoldingOutlineShown() || super.isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable.getInstance().setFoldingOutlineShown(this.myCbFolding.isSelected());
        super.apply();
        ApplicationManager.getApplication().invokeLater(() -> CodeFoldingConfigurable.applyCodeFoldingSettingsChanges(), ModalityState.NON_MODAL);
    }

    public static void applyCodeFoldingSettingsChanges() {
        EditorOptionsPanel.reinitAllEditors();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            Project project = editor.getProject();
            if (project == null || project.isDefault()) continue;
            CodeFoldingManager.getInstance(project).scheduleAsyncFoldingUpdate(editor);
        }
        ((EditorOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorOptionsListener.FOLDING_CONFIGURABLE_TOPIC)).changesApplied();
    }

    @Override
    public void reset() {
        this.myCbFolding.setSelected(EditorSettingsExternalizable.getInstance().isFoldingOutlineShown());
        super.reset();
    }

    @Override
    @NotNull
    protected List<CodeFoldingOptionsProvider> createConfigurables() {
        List<CodeFoldingOptionsProvider> list2 = ConfigurableWrapper.createConfigurables(CodeFoldingOptionsProviderEP.EP_NAME);
        if (list2 == null) {
            CodeFoldingConfigurable.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        Set<ExtensionPointName<CodeFoldingOptionsProviderEP>> set2 = Collections.singleton(CodeFoldingOptionsProviderEP.EP_NAME);
        if (set2 == null) {
            CodeFoldingConfigurable.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    private static String sortByTitle(@NotNull CodeFoldingOptionsProvider p) {
        if (p == null) {
            CodeFoldingConfigurable.$$$reportNull$$$0(2);
        }
        String title2 = ConfigurableBuilder.getConfigurableTitle(p);
        if (ApplicationBundle.message((String)"title.general", (Object[])new Object[0]).equals(title2)) {
            return "";
        }
        return title2 != null ? title2 : "z";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/editor/CodeFoldingConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/editor/CodeFoldingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sortByTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCbFolding = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeFoldingConfigurable.class).getString("checkbox.show.code.folding.outline"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(16, 5, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeFoldingConfigurable.class).getString("label.fold.by.default"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFoldingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

