/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.editor.fonts.AppEditorFontOptionsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class AppEditorFontPanel
implements Disposable {
    @NotNull
    private final AppEditorFontOptionsPanel myOptionsPanel;
    @NotNull
    private final FontEditorPreview myPreview;
    @NotNull
    private final EditorColorsScheme myPreviewScheme;
    @NotNull
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    private JLabel myEditorFontLabel;
    @NotNull
    private final JPanel myWarningPanel = this.createMessagePanel();

    public AppEditorFontPanel() {
        this.myTopPanel.add((Component)this.myWarningPanel, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        JBSplitter splitter = new JBSplitter(false, 0.3f);
        this.myPreviewScheme = AppEditorFontPanel.createPreviewScheme();
        this.myOptionsPanel = new AppEditorFontOptionsPanel(this.myPreviewScheme);
        this.myOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myPreview = new FontEditorPreview(() -> this.myPreviewScheme, true){

            @Override
            protected Border getBorder() {
                return JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1);
            }
        };
        splitter.setFirstComponent((JComponent)this.myOptionsPanel);
        splitter.setSecondComponent(this.myPreview.getPanel());
        innerPanel.add((Component)splitter, "Center");
        this.myOptionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                AppEditorFontPanel.this.updatePreview();
                AppEditorFontPanel.this.updateWarning();
            }
        });
        this.myTopPanel.add((Component)innerPanel, "Center");
    }

    private JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new FlowLayout(0));
        messagePanel.add(new JLabel(AllIcons.General.BalloonWarning));
        this.myEditorFontLabel = this.createHyperlinkLabel();
        messagePanel.add(this.myEditorFontLabel);
        JLabel commentLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.defined.in.color.scheme.message", (Object[])new Object[0]));
        commentLabel.setForeground((Color)JBColor.GRAY);
        messagePanel.add(commentLabel);
        return messagePanel;
    }

    @NotNull
    private JLabel createHyperlinkLabel() {
        HoverHyperlinkLabel label2 = new HoverHyperlinkLabel("");
        label2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AppEditorFontPanel.this.navigateToColorSchemeFontConfigurable();
                }
            }
        });
        HoverHyperlinkLabel hoverHyperlinkLabel = label2;
        if (hoverHyperlinkLabel == null) {
            AppEditorFontPanel.$$$reportNull$$$0(0);
        }
        return hoverHyperlinkLabel;
    }

    protected void navigateToColorSchemeFontConfigurable() {
        SearchableConfigurable fontOptions;
        Configurable colorSchemeConfigurable;
        Settings allSettings = Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myTopPanel));
        if (allSettings != null && (colorSchemeConfigurable = allSettings.find("reference.settingsdialog.IDE.editor.colors")) instanceof ColorAndFontOptions && (fontOptions = ((ColorAndFontOptions)colorSchemeConfigurable).findSubConfigurable(ColorAndFontOptions.getFontConfigurableName())) != null) {
            allSettings.select((Configurable)fontOptions);
        }
    }

    public void updateWarning() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        if (!scheme2.isUseAppFontPreferencesInEditor()) {
            this.myEditorFontLabel.setText(ApplicationBundle.message((String)"settings.editor.font.overridden.message", (Object[])new Object[]{scheme2.getEditorFontName(), scheme2.getEditorFontSize()}));
            this.myWarningPanel.setVisible(true);
        } else {
            this.myWarningPanel.setVisible(false);
        }
    }

    public void updatePreview() {
        if (this.myPreviewScheme instanceof EditorFontCache) {
            ((EditorFontCache)this.myPreviewScheme).reset();
        }
        this.myPreview.updateView();
    }

    public void dispose() {
        this.myPreview.disposeUIResources();
    }

    @NotNull
    private static EditorColorsScheme createPreviewScheme() {
        EditorColorsScheme scheme2 = (EditorColorsScheme)EditorColorsManager.getInstance().getSchemeForCurrentUITheme().clone();
        scheme2.setFontPreferences((FontPreferences)new FontPreferencesImpl());
        EditorColorsScheme editorColorsScheme = scheme2;
        if (editorColorsScheme == null) {
            AppEditorFontPanel.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel2 = this.myTopPanel;
        if (jPanel2 == null) {
            AppEditorFontPanel.$$$reportNull$$$0(2);
        }
        return jPanel2;
    }

    @NotNull
    public AppEditorFontOptionsPanel getOptionsPanel() {
        AppEditorFontOptionsPanel appEditorFontOptionsPanel = this.myOptionsPanel;
        if (appEditorFontOptionsPanel == null) {
            AppEditorFontPanel.$$$reportNull$$$0(3);
        }
        return appEditorFontOptionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/fonts/AppEditorFontPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkLabel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewScheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

