/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionService
extends CompletionService {
    private static final Logger LOG = Logger.getInstance(BaseCompletionService.class);
    @Nullable
    protected CompletionProcess myApiCompletionProcess;
    @ApiStatus.Internal
    public static final Key<CompletionContributor> LOOKUP_ELEMENT_CONTRIBUTOR = Key.create((String)"lookup element contributor");

    public void performCompletion(CompletionParameters parameters2, Consumer<? super CompletionResult> consumer) {
        this.myApiCompletionProcess = parameters2.getProcess();
        try {
            super.performCompletion(parameters2, consumer);
        }
        finally {
            this.myApiCompletionProcess = null;
        }
    }

    public void setAdvertisementText(@Nullable @NlsContexts.PopupAdvertisement String text2) {
        if (text2 == null) {
            return;
        }
        if (this.myApiCompletionProcess instanceof CompletionProcessEx) {
            ((CompletionProcessEx)this.myApiCompletionProcess).addAdvertisement(text2, null);
        }
    }

    protected String suggestPrefix(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        int offset = parameters2.getOffset();
        TextRange range2 = position.getTextRange();
        assert (range2.containsOffset(offset)) : position + "; " + offset + " not in " + range2;
        return CompletionData.findPrefixStatic(position, offset);
    }

    @NotNull
    protected PrefixMatcher createMatcher(String prefix2, boolean typoTolerant) {
        return BaseCompletionService.createMatcher(prefix2, true, typoTolerant);
    }

    @NotNull
    private static CamelHumpMatcher createMatcher(String prefix2, boolean caseSensitive, boolean typoTolerant) {
        return new CamelHumpMatcher(prefix2, caseSensitive, typoTolerant);
    }

    protected CompletionResultSet createResultSet(CompletionParameters parameters2, Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, PrefixMatcher matcher) {
        if (contributor == null) {
            BaseCompletionService.$$$reportNull$$$0(0);
        }
        return new BaseCompletionResultSet(consumer, matcher, contributor, parameters2, null, null);
    }

    @Nullable
    public CompletionProcess getCurrentCompletion() {
        return this.myApiCompletionProcess;
    }

    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(1);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(2);
        }
        return completionSorterImpl;
    }

    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher, @NotNull CompletionLocation location) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(3);
        }
        if (weigher == null) {
            BaseCompletionService.$$$reportNull$$$0(4);
        }
        if (location == null) {
            BaseCompletionService.$$$reportNull$$$0(5);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(6);
        }
        return completionSorterImpl;
    }

    public CompletionSorter defaultSorter(CompletionParameters parameters2, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters2);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = this.addWeighersBefore(sorter);
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers((Key)RELEVANCE_KEY)) {
            String id2 = weigher.toString();
            if ("prefix".equals(id2)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id2)) {
                sorter = this.processStatsWeigher(sorter, weigher, location);
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id2, true, false){

                @Nullable
                public Comparable weigh(@NotNull LookupElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return weigher.weigh((Object)element2, (Object)location);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/BaseCompletionService$1", "weigh"));
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class BaseCompletionResultSet
    extends CompletionResultSet {
        protected final CompletionParameters myParameters;
        protected CompletionSorter mySorter;
        @Nullable
        protected final BaseCompletionResultSet myOriginal;

        protected BaseCompletionResultSet(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable BaseCompletionResultSet original) {
            super(prefixMatcher, consumer, contributor);
            this.myParameters = parameters2;
            this.mySorter = sorter;
            this.myOriginal = original;
        }

        public void addElement(@NotNull LookupElement element2) {
            if (element2 == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (!element2.isValid()) {
                LOG.error("Invalid lookup element: " + element2 + " of " + element2.getClass() + " in " + this.myParameters.getOriginalFile() + " of " + this.myParameters.getOriginalFile().getClass());
                return;
            }
            this.mySorter = this.mySorter == null ? CompletionService.getCompletionService().defaultSorter(this.myParameters, this.getPrefixMatcher()) : this.mySorter;
            CompletionResult matched = CompletionResult.wrap((LookupElement)element2, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter);
            if (matched != null) {
                element2.putUserData(LOOKUP_ELEMENT_CONTRIBUTOR, (Object)this.myContributor);
                this.passResult(matched);
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(1);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                BaseCompletionResultSet baseCompletionResultSet = this;
                if (baseCompletionResultSet == null) {
                    BaseCompletionResultSet.$$$reportNull$$$0(2);
                }
                return baseCompletionResultSet;
            }
            return new BaseCompletionResultSet((Consumer<? super CompletionResult>)this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix2) {
            if (prefix2 == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(3);
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix2));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(4);
            }
            return completionResultSet;
        }

        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(5);
            }
            return new BaseCompletionResultSet((Consumer<? super CompletionResult>)this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        public void addLookupAdvertisement(@NotNull @NlsContexts.PopupAdvertisement String text2) {
            if (text2 == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(6);
            }
            CompletionService.getCompletionService().setAdvertisementText(text2);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            PrefixMatcher matcher = this.getPrefixMatcher();
            boolean typoTolerant = matcher instanceof CamelHumpMatcher && ((CamelHumpMatcher)matcher).isTypoTolerant();
            CompletionResultSet completionResultSet = this.withPrefixMatcher(BaseCompletionService.createMatcher(matcher.getPrefix(), false, typoTolerant));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(7);
            }
            return completionResultSet;
        }

        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
        }

        public void restartCompletionWhenNothingMatches() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caseInsensitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

