/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeInsertHandler
implements InsertHandler<LookupElement> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeInsertHandler.class);
    public static final XmlAttributeInsertHandler INSTANCE = new XmlAttributeInsertHandler();
    private final String myNamespaceToInsert;

    public XmlAttributeInsertHandler() {
        this(null);
    }

    public XmlAttributeInsertHandler(@Nullable String namespaceToInsert) {
        this.myNamespaceToInsert = namespaceToInsert;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        boolean hasQuotes;
        if (context2 == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context2.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        PsiFile file2 = context2.getFile();
        CharSequence chars = document.getCharsSequence();
        String quote = XmlEditUtil.getAttributeQuote(file2);
        boolean insertQuotes = WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && StringUtil.isNotEmpty((String)quote);
        boolean bl = hasQuotes = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        if (!hasQuotes) {
            if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=")) {
                document.deleteString(caretOffset, caretOffset + 1);
            }
            PsiElement fileContext = file2.getContext();
            Object toInsert = null;
            if (fileContext != null) {
                if (fileContext.getText().startsWith("\"")) {
                    toInsert = "=''";
                }
                if (fileContext.getText().startsWith("'")) {
                    toInsert = "=\"\"";
                }
            }
            if (toInsert == null) {
                toInsert = "=" + quote + quote;
            }
            if (!insertQuotes) {
                toInsert = "=";
            }
            if (caretOffset < document.getTextLength() && "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)((String)toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
            if ('=' == context2.getCompletionChar()) {
                context2.setAddCompletionChar(false);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + (insertQuotes || hasQuotes ? 2 : 1));
        TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context2.getEditor());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
        if (this.myNamespaceToInsert != null && file2 instanceof XmlFile) {
            String prefix2;
            XmlTag tag2;
            PsiElement element2 = file2.findElementAt(context2.getStartOffset());
            XmlTag xmlTag = tag2 = element2 != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class) : null;
            if (tag2 != null && (prefix2 = ExtendedTagInsertHandler.suggestPrefix((XmlFile)file2, this.myNamespaceToInsert)) != null) {
                prefix2 = XmlAttributeInsertHandler.makePrefixUnique(prefix2, tag2);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(context2.getFile());
                if (helper != null) {
                    Project project = context2.getProject();
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    XmlAttributeInsertHandler.qualifyWithPrefix(prefix2, element2);
                    helper.insertNamespaceDeclaration((XmlFile)file2, editor, Collections.singleton(this.myNamespaceToInsert), prefix2, null);
                }
            }
        }
    }

    private static void qualifyWithPrefix(@NotNull String namespacePrefix, @NotNull PsiElement context2) {
        XmlAttribute attribute;
        String prefix2;
        PsiElement parent;
        if (namespacePrefix == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(3);
        }
        if ((parent = context2.getParent()) instanceof XmlAttribute && !(prefix2 = (attribute = (XmlAttribute)parent).getNamespacePrefix()).equals(namespacePrefix) && StringUtil.isNotEmpty((String)namespacePrefix)) {
            String name = namespacePrefix + ":" + attribute.getLocalName();
            try {
                attribute.setName(name);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static String makePrefixUnique(@NotNull String basePrefix, @NotNull XmlTag context2) {
        if (basePrefix == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(5);
        }
        if (context2.getNamespaceByPrefix(basePrefix).isEmpty()) {
            String string = basePrefix;
            if (string == null) {
                XmlAttributeInsertHandler.$$$reportNull$$$0(6);
            }
            return string;
        }
        int i2 = 1;
        while (!context2.getNamespaceByPrefix(basePrefix + i2).isEmpty()) {
            ++i2;
        }
        String string = basePrefix + i2;
        if (string == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePrefix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/XmlAttributeInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/XmlAttributeInsertHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "makePrefixUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "qualifyWithPrefix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makePrefixUnique";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

