/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.SlowOperations;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyHandler
extends EditorActionHandler
implements CopyAction.TransferableProvider {
    private static final Logger LOG = Logger.getInstance(CopyHandler.class);
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        EditorEx ex;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'copy' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (CopyAction.isSkipCopyPasteForEmptySelection()) {
                return;
            }
            editor.getCaretModel().runForEachCaret(__ -> selectionModel.selectLineAtCaret());
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor.getCaretModel().runForEachCaret(__ -> EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps(editor));
        }
        Transferable transferable = CopyHandler.getSelection(editor, project, file2);
        CopyPasteManager.getInstance().setContents(transferable);
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }

    @Override
    @Nullable
    public Transferable getSelection(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        return CopyHandler.getSelection(editor, project, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Transferable getSelection(@NotNull Editor editor, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CopyHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CopyHandler.$$$reportNull$$$0(4);
        }
        TypingActionsExtension typingActionsExtension = TypingActionsExtension.findForContext(project, editor);
        typingActionsExtension.startCopy(project, editor);
        Transferable transferable = CopyHandler.getSelectionAction(editor, project, file2);
        Transferable transferable2 = transferable;
        if (transferable2 == null) {
            CopyHandler.$$$reportNull$$$0(5);
        }
        return transferable2;
        finally {
            typingActionsExtension.endCopy(project, editor);
        }
    }

    @NotNull
    private static Transferable getSelectionAction(@NotNull Editor editor, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CopyHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            CopyHandler.$$$reportNull$$$0(8);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int[] startOffsets = selectionModel.getBlockSelectionStarts();
        int[] endOffsets = selectionModel.getBlockSelectionEnds();
        ArrayList transferableDataList = new ArrayList();
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> SlowOperations.allowSlowOperations(() -> {
            for (CopyPastePostProcessor processor2 : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
                try {
                    transferableDataList.addAll(processor2.collectTransferableData(file2, editor, startOffsets, endOffsets));
                }
                catch (IndexNotReadyException e) {
                    LOG.debug((Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }));
        String text2 = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, transferableDataList) : selectionModel.getSelectedText();
        String rawText = TextBlockTransferable.convertLineSeparators(text2, "\n", transferableDataList);
        String escapedText = null;
        for (CopyPastePreProcessor processor2 : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            try {
                escapedText = processor2.preprocessOnCopy(file2, startOffsets, endOffsets, rawText);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (escapedText == null) continue;
            break;
        }
        return new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDataList, escapedText != null ? new RawText(rawText) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CopyHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

