/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordHandler
extends EditorActionHandler.ForEachCaret {
    private static final Logger LOG = Logger.getInstance(SelectWordHandler.class);
    private final EditorActionHandler myOriginalHandler;

    public SelectWordHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        Project project;
        if (editor == null) {
            SelectWordHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            SelectWordHandler.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: execute(editor='" + editor + "')");
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        TextRange range2 = SelectWordHandler.selectWord(caret, project);
        if (editor instanceof EditorWindow && (range2 == null || !SelectWordHandler.isInsideEditableInjection((EditorWindow)editor, range2, project) || TextRange.from((int)0, (int)editor.getDocument().getTextLength()).equals((Object)new TextRange(caret.getSelectionStart(), caret.getSelectionEnd())))) {
            editor = ((EditorWindow)editor).getDelegate();
            caret = ((InjectedCaret)caret).getDelegate();
            range2 = SelectWordHandler.selectWord(caret, project);
        }
        if (range2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        } else {
            caret.setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static boolean isInsideEditableInjection(EditorWindow editor, TextRange range2, Project project) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return true;
        }
        List editables = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file2, range2);
        return editables.size() == 1 && range2.equals(editables.get(0));
    }

    @Nullable(value="null means unable to select")
    private static @Nullable(value="null means unable to select") TextRange selectWord(@NotNull Caret caret, @NotNull Project project) {
        if (caret == null) {
            SelectWordHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SelectWordHandler.$$$reportNull$$$0(3);
        }
        ThrowableComputable computable = () -> (TextRange)ReadAction.compute(() -> SelectWordHandler.doSelectWord(caret, project));
        try {
            return (TextRange)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, EditorBundle.message((String)"select.word.progress", (Object[])new Object[0]), true, project);
        }
        catch (ProcessCanceledException pce) {
            return null;
        }
        catch (Exception e) {
            LOG.error("Cannot select word at given offset", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static TextRange doSelectWord(@NotNull Caret caret, @NotNull Project project) {
        PsiElement elementInOtherTree;
        PsiElement anotherElement;
        if (caret == null) {
            SelectWordHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SelectWordHandler.$$$reportNull$$$0(5);
        }
        Document document = caret.getEditor().getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        int caretOffset = SelectWordHandler.adjustCaretOffset(caret);
        PsiElement element2 = SelectWordHandler.findElementAt(file2, caretOffset);
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = SelectWordHandler.findElementAt(file2, caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element2 = anotherElement;
        }
        while (element2 instanceof PsiWhiteSpace || element2 != null && StringUtil.isEmptyOrSpaces((String)element2.getText())) {
            while (element2.getNextSibling() == null) {
                if (element2 instanceof PsiFile) {
                    return null;
                }
                PsiElement parent = element2.getParent();
                PsiElement[] children2 = parent.getChildren();
                if (children2.length > 0 && children2[children2.length - 1] == element2) {
                    element2 = parent;
                    continue;
                }
                element2 = parent;
                break;
            }
            if (element2 instanceof PsiFile) {
                return null;
            }
            if ((element2 = element2.getNextSibling()) == null) {
                return null;
            }
            TextRange range3 = element2.getTextRange();
            if (range3 == null) {
                return null;
            }
            caretOffset = range3.getStartOffset();
        }
        if (element2 instanceof OuterLanguageElement && (elementInOtherTree = file2.getViewProvider().findElementAt(element2.getTextOffset(), element2.getLanguage())) != null && elementInOtherTree.getContainingFile() != element2.getContainingFile()) {
            while (elementInOtherTree != null && elementInOtherTree.getPrevSibling() == null) {
                elementInOtherTree = elementInOtherTree.getParent();
            }
            if (elementInOtherTree != null && elementInOtherTree.getTextOffset() == caretOffset) {
                element2 = elementInOtherTree;
            }
        }
        SelectWordHandler.checkElementRange(document, element2);
        TextRange selectionRange = new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
        Ref minimumRange = new Ref((Object)new TextRange(0, document.getTextLength()));
        SelectWordUtil.processRanges(element2, document.getCharsSequence(), caretOffset, caret.getEditor(), (Processor<? super TextRange>)((Processor)range2 -> {
            if (range2.contains(selectionRange) && !range2.equals((Object)selectionRange) && ((TextRange)minimumRange.get()).contains(range2)) {
                minimumRange.set(range2);
                return true;
            }
            return false;
        }));
        return (TextRange)minimumRange.get();
    }

    private static void checkElementRange(Document document, PsiElement element2) {
        if (element2 != null && element2.getTextRange().getEndOffset() > document.getTextLength()) {
            throw new AssertionError((Object)DebugUtil.diagnosePsiDocumentInconsistency(element2, document));
        }
    }

    private static int adjustCaretOffset(@NotNull Caret caret) {
        int caretOffset;
        if (caret == null) {
            SelectWordHandler.$$$reportNull$$$0(6);
        }
        if ((caretOffset = caret.getOffset()) == 0) {
            return caretOffset;
        }
        CharSequence text2 = caret.getEditor().getDocument().getCharsSequence();
        char prev2 = text2.charAt(caretOffset - 1);
        if (caretOffset < text2.length() && !Character.isJavaIdentifierPart(text2.charAt(caretOffset)) && Character.isJavaIdentifierPart(prev2)) {
            return caretOffset - 1;
        }
        if ((caretOffset == text2.length() || Character.isWhitespace(text2.charAt(caretOffset))) && !Character.isWhitespace(prev2)) {
            return caretOffset - 1;
        }
        return caretOffset;
    }

    @Nullable
    private static PsiElement findElementAt(@NotNull PsiFile file2, int caretOffset) {
        PsiElement elementAt;
        if (file2 == null) {
            SelectWordHandler.$$$reportNull$$$0(7);
        }
        return (elementAt = file2.findElementAt(caretOffset)) != null && SelectWordHandler.isLanguageExtension(file2, elementAt) ? file2.getViewProvider().findElementAt(caretOffset, file2.getLanguage()) : elementAt;
    }

    private static boolean isLanguageExtension(@NotNull PsiFile file2, @NotNull PsiElement elementAt) {
        if (file2 == null) {
            SelectWordHandler.$$$reportNull$$$0(8);
        }
        if (elementAt == null) {
            SelectWordHandler.$$$reportNull$$$0(9);
        }
        Language elementLanguage = elementAt.getLanguage();
        if (file2.getLanguage() instanceof CompositeLanguage) {
            Language[] extensions2;
            CompositeLanguage compositeLanguage = (CompositeLanguage)file2.getLanguage();
            for (Language extension2 : extensions2 = compositeLanguage.getLanguageExtensionsForFile(file2)) {
                if (extension2 != elementLanguage) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/SelectWordHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectWord";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doSelectWord";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustCaretOffset";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementAt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLanguageExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

