/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.codeInsight.highlighting.BackgroundHighlightingUtil;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class BackgroundHighlighter
implements StartupActivity.DumbAware {
    private final Alarm myAlarm = new Alarm();

    BackgroundHighlighter() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() || !IdentifierHighlighterPassFactory.isEnabled()) {
            return;
        }
        Disposable activityDisposable = ExtensionPointUtil.createExtensionDisposable((Object)this, (ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY);
        Disposer.register((Disposable)project, (Disposable)activityDisposable);
        this.registerListeners(project, activityDisposable);
    }

    private void registerListeners(final @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            BackgroundHighlighter.$$$reportNull$$$0(2);
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                BackgroundHighlighter.this.onCaretUpdate(e.getEditor(), project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
        SelectionListener selectionListener2 = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() != project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && oldRange.isEmpty() == newRange.isEmpty()) {
                    return;
                }
                BackgroundHighlighter.this.updateHighlighted(project, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$2", "selectionChanged"));
            }
        };
        eventMulticaster.addSelectionListener(selectionListener2, parentDisposable);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                EditorFactory.getInstance().editors(e.getDocument(), project).forEach(editor -> BackgroundHighlighter.this.updateHighlighted(project, (Editor)editor));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$3", "documentChanged"));
            }
        };
        eventMulticaster.addDocumentListener(documentListener, parentDisposable);
        project.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BackgroundHighlighter.this.myAlarm.cancelAllRequests();
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    BackgroundHighlighter.this.clearBraces(project, ((TextEditor)oldEditor).getEditor());
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    BackgroundHighlighter.this.updateHighlighted(project, ((TextEditor)newEditor).getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$4", "selectionChanged"));
            }
        });
        project.getMessageBus().connect(parentDisposable).subscribe(TemplateManager.TEMPLATE_STARTED_TOPIC, state -> {
            if (state.isFinished()) {
                return;
            }
            this.updateHighlighted(project, state.getEditor());
            state.addTemplateStateListener(new TemplateEditingAdapter(){

                @Override
                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    BackgroundHighlighter.this.updateHighlighted(project, state.getEditor());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/highlighting/BackgroundHighlighter$5", "templateFinished"));
                }
            });
        });
    }

    private void onCaretUpdate(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            BackgroundHighlighter.$$$reportNull$$$0(3);
        }
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (editor.getProject() != project || selectionModel.hasSelection()) {
            return;
        }
        this.updateHighlighted(project, editor);
    }

    private void updateHighlighted(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            BackgroundHighlighter.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editor.getDocument().isInBulkUpdate()) {
            return;
        }
        BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project, editor, (foundFile, newEditor) -> {
            IdentifierHighlighterPass pass = new IdentifierHighlighterPassFactory().createHighlightingPass((PsiFile)foundFile, (Editor)newEditor, TextRange.from((int)0, (int)foundFile.getTextLength()));
            if (pass != null) {
                pass.doCollectInformation();
            }
            return pass;
        }, (foundFile, newEditor, pass) -> {
            BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project, (Editor)newEditor, this.myAlarm, (PsiFile)foundFile);
            handler2.updateBraces();
            if (pass != null) {
                pass.doApplyInformationToEditor();
            }
        });
    }

    private void clearBraces(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            BackgroundHighlighter.$$$reportNull$$$0(8);
        }
        BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project, editor, (__, ___) -> null, (foundFile, newEditor, __) -> {
            BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project, (Editor)newEditor, this.myAlarm, (PsiFile)foundFile);
            handler2.clearBraceHighlighters();
        });
    }

    @NotNull
    static Alarm getAlarm() {
        Alarm alarm2 = Objects.requireNonNull((BackgroundHighlighter)BackgroundHighlighter.POST_STARTUP_ACTIVITY.findExtension(BackgroundHighlighter.class)).myAlarm;
        if (alarm2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(9);
        }
        return alarm2;
    }

    @TestOnly
    static void enableListenersInTest(@NotNull Project project, @NotNull Disposable disposable2) {
        if (project == null) {
            BackgroundHighlighter.$$$reportNull$$$0(10);
        }
        if (disposable2 == null) {
            BackgroundHighlighter.$$$reportNull$$$0(11);
        }
        ((BackgroundHighlighter)POST_STARTUP_ACTIVITY.findExtension(BackgroundHighlighter.class)).registerListeners(project, disposable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlighter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCaretUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlighted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearBraces";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableListenersInTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

